/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource.simulink;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.index.repository.history.match.name.PathByNameIndex;
import com.teamscale.index.resource.SimulinkModelInfoIndex;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.simulink.ui.SimulinkBlockUIData;

public class SimulinkModelResolver
implements SimulinkBlockUIData.IModelResolver {
    private final CommitResolvingStorageSystem projectStorageSystem;
    private final HistoryAccessOption historyAccessOption;
    private static final Logger LOGGER = LogManager.getLogger();

    public SimulinkModelResolver(CommitResolvingStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption) {
        this.projectStorageSystem = projectStorageSystem;
        this.historyAccessOption = historyAccessOption;
    }

    public String resolveModelPath(String modelName, String containedBlock, boolean isReferencedSubsystem) {
        try {
            List uniformPaths;
            if (isReferencedSubsystem) {
                PathByNameIndex pathByNameIndex = (PathByNameIndex)this.projectStorageSystem.openProjectIndex(PathByNameIndex.class, this.historyAccessOption);
                uniformPaths = pathByNameIndex.getPathsByNames(Arrays.asList(modelName + ".slx", modelName + ".mdl")).stream().filter(Objects::nonNull).flatMap(path -> path.getAllPaths().stream()).collect(Collectors.toList());
            } else {
                SimulinkModelInfoIndex modelInfoIndex = (SimulinkModelInfoIndex)this.projectStorageSystem.openProjectIndex(SimulinkModelInfoIndex.class, this.historyAccessOption);
                uniformPaths = modelInfoIndex.getUniformPathsForBlockId(containedBlock);
            }
            if (uniformPaths.isEmpty()) {
                return null;
            }
            if (uniformPaths.size() > 1) {
                LOGGER.warn("Found multiple possible candidates for lookup of block reference " + containedBlock + ": " + String.valueOf(uniformPaths));
            }
            return (String)uniformPaths.get(0);
        }
        catch (StorageException e) {
            LOGGER.error("Failed to access storage for reference lookup of " + containedBlock, (Throwable)e);
            return null;
        }
    }
}

