/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.performance.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.core.runtime.api.performance.PerformanceAggregateEntry;
import com.teamscale.core.runtime.api.performance.PerformanceIndexBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import com.teamscale.service.system.performance.debug.PerformanceDataDownloadServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.ToLongFunction;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.profiler.DetailedStorageProfiler;
import org.conqat.engine.persistence.store.profiler.StoreOperationStatistics;
import org.conqat.lib.commons.collections.PairList;

@Path(value="api/system/performance/debug/store-details.csv")
public class PerformanceStoreService
extends PerformanceDataDownloadServiceBase {
    private static final String[] HEADING_TYPES_PER_OPERATION = new String[]{"Operations", "Time Ms", "Keys", "Key Bytes", "Value Bytes"};
    private static final List<ToLongFunction<? super StoreOperationStatistics>> STATISTIC_RETRIEVERS_MAPPINGS = Arrays.asList(StoreOperationStatistics::getNumberOfOperations, StoreOperationStatistics::getOperationDurationMs, StoreOperationStatistics::getKeysInOperation, StoreOperationStatistics::getKeyBytesRead, StoreOperationStatistics::getValueBytesRead);

    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Get aggregated store performance metrics", description="Allows downloading the store performance aggregate data as CSV.", tags={"Debugging"})
    public Response getStorePerformanceDetails() throws StorageException {
        String entity = PerformanceStoreService.createCsvContent(this.openPerformanceIndexes());
        return ResponseUtils.getFileDownloadResponse((Object)entity, (MediaType)MoreMediaTypes.TEXT_CSV_TYPE, (String)"performance-store-details.csv");
    }

    private static String createCsvContent(PairList<PublicProjectId, PerformanceIndexBase> performanceIndexes) throws StorageException {
        StringBuilder builder = new StringBuilder();
        PerformanceStoreService.addCsvHeader(builder);
        for (int i = 0; i < performanceIndexes.size(); ++i) {
            for (PerformanceAggregateEntry aggregate : ((PerformanceIndexBase)performanceIndexes.getSecond(i)).getAllAggregates()) {
                Map storageOperationStatistics = aggregate.getStorageOperationStatistics();
                if (storageOperationStatistics == null) continue;
                for (Map.Entry statisticEntry : storageOperationStatistics.entrySet()) {
                    builder.append(performanceIndexes.getFirst(i)).append(";");
                    builder.append(aggregate.getState()).append(";");
                    builder.append(aggregate.getTrigger()).append(";");
                    builder.append(aggregate.getExecutionCount()).append(";");
                    builder.append((String)statisticEntry.getKey()).append(";");
                    Map statsByOperation = (Map)statisticEntry.getValue();
                    StringBuilder statisticsPerOperation = PerformanceStoreService.addStatisticsPerOperation(statsByOperation);
                    PerformanceStoreService.addSummaries(builder, statsByOperation);
                    builder.append((CharSequence)statisticsPerOperation);
                    builder.append("\n");
                }
            }
        }
        return builder.toString();
    }

    private static void addSummaries(StringBuilder builder, Map<DetailedStorageProfiler.EStoreOperation, StoreOperationStatistics> statsByOperation) {
        for (ToLongFunction<? super StoreOperationStatistics> mapper : STATISTIC_RETRIEVERS_MAPPINGS) {
            builder.append(PerformanceStoreService.getSum(statsByOperation, mapper)).append(";");
        }
    }

    private static StringBuilder addStatisticsPerOperation(Map<DetailedStorageProfiler.EStoreOperation, StoreOperationStatistics> statsByOperation) {
        StringBuilder subBuilder = new StringBuilder();
        for (DetailedStorageProfiler.EStoreOperation operation : DetailedStorageProfiler.EStoreOperation.values()) {
            StoreOperationStatistics stats = statsByOperation.get(operation);
            if (stats != null) {
                for (ToLongFunction<? super StoreOperationStatistics> mapper : STATISTIC_RETRIEVERS_MAPPINGS) {
                    subBuilder.append(mapper.applyAsLong((StoreOperationStatistics)stats)).append(";");
                }
                continue;
            }
            for (int h = 0; h < HEADING_TYPES_PER_OPERATION.length; ++h) {
                subBuilder.append("0").append(";");
            }
        }
        return subBuilder;
    }

    private static void addCsvHeader(StringBuilder builder) {
        builder.append("Project;State;Trigger;Trigger Executions;Store;");
        for (String string : HEADING_TYPES_PER_OPERATION) {
            builder.append("Total ").append(string).append(";");
        }
        for (String string : DetailedStorageProfiler.EStoreOperation.values()) {
            for (String heading : HEADING_TYPES_PER_OPERATION) {
                builder.append(heading).append(" (").append((Object)string).append(");");
            }
        }
        builder.append("\n");
    }

    private static long getSum(Map<DetailedStorageProfiler.EStoreOperation, StoreOperationStatistics> statsByOperation, ToLongFunction<? super StoreOperationStatistics> mapper) {
        return statsByOperation.values().stream().mapToLong(mapper).sum();
    }
}

