/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.tasks;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.task.Task;
import com.teamscale.index.task.TaskIndex;
import com.teamscale.index.task.TaskNotificationUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.tasks.TaskServiceFilterUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.date.DateTimeUtils;

@Path(value="api/projects/{project}/tasks/{task}/comments")
public class TaskCommentService
extends ApiBase {
    @POST
    @Operation(summary="Add comment to task", description="Adds a comment to the task specified by ID.", tags={"Tasks"}, responses={@ApiResponse(responseCode="404", description="Task with provided ID could not be found."), @ApiResponse(responseCode="400", description="Empty comment content provided.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public void addCommentToTask(@Parameter(description="ID of the task to add comment to") @PathParam(value="task") int taskId, @RequestBody(required=true) String comment) throws StorageException {
        TaskIndex taskIndex = this.openProjectIndex(TaskIndex.class, null);
        Task task = TaskServiceFilterUtils.retrieveTask(taskIndex, taskId);
        task.addComment(this.getUser().getUsername(), DateTimeUtils.millisNow(), comment, false);
        taskIndex.setTask(task.getId(), task);
        TaskNotificationUtils.sendCommentNotification((Task)task, (String)comment, (User)this.serviceInfo.getUser(), (PublicProjectId)this.serviceInfo.getPrimaryPublicId(), (GlobalStorageSystem)this.serviceInfo.getGlobalStorageSystem());
    }
}

