/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.query.CoverageSourceParameterBase;
import com.teamscale.index.testgap.query.CoverageSourceQueryParameters;
import com.teamscale.index.testgap.query.ITgaRequest;
import com.teamscale.index.testgap.query.IssueTgaParameters;
import com.teamscale.index.testgap.query.TgaRequestAssessmentOptionsBase;
import com.teamscale.index.testgap.query.TgaRequestAssessmentQueryOptions;
import com.teamscale.index.testgap.query.TgaRequestQueryOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.framework.util.CsvServiceUtils;
import com.teamscale.service.framework.util.ResponseUtils;
import com.teamscale.service.testgap.CrossAnnotationServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.supercsv.io.CsvListWriter;

@Path(value="api/projects/{project}/test-gaps.csv")
public class TgaCsvDownloadService
extends CrossAnnotationServiceBase {
    private static final String CSV_HEADER_TEST_STATE = "Test State";
    private static final String CSV_HEADER_EXECUTION_STATE = "Execution State";
    private static final String CSV_HEADER_METHOD_NAME = "Method Name";
    private static final String CSV_HEADER_METHOD_LINES_REGION = "Method Region Lines";
    private static final String CSV_HEADER_METHOD_OFFSET_REGION = "Method Region Offsets";
    private static final String CSV_HEADER_UNIFORM_PATH = "Uniform Path";
    private static final String CSV_HEADER_FILE_NAME = "File Name";
    private static final String CSV_HEADER_LINK = "Link";

    @GET
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    @Operation(summary="Download test gap data", description="Downloads test gap information as a CSV file", tags={"Test Gap Analysis"}, responses={@ApiResponse(responseCode="400", description="Could not find actual commit for given branch at given timestamp."), @ApiResponse(responseCode="400", description="Attempt to use timespan to retrieve execution treemap of a single test run. Baseline timestamp and end timestamp have to be equal."), @ApiResponse(responseCode="404", description="Found no commits to be merged."), @ApiResponse(responseCode="400", description="Could not determine common merge base."), @ApiResponse(responseCode="404", description="Found no issue for the provided id."), @ApiResponse(responseCode="409", description="Found multiple issues for the provided id.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Produces(value={"text/csv"})
    public Response getTestGapDataAsCsv(@BeanParam CoverageSourceQueryParameters coverageSourceParameters, @BeanParam TimeIntervalBasedServiceQueryOptions timeIntervalParameters, @BeanParam TgaRequestQueryOptions tgaRequestParameters, @BeanParam IssueTgaParameters issueTgaParameters, @BeanParam TgaRequestAssessmentQueryOptions assessmentOptions, @Parameter(description="Parameter determining if only changed methods should be returned") @QueryParam(value="exclude-unchanged-methods") boolean excludeUnchangedMethods) throws StorageException, RepositoryException {
        this.checkCrossAnnotationPermissions((CoverageSourceParameterBase)coverageSourceParameters);
        ITgaRequest request = this.createTgaRequest((CoverageSourceParameterBase)coverageSourceParameters, timeIntervalParameters, tgaRequestParameters, issueTgaParameters, (TgaRequestAssessmentOptionsBase)assessmentOptions);
        AssessedTgaData assessedTestGapData = request.fetchAndAssessData();
        boolean isExecutionOnly = request.getTgaAssessmentType() == ETgaAssessmentType.EXECUTION_ONLY;
        String filename = "testgaps";
        if (isExecutionOnly) {
            filename = "execution";
        }
        String entity = CsvServiceUtils.createCsvString(csvListWriter -> this.writeTestGapCsv((CsvListWriter)csvListWriter, assessedTestGapData, isExecutionOnly, request.getIndexAccessCommit(), excludeUnchangedMethods, coverageSourceParameters, timeIntervalParameters.getBaselineCommit().getTimestamp()));
        return ResponseUtils.getFileDownloadResponse((Object)entity, (MediaType)MoreMediaTypes.TEXT_CSV_TYPE, (String)filename);
    }

    private void writeTestGapCsv(CsvListWriter csvListWriter, AssessedTgaData assessedTestGapData, boolean isExecutionOnly, CommitDescriptor endCommit, boolean excludeUnchangedMethods, CoverageSourceQueryParameters coverageSourceParameters, long baselineTimestamp) throws IOException, StorageException {
        String fifthColumnName = CSV_HEADER_TEST_STATE;
        if (isExecutionOnly) {
            fifthColumnName = CSV_HEADER_EXECUTION_STATE;
        }
        csvListWriter.writeHeader(new String[]{CSV_HEADER_UNIFORM_PATH, CSV_HEADER_METHOD_NAME, CSV_HEADER_METHOD_LINES_REGION, CSV_HEADER_METHOD_OFFSET_REGION, fifthColumnName, CSV_HEADER_FILE_NAME, CSV_HEADER_LINK});
        List methods = assessedTestGapData.filterByGrayState(excludeUnchangedMethods);
        List sortedMethods = CollectionUtils.sort((Collection)methods, AssessedTgaData.AssessedMethodData.UNIFORM_PATH_COMPARATOR.thenComparing(AssessedTgaData.AssessedMethodData.METHOD_NAME_COMPARATOR));
        URI baseUrl = this.serviceInfo.getRequestBaseUri();
        TokenElementLineInfoIndex tokenElementLineInfoIndex = this.openProjectIndex(TokenElementLineInfoIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)endCommit));
        List<UniformPath> uniformPaths = sortedMethods.stream().map(TgaCsvDownloadService::getResolvedUniformPath).distinct().toList();
        Map elementLineInfos = CollectionUtils.zipAsMap(uniformPaths, (SequencedCollection)tokenElementLineInfoIndex.getLineInfos(UniformPathCompatibilityUtil.asUniformPathStrings(uniformPaths)));
        for (AssessedTgaData.AssessedMethodData method : sortedMethods) {
            TokenElementLineInfo tokenElementInfo = (TokenElementLineInfo)elementLineInfos.get(TgaCsvDownloadService.getResolvedUniformPath(method));
            this.writeInformationForMethod(csvListWriter, endCommit, baseUrl, method, tokenElementInfo, coverageSourceParameters, baselineTimestamp);
        }
    }

    private static UniformPath getResolvedUniformPath(AssessedTgaData.AssessedMethodData method) {
        return method.getLocation().getUniformPath().resolveToCodePath();
    }

    private void writeInformationForMethod(CsvListWriter csvListWriter, CommitDescriptor endCommit, URI baseUrl, AssessedTgaData.AssessedMethodData method, TokenElementLineInfo tokenElementLineInfo, CoverageSourceQueryParameters coverageSourceParameters, long baselineTimestamp) throws IOException {
        int startLine = tokenElementLineInfo.getRawLineOffsetConverter().getLine(method.getLocation().getRegion().getStart());
        int endLine = tokenElementLineInfo.getRawLineOffsetConverter().getLine(method.getLocation().getRegion().getEnd());
        String lineRegion = "[" + startLine + "-" + endLine + "]";
        ETestGapState nodeState = method.getTestGapState();
        String methodName = method.getMethodName();
        String shortName = method.getLocation().getUniformPath().getLastSegment();
        String linkToFile = this.createLinkToFile(baseUrl, method.getLocation().getUniformPath(), method.getLocation().getRegion(), endCommit, coverageSourceParameters, baselineTimestamp);
        csvListWriter.write(new String[]{method.getLocation().getUniformPath().toString(), methodName, lineRegion, method.getLocation().getRegion().toString(), nodeState.getShortDescription(), shortName, linkToFile});
    }

    private String createLinkToFile(URI baseUrl, UniformPath uniformPath, OffsetBasedRegion region, CommitDescriptor commitDescriptor, CoverageSourceQueryParameters coverageSourceParameters, long baselineTimestamp) {
        return new TeamscaleCommitLinkProvider(baseUrl.toString(), this.serviceInfo.getPrimaryPublicId(), commitDescriptor).createTestGapDetailsLink(uniformPath.toStringAsMigrationFrontier(), region.getStart(), region.getEnd(), coverageSourceParameters.getPartitions(), baselineTimestamp);
    }
}

