/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap.upload;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.testgap.dotnet.DotNetVersionIndex;
import com.teamscale.index.testgap.dotnet.DotNetVersionInfo;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/projects/{project}/dot-net-versions")
public class DotNetVersionService
extends ApiBase {
    @GET
    @Operation(summary="Get .NET versions", description="Returns a list of all versions of a project known by uploaded PDBs.", tags={"Project"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<DotNetVersionInfo> getAllVersions() throws StorageException {
        if (!this.projectIndexExists("dot-net-program-versions")) {
            return CollectionUtils.emptyList();
        }
        DotNetVersionIndex index = this.openProjectIndex(DotNetVersionIndex.class, null);
        return index.getAllVersions().toList(DotNetVersionInfo::new);
    }

    @GET
    @Path(value="{versionName}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get .NET version info", description="Returns a the version info for a specific PDB.", tags={"Project"}, responses={@ApiResponse(responseCode="404", description="The version does not exist.")})
    public DotNetVersionInfo getDotNetVersionInfo(@Parameter(description="The name of the version to get infos for") @PathParam(value="versionName") String versionName) throws StorageException {
        if (!this.projectIndexExists("dot-net-program-versions")) {
            throw new NotFoundException("The version " + versionName + " does not exist!");
        }
        DotNetVersionIndex index = this.openProjectIndex(DotNetVersionIndex.class, null);
        CommitDescriptor dotNetVersionCommit = index.getVersionCommit(versionName);
        if (dotNetVersionCommit == null) {
            throw new NotFoundException("The version " + versionName + " does not exist!");
        }
        return new DotNetVersionInfo(versionName, dotNetVersionCommit);
    }
}

