/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.query.CoverageSourceParameterBase;
import com.teamscale.index.testgap.query.ITgaRequest;
import com.teamscale.index.testgap.query.IssueTgaParameters;
import com.teamscale.index.testgap.query.TgaRequestAssessmentOptionsBase;
import com.teamscale.index.testgap.query.TgaRequestAssessmentQueryOptions;
import com.teamscale.index.testgap.query.TgaRequestQueryOptions;
import com.teamscale.index.testimpact.CoverageUnitToMethodsMapIndex;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.index.testimpact.MethodIdIndex;
import com.teamscale.index.testimpact.PartitionedTestSet;
import com.teamscale.index.testimpact.TiaPartitionsQueryParams;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.testgap.CrossAnnotationServiceBase;
import com.teamscale.service.testimpact.ImpactedTestUtils;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/projects/{project}/overlay-tests")
public class ImpactedTestCoverageOverlayService
extends CrossAnnotationServiceBase {
    @GET
    @Operation(summary="Get test coverage overlay", description="Retrieves the methods that are expected to be covered by the impacted tests if they are rerun.", tags={"Test Intelligence"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public TestCoverageOverlayData getTestCoverageOverlay(@BeanParam TiaPartitionsQueryParams partitionsQueryParams, @BeanParam IssueTgaParameters issueTgaParameters, @BeanParam TimeIntervalBasedServiceQueryOptions timeIntervalBasedParameters, @BeanParam TgaRequestQueryOptions tgaRequestParameters, @BeanParam TgaRequestAssessmentQueryOptions assessmentQueryOptions) throws StorageException, RepositoryException {
        if (!partitionsQueryParams.isAllPartitions() && partitionsQueryParams.getPartitions().isEmpty()) {
            return new TestCoverageOverlayData(Collections.emptyList(), Collections.emptyList());
        }
        ITgaRequest request = this.createTgaRequest((CoverageSourceParameterBase)partitionsQueryParams.toCoverageSourceQueryParameters((List)CollectionUtils.emptyList()), timeIntervalBasedParameters, tgaRequestParameters, issueTgaParameters, (TgaRequestAssessmentOptionsBase)assessmentQueryOptions);
        AssessedTgaData assessedTestGapData = request.fetchAndAssessData();
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)request.getIndexAccessCommit());
        List untestedChangedMethodLocations = CollectionUtils.filterAndMap((Collection)assessedTestGapData.getMethods(), method -> method.getTestGapState() == ETestGapState.UNTESTED_CHANGE, AssessedTgaData.AssessedMethodData::getLocation);
        MethodIdIndex methodIdIndex = this.openProjectIndex(MethodIdIndex.class, historyAccessOption);
        List<MethodId> untestedChangedMethodIds = ImpactedTestUtils.computeMethodIds(methodIdIndex, untestedChangedMethodLocations);
        CoverageUnitToMethodsMapIndex testsToMethodsMapIndex = this.openProjectIndex(CoverageUnitToMethodsMapIndex.class, historyAccessOption);
        Map<MethodId, PartitionedTestSet> testsToMethodsMapping = ImpactedTestUtils.computeMethodToTestsMapping(testsToMethodsMapIndex, partitionsQueryParams, CollectionUtils.filter(untestedChangedMethodIds, Objects::nonNull));
        List testsCoveringChangedMethods = CollectionUtils.map(untestedChangedMethodIds, testsToMethodsMapping::get);
        return new TestCoverageOverlayData(untestedChangedMethodLocations, testsCoveringChangedMethods);
    }

    public static class TestCoverageOverlayData {
        private static final String METHOD_LOCATIONS_PROPERTY = "methodLocations";
        private static final String TESTS_COVERING_METHODS_PROPERTY = "testsCoveringMethods";
        @JsonProperty(value="methodLocations")
        private final List<MethodLocation> methodLocations;
        @JsonProperty(value="testsCoveringMethods")
        private final List<PartitionedTestSet> testsCoveringMethods;

        private TestCoverageOverlayData(@JsonProperty(value="methodLocations") List<MethodLocation> methodLocations, @JsonProperty(value="testsCoveringMethods") List<PartitionedTestSet> testsCoveringMethods) {
            this.methodLocations = methodLocations;
            this.testsCoveringMethods = testsCoveringMethods;
        }
    }
}

