/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.prioritization.strategies;

import com.teamscale.service.testimpact.MinimizationProgressCallback;
import com.teamscale.service.testimpact.prioritization.ETestSelectionReason;
import com.teamscale.service.testimpact.prioritization.IPrioritizableTests;
import com.teamscale.service.testimpact.prioritization.strategies.NonRoundBasedTestPrioritizationStrategyBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RandomButImpactedFirstPrioritizationStrategy
extends NonRoundBasedTestPrioritizationStrategyBase {
    public RandomButImpactedFirstPrioritizationStrategy(MinimizationProgressCallback progressCallback) {
        super(progressCallback);
    }

    @Override
    public <T extends IPrioritizableTests> List<T> orderMultipleTests(Collection<T> relevantTests) {
        Predicate<IPrioritizableTests> isImpacted = test -> test.getSelectionReasons().stream().anyMatch(selectionReason -> selectionReason == ETestSelectionReason.ADDED_OR_MODIFIED_TEST || selectionReason == ETestSelectionReason.COVERS_CHANGES);
        List impactedTests = relevantTests.stream().filter(isImpacted).collect(Collectors.toList());
        Collections.shuffle(impactedTests);
        List nonImpactedTests = relevantTests.stream().filter(isImpacted.negate()).collect(Collectors.toList());
        Collections.shuffle(nonImpactedTests);
        ArrayList result = new ArrayList();
        result.addAll(impactedTests);
        result.addAll(nonImpactedTests);
        return result;
    }
}

