/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.user.notifications;

import com.teamscale.index.notifications.findings.FindingsNotificationRuleIndex;
import com.teamscale.index.notifications.findings.FindingsNotificationRules;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import java.io.Serializable;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/notification-rules/findings")
public class FindingsNotificationRuleService
extends ApiBase {
    @GET
    @Operation(summary="Get notification rules", description="Retrieves the notification rules for the current user")
    @RequiresNoPermission
    public FindingsNotificationRules getNotificationRules() throws StorageException {
        FindingsNotificationRules notificationRules = (FindingsNotificationRules)this.openGlobalIndex(FindingsNotificationRuleIndex.class).getNotificationRules(this.getUser().getUsername());
        if (notificationRules == null) {
            return new FindingsNotificationRules();
        }
        return notificationRules;
    }

    @PUT
    @Operation(summary="Set notification rules", description="Sets the notification rules for the current user")
    @RequiresNoPermission
    public void setNotificationRules(@RequestBody FindingsNotificationRules notificationRules) throws StorageException {
        this.openGlobalIndex(FindingsNotificationRuleIndex.class).setNotificationRules(this.getUser().getUsername(), (Serializable)notificationRules);
    }
}

