/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.core.phase;

import com.teamscale.index.metadata.IFileMetadata;
import com.teamscale.wia.EWorkItemType;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.SimulinkElementContext;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.preprocessor.IPreprocessor;
import eu.cqse.check.framework.preprocessor.PreprocessorFactory;
import eu.cqse.check.framework.preprocessor.PreprocessorUtils;
import eu.cqse.check.framework.preprocessor.c.PreprocessorTokenReplacement;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.util.clang.ClangTranslationUnitWrapper;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public interface ITokenElementContext {
    public ELanguage getLanguage();

    public String getUniformPath();

    public List<IToken> getTokens(ECodeViewOption var1) throws CheckException;

    public String getTextContent(ECodeViewOption.ETextViewOption var1) throws CheckException;

    public ShallowEntity getRootEntity(ECodeViewOption var1) throws CheckException;

    public List<ShallowEntity> getAbstractSyntaxTree(ECodeViewOption var1) throws CheckException;

    public ITypeResolution getTypeResolution(ECodeViewOption var1) throws CheckException;

    default public List<IToken> calculateLocalPreprocessedTokens(List<IToken> tokens) {
        Optional<IPreprocessor> preprocessor = PreprocessorFactory.createLocalPreprocessor(this.getLanguage());
        if (preprocessor.isPresent()) {
            List<IToken> preprocessedTokens = preprocessor.get().preprocess(this.getUniformPath(), tokens);
            PreprocessorUtils.clearIfTokenNumberLimitExceeded(preprocessedTokens, this.getUniformPath());
            return preprocessedTokens;
        }
        return tokens;
    }

    public ClangTranslationUnitWrapper getClangTranslationUnitWrapper();

    public SimulinkElementContext getSimulinkContext();

    default public Optional<TeamscaleIssue> getWorkItem() throws CheckException {
        return this.getWorkItem(TeamscaleIssue.class);
    }

    default public <T extends TeamscaleIssue> Optional<T> getWorkItem(Class<T> expectedWorkItemType) throws CheckException {
        return this.getWorkItemForUniformPath(UniformPathCompatibilityUtil.convert((String)this.getUniformPath()), expectedWorkItemType);
    }

    default public Optional<TeamscaleIssue> getWorkItemForId(TeamscaleIssueId id) throws CheckException {
        return this.getWorkItemForId(id, TeamscaleIssue.class);
    }

    default public <T extends TeamscaleIssue> Optional<T> getWorkItemForId(TeamscaleIssueId id, Class<T> expectedWorkItemType) throws CheckException {
        for (EWorkItemType workItemType : EWorkItemType.values()) {
            Optional<T> result = this.getWorkItemForUniformPath(id.computeUniformPath(workItemType), expectedWorkItemType);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    default public <T extends TeamscaleIssue> Optional<T> getWorkItemForUniformPath(UniformPath uniformPath, Class<T> expectedWorkItemType) throws CheckException {
        return this.getWorkItemForUniformPath(uniformPath).filter(expectedWorkItemType::isInstance).map(expectedWorkItemType::cast);
    }

    public List<IFileMetadata> getAllMetadataForCurrentFile();

    public <T extends IFileMetadata> Optional<T> getMetadataOfType(Class<T> var1);

    public Optional<TeamscaleIssue> getWorkItemForUniformPath(UniformPath var1) throws CheckException;

    public List<PreprocessorTokenReplacement> getPreprocessorExpansions();
}

