/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.core.xpath;

import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class DocumentRootShallowEntity
extends ShallowEntity {
    private static final long serialVersionUID = 1L;
    public static final String DOCUMENT_ROOT_SUBTYPE_NAME = "document-root";

    public DocumentRootShallowEntity(String name) {
        super(EShallowEntityType.MODULE, DOCUMENT_ROOT_SUBTYPE_NAME, name, (List)CollectionUtils.emptyList(), 0);
    }

    public void setChildren(List<ShallowEntity> children) {
        for (ShallowEntity child : children) {
            this.addChild(child);
        }
    }

    public String toString() {
        return StringUtils.concat((Iterable)this.getChildren(), (String)"\n");
    }

    public boolean hasValidStartToken() {
        return true;
    }

    public int getStartOffset() {
        return 0;
    }

    public static void wrapWithRootIfNecessary(List<ShallowEntity> entities, String uniformPath) {
        if (!entities.isEmpty() && entities.get(0).getParent() == null) {
            DocumentRootShallowEntity.wrapWithRoot(uniformPath, entities);
        }
    }

    public static DocumentRootShallowEntity wrapWithRoot(String rootElementName, List<ShallowEntity> topLevelEntities) {
        DocumentRootShallowEntity rootEntity = new DocumentRootShallowEntity(rootElementName);
        rootEntity.setChildren(topLevelEntities);
        return rootEntity;
    }
}

