/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.c;

import eu.cqse.check.framework.preprocessor.c.CPreprocessingUtils;
import eu.cqse.check.framework.preprocessor.c.MacroDefinition;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.HashMap;
import org.conqat.lib.commons.assertion.CCSMAssert;

enum CompilerDefinedMacroNames {
    TIME("__TIME__", " \"12:00:00\""),
    DATE("__DATE__", " \"Jan  1 2020\""),
    STDC_HOSTED("__STDC_HOSTED__", " 1"),
    STDC("__STDC__", " 1"),
    STDC_ISO_10646("__STDC_ISO_10646__", " 201706L"),
    PRAGMA1("_Pragma", "(x) x"),
    PRAGMA2("__pragma", "(x) x"),
    FILE("__FILE__"),
    LINE("__LINE__"),
    INCLUDE_LEVEL("__INCLUDE_LEVEL__"),
    COUNTER("__COUNTER__", " 0"),
    SIZE_TYPE("__SIZE_TYPE__", " long unsigned int"),
    PTRDIFF_TYPE("__PTRDIFF_TYPE__", " long int"),
    WCHAR_TYPE("__WCHAR_TYPE__", " int"),
    WINT_TYPE("__WINT_TYPE__", " unsigned int"),
    INTMAX_TYPE("__INTMAX_TYPE__", " long int"),
    UINTMAX_TYPE("__UINTMAX_TYPE__", " long unsigned int"),
    SIG_ATOMIC_TYPE("__SIG_ATOMIC_TYPE__", " int"),
    INT8_TYPE("__INT8_TYPE__", " signed char"),
    INT16_TYPE("__INT16_TYPE__", " short int"),
    INT32_TYPE("__INT32_TYPE__", " int"),
    INT64_TYPE("__INT64_TYPE__", " long int"),
    UINT8_TYPE("__UINT8_TYPE__", " unsigned char"),
    UINT16_TYPE("__UINT16_TYPE__", " short unsigned int"),
    UINT32_TYPE("__UINT32_TYPE__", " unsigned int"),
    UINT64_TYPE("__UINT64_TYPE__", " long unsigned int"),
    INT_LEAST8_TYPE("__INT_LEAST8_TYPE__", " signed char"),
    INT_LEAST16_TYPE("__INT_LEAST16_TYPE__", " short int"),
    INT_LEAST32_TYPE("__INT_LEAST32_TYPE__", " int"),
    INT_LEAST64_TYPE("__INT_LEAST64_TYPE__", " long int"),
    UINT_LEAST8_TYPE("__UINT_LEAST8_TYPE__", " unsigned char"),
    UINT_LEAST16_TYPE("__UINT_LEAST16_TYPE__", " short unsigned int"),
    UINT_LEAST32_TYPE("__UINT_LEAST32_TYPE__", " unsigned int"),
    UINT_LEAST64_TYPE("__UINT_LEAST64_TYPE__", " long unsigned int"),
    INT_FAST8_TYPE("__INT_FAST8_TYPE__", " signed char"),
    INT_FAST16_TYPE("__INT_FAST16_TYPE__", " long int"),
    INT_FAST32_TYPE("__INT_FAST32_TYPE__", " long int"),
    INT_FAST64_TYPE("__INT_FAST64_TYPE__", " long int"),
    UINT_FAST8_TYPE("__UINT_FAST8_TYPE__", " unsigned char"),
    UINT_FAST16_TYPE("__UINT_FAST16_TYPE__", " long unsigned int"),
    UINT_FAST32_TYPE("__UINT_FAST32_TYPE__", " long unsigned int"),
    UINT_FAST64_TYPE("__UINT_FAST64_TYPE__", " long unsigned int"),
    INTPTR_TYPE("__INTPTR_TYPE__", " long int"),
    UINTPTR_TYPE("__UINTPTR_TYPE__", " long unsigned int"),
    USER_LABEL_PREFIX("__USER_LABEL_PREFIX__", ""),
    TEAMSCALE_FILE("__TEAMSCALE_FILE_MATCHES", "(regex) Teamscale will match the regex to the current path and evaluate this to 0 or 1."),
    TEAMSCALE_IS_C("__TEAMSCALE_IS_C__"),
    TEAMSCALE_IS_CPP("__TEAMSCALE_IS_CPP__"),
    TEAMSCALE_IS_OBJECTIVE_C("__TEAMSCALE_IS_OBJECTIVE_C__"),
    TEAMSCALE_IS_OBJECTIVE_CPP("__TEAMSCALE_IS_OBJECTIVE_CPP__"),
    HAS_INCLUDE("__has_include", "(file) this text is never used (evaluation is implemented in a special function)"),
    HAS_INCLUDE_NEXT("__has_include_next", "(file) this text is never used (evaluation is implemented in a special function)"),
    FASTCALL("__fastcall", ""),
    EXPORT("__export", ""),
    FORCE_INLINE("__forceinline", ""),
    C_DECL("_cdecl", ""),
    STDCALL1("_stdcall", ""),
    STDCALL2("__stdcall", ""),
    WINAPI("WINAPI", ""),
    APIENTRY("APIENTRY", ""),
    CALLBACK("CALLBACK", ""),
    STD_METHOD_CALL("STDMETHODCALLTYPE", ""),
    Q_EXPORT("Q_EXPORT", ""),
    DML_C("DML_c", ""),
    DML_CALLBACK("DM_CALLBACK", ""),
    ONE("__1", ""),
    TWO("__2", ""),
    THREE("__3", ""),
    FOUR("__4", ""),
    FIVE("__5", ""),
    SIX("__6", ""),
    SEVEN("__7", ""),
    DM_ENTRY("DM_ENTRY", ""),
    DM_PASCAL("DML_pascal", ""),
    DM_DEFAULT("DML_default", ""),
    IGVPWORD_API("IGVPWORD_API", "");

    public final String macroName;
    private final String macroDefinitionText;
    private final HashMap<ELanguage, MacroDefinition> macroDefinitionByLanguage;

    private CompilerDefinedMacroNames(String name) {
        this.macroName = name;
        this.macroDefinitionText = null;
        this.macroDefinitionByLanguage = null;
    }

    private CompilerDefinedMacroNames(String name, String content) {
        this.macroName = name;
        this.macroDefinitionText = content;
        this.macroDefinitionByLanguage = new HashMap();
        CCSMAssert.isNotNull((Object)this.macroDefinitionText, (String)"Macro definition text must not be null.");
    }

    public MacroDefinition getDefinition(ELanguage language) {
        if (this.macroDefinitionByLanguage == null) {
            return null;
        }
        if (this.macroDefinitionByLanguage.containsKey(language)) {
            return this.macroDefinitionByLanguage.get(language);
        }
        MacroDefinition definition = MacroDefinition.parseMacroDefinition(this.macroName + this.macroDefinitionText, CPreprocessingUtils.LOCATION_FOR_INTERNAL_DEFAULT_DEFINES, language);
        CCSMAssert.isTrue((boolean)this.macroName.equals(definition.macroName), () -> "Name of compiler-defined macro " + definition.macroName + " does not match expected name " + this.macroName);
        CCSMAssert.isTrue((definition.replacementList.isEmpty() == this.macroDefinitionText.isEmpty() ? 1 : 0) != 0, () -> "Replacement list of compiler-defined macro " + definition.macroName + " must be empty.");
        this.macroDefinitionByLanguage.put(language, definition);
        return definition;
    }
}

