/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.swift;

import com.google.common.base.Preconditions;
import eu.cqse.check.framework.preprocessor.IPreprocessor;
import eu.cqse.check.framework.preprocessor.c.CPreprocessingUtils;
import eu.cqse.check.framework.preprocessor.c.PreprocessorTokenReplacement;
import eu.cqse.check.framework.preprocessor.swift.ConditionalCompilationBlockProcessor;
import eu.cqse.check.framework.preprocessor.swift.SwiftCompilerControlConfig;
import eu.cqse.check.framework.preprocessor.swift.SwiftCompilerControlStatements;
import eu.cqse.check.framework.scanner.IToken;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SwiftPreprocessor
implements IPreprocessor {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SwiftCompilerControlConfig config;

    public SwiftPreprocessor(@NonNull SwiftCompilerControlConfig config) {
        Preconditions.checkNotNull((Object)config);
        this.config = config;
    }

    public static SwiftPreprocessor emptyConfigPreprocessor() {
        return new SwiftPreprocessor(SwiftCompilerControlConfig.emptyConfig());
    }

    public @NonNull List<PreprocessorTokenReplacement> computeReplacements(String uniformPath, @NonNull List<IToken> tokens) {
        ArrayList<PreprocessorTokenReplacement> results = new ArrayList<PreprocessorTokenReplacement>();
        int tokenIndex = 0;
        while (tokenIndex < tokens.size()) {
            IToken token = tokens.get(tokenIndex);
            if (!SwiftCompilerControlStatements.isIf(token)) {
                ++tokenIndex;
                continue;
            }
            try {
                ConditionalCompilationBlockProcessor.ConditionalRegionResult result = ConditionalCompilationBlockProcessor.processBlock(tokens, tokenIndex, this.config);
                results.addAll(result.deletions());
                tokenIndex = result.lastRemovalEndIndex();
            }
            catch (Exception e) {
                LOGGER.warn("Swift conditional compilation block ('{}') could not be processed at '{}:{}'. Attempting to continue, but processing will be incomplete.", (Object)token.getText(), (Object)uniformPath, (Object)(token.getLineNumber() + 1), (Object)e);
            }
            ++tokenIndex;
        }
        return results;
    }

    @Override
    public @NonNull List<IToken> preprocess(String uniformPath, @NonNull List<IToken> tokens) {
        return CPreprocessingUtils.applyReplacements(this.computeReplacements(uniformPath, tokens), tokens);
    }
}

