/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.swift.platformconditions;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

final class Version
implements Comparable<Version> {
    private final int[] components;

    public Version(@NonNull List<Integer> components) {
        Preconditions.checkNotNull(components);
        Preconditions.checkArgument((!components.isEmpty() ? 1 : 0) != 0);
        this.components = components.stream().mapToInt(Integer::intValue).toArray();
        Version.verifyPositive(this.components);
    }

    public Version(int[] components) {
        Preconditions.checkNotNull((Object)components);
        Preconditions.checkArgument((components.length > 0 ? 1 : 0) != 0);
        Version.verifyPositive(components);
        this.components = Arrays.copyOf(components, components.length);
    }

    public Version(int firstComponent, int ... otherComponents) {
        Preconditions.checkNotNull((Object)otherComponents);
        this.components = new int[otherComponents.length + 1];
        this.components[0] = firstComponent;
        System.arraycopy(otherComponents, 0, this.components, 1, otherComponents.length);
        Version.verifyPositive(this.components);
    }

    public Version(@NonNull Version otherVersion) {
        Preconditions.checkNotNull((Object)otherVersion);
        this.components = Arrays.copyOf(otherVersion.components, otherVersion.components.length);
    }

    private static void verifyPositive(int @NonNull [] numbers) {
        for (int number : numbers) {
            Verify.verify((number >= 0 ? 1 : 0) != 0, (String)"All version components must be positive integers", (Object[])new Object[0]);
        }
    }

    public static Optional<Version> parse(@NonNull String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return Optional.empty();
        }
        String[] splitVersion = StringUtils.splitPreserveAllTokens((String)value, (char)'.');
        try {
            int[] intComponents = Arrays.stream(splitVersion).mapToInt(Integer::parseInt).toArray();
            return Optional.of(new Version(intComponents));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Override
    public int compareTo(Version other) {
        int[] longerVersion;
        int minSize = Math.min(this.components.length, other.components.length);
        for (int i = 0; i < minSize; ++i) {
            int comparison = Integer.compare(this.components[i], other.components[i]);
            if (comparison == 0) continue;
            return comparison;
        }
        if (this.components.length == other.components.length) {
            return 0;
        }
        int compareReturn = 1;
        if (this.components.length > minSize) {
            longerVersion = this.components;
        } else {
            longerVersion = other.components;
            compareReturn = -1;
        }
        for (int i = minSize; i < longerVersion.length; ++i) {
            if (longerVersion[i] == 0) continue;
            return compareReturn;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        Version otherVersion = (Version)other;
        return this.compareTo(otherVersion) == 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.components);
    }

    public boolean isGreaterOrEqual(Version other) {
        return this.compareTo(other) >= 0;
    }

    public boolean isLess(Version other) {
        return this.compareTo(other) < 0;
    }

    public String toString() {
        return Arrays.stream(this.components).mapToObj(Integer::toString).collect(Collectors.joining("."));
    }
}

