/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.scanner.highlighting;

import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.awt.Color;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.ImmutablePair;

public class SourceCodeStyle {
    private static final Color JAVA_COMMENT_COLOR = new Color(63, 127, 95);
    private static final Color JAVA_DOCCOMMENT_COLOR = new Color(63, 95, 191);
    private static final Color JAVA_KEYWORD_COLOR = new Color(19, 19, 135);
    private static final Color ANNOTATION_COLOR = new Color(128, 128, 3);
    private static final Color CS_KEYWORD_COLOR = JAVA_KEYWORD_COLOR;
    private static final Color CS_COMMENT_COLOR = JAVA_COMMENT_COLOR;
    private static final Color LITERAL_COLOR = new Color(163, 21, 21);
    private static final Color CS_SPECIAL_COLOR = new Color(200, 200, 200);
    private static final Color CS_DOCCOMMENT_COLOR = new Color(128, 128, 128);
    private static final SourceCodeStyle DEFAULT_STYLE = new SourceCodeStyle();
    private static final SourceCodeStyle JAVA_STYLE = new SourceCodeStyle(){

        @Override
        public ImmutablePair<Color, Integer> getStyle(ETokenType tokenType, @Nullable ETokenType typeOfPreviousToken, @Nullable ETokenType typeOfNextToken) {
            if (tokenType == ETokenType.DOCUMENTATION_COMMENT) {
                return 1.style(JAVA_DOCCOMMENT_COLOR);
            }
            if (SourceCodeStyle.isPartOfJavaAnnotation(tokenType, typeOfPreviousToken, typeOfNextToken)) {
                return 1.style(ANNOTATION_COLOR);
            }
            return super.getStyle(tokenType, typeOfPreviousToken, typeOfNextToken);
        }
    };
    private static final SourceCodeStyle PLSQL_STYLE = new SourceCodeStyle(){

        @Override
        public ImmutablePair<Color, Integer> getStyle(ETokenType tokenType, @Nullable ETokenType typeOfPreviousToken, @Nullable ETokenType typeOfNextToken) {
            if (tokenType.getTokenClass() == ETokenType.ETokenClass.OPERATOR) {
                return super.getStyle(ETokenType.IF, typeOfPreviousToken, typeOfNextToken);
            }
            return super.getStyle(tokenType, typeOfPreviousToken, typeOfNextToken);
        }
    };
    private static final SourceCodeStyle CS_STYLE = new SourceCodeStyle(){

        @Override
        public ImmutablePair<Color, Integer> getStyle(ETokenType tokenType, @Nullable ETokenType typeOfPreviousToken, @Nullable ETokenType typeOfNextToken) {
            if (tokenType == ETokenType.DOCUMENTATION_COMMENT) {
                return 3.style(CS_DOCCOMMENT_COLOR);
            }
            if (typeOfPreviousToken == ETokenType.LBRACK && tokenType == ETokenType.IDENTIFIER) {
                return 3.style(ANNOTATION_COLOR);
            }
            switch (tokenType.getTokenClass()) {
                case KEYWORD: {
                    return 3.style(CS_KEYWORD_COLOR, 1);
                }
                case LITERAL: {
                    return 3.style(LITERAL_COLOR);
                }
                case COMMENT: {
                    return 3.style(CS_COMMENT_COLOR);
                }
                case SPECIAL: {
                    return 3.style(CS_SPECIAL_COLOR);
                }
            }
            return super.getStyle(tokenType, typeOfPreviousToken, typeOfNextToken);
        }
    };
    private static final SourceCodeStyle PLAIN_TEXT_STYLE = new SourceCodeStyle(){

        @Override
        public ImmutablePair<Color, Integer> getStyle(ETokenType tokenType, @Nullable ETokenType typeOfPreviousToken, @Nullable ETokenType typeOfNextToken) {
            return 4.style(Color.BLACK);
        }
    };

    private static boolean isPartOfJavaAnnotation(ETokenType tokenType, @Nullable ETokenType typeOfPreviousToken, @Nullable ETokenType typeOfNextToken) {
        return tokenType == ETokenType.AT_OPERATOR && ETokenType.IDENTIFIER == typeOfNextToken || typeOfPreviousToken == ETokenType.AT_OPERATOR && tokenType == ETokenType.IDENTIFIER;
    }

    private SourceCodeStyle() {
    }

    public ImmutablePair<Color, Integer> getStyle(ETokenType tokenType, @Nullable ETokenType typeOfPreviousToken, @Nullable ETokenType typeOfNextToken) {
        switch (tokenType.getTokenClass()) {
            case KEYWORD: {
                return SourceCodeStyle.style(JAVA_KEYWORD_COLOR, 1);
            }
            case LITERAL: {
                return SourceCodeStyle.style(LITERAL_COLOR);
            }
            case SYNTHETIC: 
            case ERROR: {
                return SourceCodeStyle.style(Color.RED, 1);
            }
            case COMMENT: {
                return SourceCodeStyle.style(JAVA_COMMENT_COLOR);
            }
        }
        return SourceCodeStyle.style(Color.BLACK);
    }

    public ImmutablePair<Color, Integer> getStyle(IToken token, @Nullable IToken previousToken, @Nullable IToken nextToken) {
        ETokenType typeOfPreviousToken = previousToken == null ? null : previousToken.getType();
        ETokenType typeOfNextToken = nextToken == null ? null : nextToken.getType();
        return this.getStyle(token.getType(), typeOfPreviousToken, typeOfNextToken);
    }

    public static ImmutablePair<Color, Integer> style(Color color) {
        return SourceCodeStyle.style(color, 0);
    }

    public static ImmutablePair<Color, Integer> style(Color color, int style) {
        return new ImmutablePair((Object)color, (Object)style);
    }

    public static SourceCodeStyle get(ELanguage language) {
        switch (language) {
            case TEXT: {
                return PLAIN_TEXT_STYLE;
            }
            case JAVA: {
                return JAVA_STYLE;
            }
            case CS: 
            case VB: {
                return CS_STYLE;
            }
            case PLSQL: {
                return PLSQL_STYLE;
            }
        }
        return DEFAULT_STYLE;
    }
}

