/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser;

import com.google.common.base.Preconditions;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ArtificialTokenOriginIds;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.NestingAwareHaltingTokenIterator;
import eu.cqse.check.framework.shallowparser.NestingAwareTokenIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class TokenStreamUtils {
    public static final int NOT_FOUND = -1;
    public static final UnmodifiableList<ETokenType> STANDARD_OPENING_TOKEN_TYPES = CollectionUtils.asUnmodifiable(List.of(ETokenType.LPAREN, ETokenType.LBRACE, ETokenType.LBRACK));
    public static final UnmodifiableList<ETokenType> STANDARD_CLOSING_TOKEN_TYPES = CollectionUtils.asUnmodifiable(List.of(ETokenType.RPAREN, ETokenType.RBRACE, ETokenType.RBRACK));

    public static int firstTokenMatching(List<IToken> tokens, ITokenMatcher matcher) {
        return TokenStreamUtils.firstTokenMatching(tokens, 0, matcher);
    }

    public static int firstTokenMatching(List<IToken> tokens, int startTokenIndex, ITokenMatcher matcher) {
        return TokenStreamUtils.firstTokenMatching(tokens, startTokenIndex, tokens.size(), matcher);
    }

    public static int firstTokenMatching(List<IToken> tokens, int startTokenIndex, int endTokenIndex, ITokenMatcher matcher) {
        TokenStreamUtils.assertListRange(tokens, startTokenIndex, endTokenIndex);
        for (int i = startTokenIndex; i < endTokenIndex; ++i) {
            if (!matcher.matches(tokens.get(i))) continue;
            return i;
        }
        return -1;
    }

    private static int firstTokenOfClassOrTypeSequence(List<IToken> tokens, int startTokenIndex, int endTokenIndex, ITokenMatcher ... sequence) {
        for (int i = startTokenIndex; i < endTokenIndex; ++i) {
            if (!TokenStreamUtils.hasTokenClassOrTypeSequence(tokens, i, sequence)) continue;
            return i;
        }
        return -1;
    }

    public static int firstTokenOfTypeWithText(List<IToken> tokens, int startTokenIndex, int endTokenIndex, Set<ETokenType> tokenTypes, String tokenText) {
        TokenStreamUtils.assertListRange(tokens, startTokenIndex, endTokenIndex);
        for (int i = startTokenIndex; i < endTokenIndex; ++i) {
            IToken token = tokens.get(i);
            if (!tokenTypes.contains(token.getType()) || !token.getText().equals(tokenText)) continue;
            return i;
        }
        return -1;
    }

    public static int firstTokenOfTypeNotFollowedBy(List<IToken> tokens, int startTokenIndex, int endTokenIndex, ITokenMatcher tokenTypes, ITokenMatcher endTokenNotFollowedBy) {
        TokenStreamUtils.assertListRange(tokens, startTokenIndex, endTokenIndex);
        for (int i = startTokenIndex; i < endTokenIndex; ++i) {
            if (!tokenTypes.matches(tokens.get(i)) || i < endTokenIndex - 1 && endTokenNotFollowedBy.matches(tokens.get(i + 1))) continue;
            return i;
        }
        return -1;
    }

    private static Set<ETokenType> toEnumSet(ETokenType ... tokenTypes) {
        EnumSet<ETokenType> set = EnumSet.noneOf(ETokenType.class);
        set.addAll(Arrays.asList(tokenTypes));
        return set;
    }

    public static int lastTokenMatching(List<IToken> tokens, ITokenMatcher matcher) {
        return TokenStreamUtils.lastTokenMatching(tokens, 0, matcher);
    }

    public static int lastTokenMatching(List<IToken> tokens, int startTokenIndex, ITokenMatcher matchers) {
        return TokenStreamUtils.lastTokenMatching(tokens, startTokenIndex, tokens.size(), matchers);
    }

    public static int lastTokenMatching(List<IToken> tokens, int startTokenIndex, int endTokenIndex, ITokenMatcher matcher) {
        TokenStreamUtils.assertListRange(tokens, startTokenIndex, endTokenIndex);
        ListIterator<IToken> iter = tokens.listIterator(endTokenIndex);
        while (iter.hasPrevious() && iter.previousIndex() >= startTokenIndex) {
            IToken token = iter.previous();
            if (!matcher.matches(token)) continue;
            return iter.nextIndex();
        }
        return -1;
    }

    public static int lastTokenMatchingIndexPredicate(List<IToken> tokens, int terminationTokenIndex, BiPredicate<Integer, List<IToken>> predicate) {
        for (int i = tokens.size() - 1; i >= terminationTokenIndex; --i) {
            if (!predicate.test(i, tokens)) continue;
            return i;
        }
        return -1;
    }

    public static int firstTokenOfAlternatingTypes(List<IToken> tokens, int endTokenIndex, ETokenType element, ETokenType separator) {
        Preconditions.checkArgument((endTokenIndex >= 0 && endTokenIndex < tokens.size() ? 1 : 0) != 0);
        if (tokens.get(endTokenIndex).getType() != element) {
            return -1;
        }
        for (int i = endTokenIndex; i >= 0; i -= 2) {
            if (i >= 1 && TokenStreamUtils.hasTokenTypeSequence(tokens, i - 1, separator, element)) continue;
            if (tokens.get(i).getType() == element) {
                return i;
            }
            return -1;
        }
        return -1;
    }

    private static void assertListRange(List<IToken> tokens, int startTokenIndex, int endTokenIndex) throws AssertionError {
        CCSMAssert.isTrue((startTokenIndex >= 0 ? 1 : 0) != 0, (String)"startTokenIndex must be greater or equal to zero");
        CCSMAssert.isTrue((endTokenIndex <= tokens.size() ? 1 : 0) != 0, (String)"endTokenIndex must be less or equal to tokens.size()");
    }

    public static boolean contains(List<IToken> tokens, ETokenType tokenType) {
        return TokenStreamUtils.contains(tokens, 0, tokens.size(), tokenType);
    }

    public static boolean contains(List<IToken> tokens, int startTokenIndex, int endTokenIndex, ETokenType tokenType) {
        return TokenStreamUtils.firstTokenMatching(tokens, startTokenIndex, endTokenIndex, (ITokenMatcher)tokenType) != -1;
    }

    public static boolean contains(List<IToken> tokens, ETokenType.ETokenClass tokenClass) {
        for (IToken token : tokens) {
            if (token.getType().getTokenClass() != tokenClass) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(List<IToken> tokens, ETokenType ... tokenTypes) {
        return TokenStreamUtils.containsAny(tokens, 0, tokens.size(), tokenTypes);
    }

    public static boolean containsAny(List<IToken> tokens, Set<ETokenType> tokenTypeSet) {
        return TokenStreamUtils.containsAny(tokens, 0, tokens.size(), tokenTypeSet);
    }

    public static boolean containsAny(List<IToken> tokens, int startTokenIndex, int endTokenIndex, ETokenType ... tokenTypes) {
        return TokenStreamUtils.containsAny(tokens, startTokenIndex, endTokenIndex, TokenStreamUtils.toEnumSet(tokenTypes));
    }

    public static boolean containsAny(List<IToken> tokens, int startTokenIndex, int endTokenIndex, Set<ETokenType> tokenTypes) {
        TokenStreamUtils.assertListRange(tokens, startTokenIndex, endTokenIndex);
        if (tokenTypes.isEmpty()) {
            return false;
        }
        for (int i = startTokenIndex; i < endTokenIndex; ++i) {
            if (!tokenTypes.contains(tokens.get(i).getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(List<IToken> tokens, ETokenType ... tokenTypes) {
        return TokenStreamUtils.containsAll(tokens, 0, tokens.size(), tokenTypes);
    }

    public static boolean containsAll(List<IToken> tokens, int startTokenIndex, int endTokenIndex, ETokenType ... tokenTypes) {
        TokenStreamUtils.assertListRange(tokens, startTokenIndex, endTokenIndex);
        if (tokenTypes.length == 0) {
            return true;
        }
        Set<ETokenType> types = TokenStreamUtils.toEnumSet(tokenTypes);
        for (int i = startTokenIndex; i < endTokenIndex; ++i) {
            types.remove(tokens.get(i).getType());
            if (!types.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean containsSequence(List<IToken> tokens, int startTokenIndex, int endTokenIndex, ETokenType ... tokenTypes) {
        TokenStreamUtils.assertListRange(tokens, startTokenIndex, endTokenIndex);
        block0: for (int i = startTokenIndex; i <= endTokenIndex - tokenTypes.length; ++i) {
            for (int j = 0; j < tokenTypes.length; ++j) {
                if (tokens.get(i + j).getType() != tokenTypes[j]) continue block0;
            }
            return true;
        }
        return false;
    }

    public static boolean containsSequence(List<IToken> tokens, ETokenType ... tokenTypes) {
        return TokenStreamUtils.containsSequence(tokens, 0, tokens.size(), tokenTypes);
    }

    public static List<IToken> tokensBetween(List<IToken> tokens, ETokenType startType, ETokenType endType) {
        return TokenStreamUtils.tokensBetween(tokens, EnumSet.of(startType), EnumSet.of(endType));
    }

    public static List<IToken> tokensAround(List<IToken> tokens, int startTokenIndex, Set<ETokenType> startTypes, Set<ETokenType> endTypes) {
        int sublistStartIndex = -1;
        for (int i = startTokenIndex; i > 0; --i) {
            if (!startTypes.contains(tokens.get(i).getType())) continue;
            sublistStartIndex = i;
            break;
        }
        if (sublistStartIndex == -1) {
            return CollectionUtils.emptyList();
        }
        int endTokenIndex = -1;
        for (int i = startTokenIndex; i < tokens.size(); ++i) {
            if (!endTypes.contains(tokens.get(i).getType())) continue;
            endTokenIndex = i;
            break;
        }
        if (endTokenIndex == -1) {
            return CollectionUtils.emptyList();
        }
        return tokens.subList(sublistStartIndex, endTokenIndex);
    }

    public static List<IToken> tokensBetween(List<IToken> tokens, Set<ETokenType> startTypes, Set<ETokenType> endTypes) {
        int end;
        int start = TokenStreamUtils.firstTokenMatching(tokens, ITokenMatcher.anyOfType(startTypes));
        if (start == -1) {
            return CollectionUtils.emptyList();
        }
        if ((end = TokenStreamUtils.firstTokenMatching(tokens, ++start, ITokenMatcher.anyOfType(endTypes))) == -1) {
            return CollectionUtils.emptyList();
        }
        return tokens.subList(start, end);
    }

    public static int findMatchingClosingToken(List<IToken> tokens, int currentTokenIndex, ETokenType openingType, ETokenType closingType) {
        int nesting = 1;
        while (currentTokenIndex < tokens.size()) {
            ETokenType tokenType = tokens.get(currentTokenIndex).getType();
            if (tokenType == openingType) {
                ++nesting;
            } else if (tokenType == closingType && --nesting == 0) {
                return currentTokenIndex;
            }
            ++currentTokenIndex;
        }
        return -1;
    }

    public static int findMatchingClosingToken(List<IToken> tokens, int currentTokenIndex, Collection<ETokenType> openingTypes, Collection<ETokenType> closingTypes) {
        int nesting = 1;
        while (currentTokenIndex < tokens.size()) {
            ETokenType tokenType = tokens.get(currentTokenIndex).getType();
            if (openingTypes.contains(tokenType)) {
                ++nesting;
            } else if (closingTypes.contains(tokenType) && --nesting == 0) {
                return currentTokenIndex;
            }
            ++currentTokenIndex;
        }
        return -1;
    }

    public static int findMatchingOpeningToken(List<IToken> tokens, int currentTokenIndex, ETokenType openingType, ETokenType closingType) {
        return TokenStreamUtils.findMatchingOpeningToken(tokens, currentTokenIndex, EnumSet.of(openingType), EnumSet.of(closingType));
    }

    public static int findMatchingOpeningToken(List<IToken> tokens, int currentTokenIndex, Set<ETokenType> openingTypes, Set<ETokenType> closingTypes) {
        int openBraces = 1;
        while (currentTokenIndex >= 0) {
            ETokenType currentTokenType = tokens.get(currentTokenIndex).getType();
            if (openingTypes.contains(currentTokenType)) {
                --openBraces;
            } else if (closingTypes.contains(currentTokenType)) {
                ++openBraces;
            }
            if (openBraces == 0) {
                return currentTokenIndex;
            }
            --currentTokenIndex;
        }
        return -1;
    }

    public static int findFirstTopLevel(List<IToken> tokens, ITokenMatcher searchMatcher, List<ETokenType> openingTypes, List<ETokenType> closingTypes) {
        return TokenStreamUtils.findFirstTopLevel(tokens, 0, searchMatcher, openingTypes, closingTypes);
    }

    public static int findFirstTopLevel(List<IToken> tokens, int startTokenIndex, ITokenMatcher searchMatcher, List<ETokenType> openingTypes, List<ETokenType> closingTypes) {
        CCSMAssert.isTrue((startTokenIndex >= 0 ? 1 : 0) != 0, (String)"startTokenIndex must be greater or equal to zero");
        NestingAwareTokenIterator iterator = new NestingAwareTokenIterator(tokens, startTokenIndex, openingTypes, closingTypes);
        while (iterator.hasNext()) {
            IToken token = iterator.next();
            if (!iterator.isTopLevel() || !searchMatcher.matches(token)) continue;
            return iterator.getCurrentIndex();
        }
        return -1;
    }

    public static int findFirstTopLevelWithIndexPredicate(List<IToken> tokens, int startTokenIndex, Predicate<Integer> searchPredicate, List<ETokenType> openingTypes, List<ETokenType> closingTypes) {
        CCSMAssert.isTrue((startTokenIndex >= 0 ? 1 : 0) != 0, (String)"startTokenIndex must be greater or equal to zero");
        NestingAwareTokenIterator iterator = new NestingAwareTokenIterator(tokens, startTokenIndex, openingTypes, closingTypes);
        while (iterator.hasNext()) {
            iterator.next();
            if (!iterator.isTopLevel() || !searchPredicate.test(iterator.getCurrentIndex())) continue;
            return iterator.getCurrentIndex();
        }
        return -1;
    }

    public static boolean startsWith(List<IToken> tokens, ETokenType ... sequence) {
        return TokenStreamUtils.hasTokenTypeSequence(tokens, 0, sequence);
    }

    public static boolean startsWithToken(List<IToken> tokens, ETokenType ... tokenTypes) {
        for (ETokenType tokenType : tokenTypes) {
            if (!TokenStreamUtils.hasTokenTypeSequence(tokens, 0, tokenType)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWith(List<IToken> tokens, ETokenType ... sequence) {
        return TokenStreamUtils.hasTokenTypeSequence(tokens, tokens.size() - sequence.length, sequence);
    }

    public static int count(List<IToken> tokens, ETokenType tokenType) {
        int counter = 0;
        for (IToken token : tokens) {
            if (token.getType() != tokenType) continue;
            ++counter;
        }
        return counter;
    }

    public static int countWithoutNesting(List<IToken> tokens, ETokenType tokenType, ETokenType openingType, ETokenType closingType) {
        return TokenStreamUtils.countWithoutNesting(tokens, tokenType, Collections.singletonList(openingType), Collections.singletonList(closingType));
    }

    private static int countWithoutNesting(List<IToken> tokens, ETokenType tokenType, List<ETokenType> openingType, List<ETokenType> closingType) {
        int counter = 0;
        NestingAwareTokenIterator iterator = new NestingAwareTokenIterator(tokens, 0, openingType, closingType);
        while (iterator.hasNext()) {
            IToken token = iterator.next();
            if (!iterator.isTopLevel() || token.getType() != tokenType) continue;
            ++counter;
        }
        return counter;
    }

    public static List<IToken> findAllTokens(List<IToken> tokens, ITokenMatcher types) {
        ArrayList<IToken> result = new ArrayList<IToken>();
        for (Integer index : TokenStreamUtils.findAll(tokens, 0, tokens.size(), types)) {
            result.add(tokens.get(index));
        }
        return result;
    }

    public static List<Integer> findAll(List<IToken> tokens, ITokenMatcher matcher) {
        return TokenStreamUtils.findAll(tokens, 0, tokens.size(), matcher);
    }

    public static List<Integer> findAll(List<IToken> tokens, int startTokenIndex, int endTokenIndex, ITokenMatcher types) {
        TokenStreamUtils.assertListRange(tokens, startTokenIndex, endTokenIndex);
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = startTokenIndex; i < endTokenIndex; ++i) {
            if (!types.matches(tokens.get(i))) continue;
            indices.add(i);
        }
        return indices;
    }

    public static List<List<IToken>> split(List<IToken> tokens, Set<ETokenType> splitTypes) {
        return TokenStreamUtils.split(tokens, splitTypes, Integer.MAX_VALUE);
    }

    public static List<List<IToken>> split(List<IToken> tokens, ETokenType ... splitTypes) {
        return TokenStreamUtils.split(tokens, TokenStreamUtils.toEnumSet(splitTypes), Integer.MAX_VALUE);
    }

    public static List<List<IToken>> splitUntilToken(ETokenType haltingType, List<IToken> tokens, ETokenType ... splitTypes) {
        return TokenStreamUtils.splitInternal((ITokenMatcher)haltingType, tokens, ITokenMatcher.anyOfType((ETokenType[])splitTypes), Integer.MAX_VALUE);
    }

    public static List<List<IToken>> split(List<IToken> tokens, Set<ETokenType> splitTypes, int limit) {
        return TokenStreamUtils.split(tokens, ITokenMatcher.anyOfType(splitTypes), limit);
    }

    public static List<List<IToken>> split(List<IToken> tokens, ITokenMatcher splitTokenMatcher, int limit) {
        return TokenStreamUtils.splitInternal(ITokenMatcher.never(), tokens, splitTokenMatcher, limit);
    }

    private static List<List<IToken>> splitInternal(ITokenMatcher isHaltToken, List<IToken> tokens, ITokenMatcher splitTokenMatcher, int limit) throws AssertionError {
        CCSMAssert.isTrue((limit > 0 ? 1 : 0) != 0, (String)"The limit must be greater than zero");
        ArrayList<List<IToken>> parts = new ArrayList<List<IToken>>();
        int start = 0;
        int end = tokens.size();
        for (int i = 0; i < tokens.size() && parts.size() != limit - 1; ++i) {
            if (isHaltToken.matches(tokens.get(i))) {
                end = i;
                break;
            }
            if (!splitTokenMatcher.matches(tokens.get(i))) continue;
            List<IToken> part = tokens.subList(start, i);
            parts.add(part);
            start = i + 1;
        }
        parts.add(tokens.subList(start, end));
        return parts;
    }

    public static boolean hasTokenTypeSequence(List<IToken> tokens, int startTokenIndex, ETokenType ... sequence) {
        return TokenStreamUtils.hasTokenTypeSequence(tokens, startTokenIndex, Arrays.asList(sequence));
    }

    public static boolean hasTokenTypeSequence(List<IToken> tokens, int startTokenIndex, List<ETokenType> sequence) {
        if (startTokenIndex + sequence.size() > tokens.size() || startTokenIndex < 0) {
            return false;
        }
        ListIterator<IToken> tokenIter = tokens.listIterator(startTokenIndex);
        for (ETokenType expectedTokenType : sequence) {
            IToken actualToken = (IToken)tokenIter.next();
            if (actualToken.getType() == expectedTokenType) continue;
            return false;
        }
        return true;
    }

    public static int skipTo(List<IToken> tokens, int startTokenIndex, Predicate<IToken> canBeSkipped, List<ETokenType> skipTo) {
        if (skipTo.isEmpty()) {
            throw new IllegalArgumentException("Must provide at least a single token to skip to");
        }
        if (tokens.size() < startTokenIndex + skipTo.size() || startTokenIndex < 0) {
            return -1;
        }
        ListIterator<IToken> iter = tokens.listIterator(startTokenIndex);
        while (iter.hasNext()) {
            IToken actualToken = iter.next();
            if (TokenStreamUtils.hasTokenTypeSequence(tokens, iter.previousIndex(), skipTo)) {
                return iter.previousIndex();
            }
            if (canBeSkipped.test(actualToken)) continue;
            return -1;
        }
        return -1;
    }

    private static boolean hasTokenClassOrTypeSequence(List<IToken> tokens, int startTokenIndex, ITokenMatcher ... sequence) {
        if (startTokenIndex + sequence.length > tokens.size() || startTokenIndex < 0) {
            return false;
        }
        for (int i = 0; i < sequence.length; ++i) {
            if (sequence[i].matches(tokens.get(startTokenIndex + i))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsTokenIndexPredicate(List<IToken> tokens, BiPredicate<Integer, List<IToken>> predicate) {
        return TokenStreamUtils.firstTokenMatchingIndexPredicate(tokens, 0, predicate) != -1;
    }

    public static int firstTokenMatchingIndexPredicate(List<IToken> tokens, int startTokenIndex, BiPredicate<Integer, List<IToken>> predicate) {
        for (int i = startTokenIndex; i < tokens.size(); ++i) {
            if (!predicate.test(i, tokens)) continue;
            return i;
        }
        return -1;
    }

    public static IToken findFirstTokenOverlappingWith(List<IToken> tokens, int startOffset, int endOffset) {
        int tokenIndex = TokenStreamUtils.firstTokenMatchingIndexPredicate(tokens, 0, (i, list) -> ((IToken)list.get((int)i)).getEndOffset() > startOffset && ((IToken)list.get((int)i)).getOffset() < endOffset);
        if (tokenIndex == -1) {
            return null;
        }
        return tokens.get(tokenIndex);
    }

    public static int firstTokenOfTypeSequence(List<IToken> tokens, int startTokenIndex, int endTokenIndex, ETokenType ... sequence) {
        for (int i = startTokenIndex; i < endTokenIndex; ++i) {
            if (!TokenStreamUtils.hasTokenTypeSequence(tokens, i, sequence)) continue;
            return i;
        }
        return -1;
    }

    public static List<Integer> allStartingIndicesOfTypeSequence(List<IToken> tokens, int startTokenIndex, int endTokenIndex, ETokenType ... sequence) {
        ArrayList<Integer> startingIndices = new ArrayList<Integer>();
        for (int i = startTokenIndex; i < endTokenIndex; ++i) {
            if (!TokenStreamUtils.hasTokenTypeSequence(tokens, i, sequence)) continue;
            startingIndices.add(i);
        }
        return startingIndices;
    }

    public static int firstTokenOfTypeSequence(List<IToken> tokens, int startTokenIndex, ETokenType ... sequence) {
        return TokenStreamUtils.firstTokenOfTypeSequence(tokens, startTokenIndex, tokens.size() - sequence.length + 1, sequence);
    }

    public static List<Integer> firstTokenOfTypeSequences(List<IToken> tokens, int startTokenIndex, ETokenType ... sequence) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        while (startTokenIndex < tokens.size() - sequence.length + 1 && (startTokenIndex = TokenStreamUtils.firstTokenOfTypeSequence(tokens, startTokenIndex, sequence)) != -1) {
            indices.add(startTokenIndex);
            ++startTokenIndex;
        }
        return indices;
    }

    public static List<Integer> firstTokenOfClassOrTypeSequence(List<IToken> tokens, ITokenMatcher ... sequence) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int startTokenIndex = 0;
        while (startTokenIndex < tokens.size() - sequence.length + 1 && (startTokenIndex = TokenStreamUtils.firstTokenOfClassOrTypeSequence(tokens, startTokenIndex, tokens.size() - sequence.length + 1, sequence)) != -1) {
            indices.add(startTokenIndex++);
        }
        return indices;
    }

    public static boolean hasTypes(List<IToken> tokens, ETokenType ... types) {
        if (tokens.size() != types.length) {
            return false;
        }
        return TokenStreamUtils.hasTokenTypeSequence(tokens, 0, types);
    }

    public static List<IToken> tokensBetweenWithNesting(List<IToken> tokens, ETokenType openingType, ETokenType closingType) {
        return TokenStreamUtils.tokensBetweenWithNesting(tokens, 0, openingType, closingType);
    }

    public static List<IToken> tokensBetweenWithNesting(List<IToken> tokens, int startTokenIndex, ETokenType openingType, ETokenType closingType) {
        int closingIndex;
        int openingIndex = TokenStreamUtils.firstTokenMatching(tokens, startTokenIndex, (ITokenMatcher)openingType);
        if (openingIndex == -1) {
            return CollectionUtils.emptyList();
        }
        if ((closingIndex = TokenStreamUtils.findMatchingClosingToken(tokens, ++openingIndex, openingType, closingType)) == -1) {
            return CollectionUtils.emptyList();
        }
        return tokens.subList(openingIndex, closingIndex);
    }

    public static List<List<IToken>> splitWithNesting(List<IToken> tokens, ETokenType splitType, ETokenType openingType, ETokenType closingType) {
        return TokenStreamUtils.splitWithNesting(tokens, splitType, Collections.singletonList(openingType), Collections.singletonList(closingType));
    }

    public static Pair<List<List<IToken>>, Integer> splitWithNestingHalting(List<IToken> tokens, ETokenType splitType, List<ETokenType> openingType, List<ETokenType> closingType) {
        return TokenStreamUtils.splitWithNestingInternal(tokens, EnumSet.of(splitType), Integer.MAX_VALUE, new NestingAwareHaltingTokenIterator(tokens, 0, openingType, closingType));
    }

    public static List<List<IToken>> splitWithNesting(List<IToken> tokens, ETokenType splitType, List<ETokenType> openingTypes, List<ETokenType> closingTypes) {
        return TokenStreamUtils.splitWithNesting(tokens, EnumSet.of(splitType), openingTypes, closingTypes, Integer.MAX_VALUE);
    }

    public static List<List<IToken>> splitWithNesting(List<IToken> tokens, Set<ETokenType> splitTypes, List<ETokenType> openingTypes, List<ETokenType> closingTypes, int limit) {
        return (List)TokenStreamUtils.splitWithNestingInternal(tokens, splitTypes, limit, new NestingAwareTokenIterator(tokens, 0, openingTypes, closingTypes)).getFirst();
    }

    private static Pair<List<List<IToken>>, Integer> splitWithNestingInternal(List<IToken> tokens, Set<ETokenType> splitTypes, int limit, NestingAwareTokenIterator iterator) {
        CCSMAssert.isTrue((limit > 0 ? 1 : 0) != 0, (String)"The limit must be greater than zero");
        if (!iterator.hasNext()) {
            return new Pair((Object)CollectionUtils.emptyList(), (Object)0);
        }
        ArrayList<List<IToken>> parts = new ArrayList<List<IToken>>();
        int start = 0;
        while (iterator.hasNext()) {
            if (parts.size() == limit - 1) {
                parts.add(tokens.subList(start, tokens.size()));
                return new Pair(parts, (Object)tokens.size());
            }
            IToken token = iterator.next();
            if (!iterator.isTopLevel() || !splitTypes.contains(token.getType())) continue;
            List<IToken> part = tokens.subList(start, iterator.getCurrentIndex());
            parts.add(part);
            start = iterator.getCurrentIndex() + 1;
        }
        parts.add(tokens.subList(start, iterator.getCurrentIndex() + 1));
        return new Pair(parts, (Object)(iterator.getCurrentIndex() + 1));
    }

    public static IToken createToken(IToken referenceToken, String text, ETokenType type) {
        return referenceToken.newToken(type, referenceToken.getOffset(), referenceToken.getLineNumber(), text, referenceToken.getOriginId());
    }

    public static List<IToken> copyTokens(IToken referenceToken, List<IToken> tokens) {
        return CollectionUtils.map(tokens, token -> TokenStreamUtils.createToken(referenceToken, token.getText(), token.getType()));
    }

    public static List<IToken> removeAtEnd(List<IToken> tokens, ETokenType type) {
        if (TokenStreamUtils.endsWith(tokens, type)) {
            tokens = tokens.subList(0, tokens.size() - 1);
        }
        return tokens;
    }

    public static List<IToken> removeAtFront(List<IToken> tokens, ETokenType type) {
        if (TokenStreamUtils.startsWith(tokens, type)) {
            tokens = CollectionUtils.getRest(tokens);
        }
        return tokens;
    }

    public static @Nullable IToken getTokenByTypeAndText(List<IToken> tokens, String tokenText, Set<ETokenType> tokenTypes) {
        for (IToken token : tokens) {
            if (!tokenTypes.contains(token.getType()) || !token.getText().equalsIgnoreCase(tokenText)) continue;
            return token;
        }
        return null;
    }

    public static List<IToken> getTokensBetween(List<IToken> tokens, int startOffset, int endOffset) {
        IToken token;
        int startTokenIndex = TokenStreamUtils.indexOfByOffsetFuzzy(tokens, startOffset);
        if (startTokenIndex == -1) {
            return CollectionUtils.emptyList();
        }
        ArrayList<IToken> result = new ArrayList<IToken>();
        for (int i = startTokenIndex; i < tokens.size() && endOffset > (token = tokens.get(i)).getOffset(); ++i) {
            if (startOffset > token.getOffset()) continue;
            result.add(token);
        }
        return result;
    }

    public static List<String> getTokenTextsByType(List<IToken> tokens, ETokenType tokenType) {
        ArrayList<String> result = new ArrayList<String>();
        for (IToken token : tokens) {
            if (token.getType() != tokenType) continue;
            result.add(token.getText());
        }
        return result;
    }

    private static int indexOfByOffsetFuzzy(List<IToken> tokens, int offset) {
        return TokenStreamUtils.indexOfByOffset(tokens, offset, true);
    }

    public static int indexOfByOffset(List<IToken> tokens, int offset) {
        return TokenStreamUtils.indexOfByOffset(tokens, offset, false);
    }

    private static int indexOfByOffset(List<IToken> tokens, int offset, boolean fuzzyMatch) {
        int leftSearchBoundary = 0;
        int rightSearchBoundary = tokens.size() - 1;
        int matchingIndex = -1;
        while (leftSearchBoundary <= rightSearchBoundary) {
            int currentIndex = (leftSearchBoundary + rightSearchBoundary) / 2;
            if (tokens.get(currentIndex).getOffset() < offset) {
                leftSearchBoundary = currentIndex + 1;
                continue;
            }
            if (tokens.get(currentIndex).getOffset() > offset) {
                rightSearchBoundary = currentIndex - 1;
                continue;
            }
            matchingIndex = currentIndex;
            break;
        }
        if (matchingIndex == -1) {
            if (fuzzyMatch) {
                return leftSearchBoundary;
            }
            return -1;
        }
        while (matchingIndex > 0 && tokens.get(matchingIndex - 1).getOffset() == offset) {
            --matchingIndex;
        }
        return matchingIndex;
    }

    public static List<Integer> indicesOfByPredicate(List<IToken> tokens, Predicate<IToken> includeToken) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < tokens.size(); ++i) {
            if (!includeToken.test(tokens.get(i))) continue;
            indices.add(i);
        }
        return indices;
    }

    public static @Nullable ELanguage getLanguage(Collection<IToken> tokens) {
        if (tokens.isEmpty()) {
            return null;
        }
        return tokens.stream().findFirst().get().getLanguage();
    }

    public static String determineMostSpecificOrigin(Collection<IToken> tokens) {
        if (tokens.isEmpty()) {
            return null;
        }
        String originId = null;
        for (IToken token : tokens) {
            originId = token.getOriginId();
            if (ArtificialTokenOriginIds.ARTIFICIAL_ORIGINS.contains(originId)) continue;
            return originId;
        }
        return originId;
    }

    public static List<Integer> getTopLevelCommaIndices(List<IToken> tokens, int startTokenIndex, int endTokenIndex, List<ETokenType> openingTypes, List<ETokenType> closingTypes) {
        return TokenStreamUtils.getTopLevelTokenTypeIndices(tokens, startTokenIndex, endTokenIndex, Collections.singleton(ETokenType.COMMA), openingTypes, closingTypes);
    }

    public static List<Integer> getTopLevelTokenTypeIndices(List<IToken> tokens, int startTokenIndex, int endTokenIndex, Set<ETokenType> topLevelTypes, List<ETokenType> openingTypes, List<ETokenType> closingTypes) {
        if (startTokenIndex >= tokens.size() || startTokenIndex < 0 || endTokenIndex < 0 || endTokenIndex > tokens.size() || startTokenIndex > endTokenIndex) {
            return Collections.emptyList();
        }
        ArrayList<Integer> commaIndices = new ArrayList<Integer>();
        NestingAwareTokenIterator iterator = new NestingAwareTokenIterator(tokens, startTokenIndex, openingTypes, closingTypes);
        while (iterator.hasNext()) {
            IToken token = iterator.next();
            if (iterator.getCurrentIndex() == endTokenIndex) break;
            if (!iterator.isTopLevel() || !topLevelTypes.contains(token.getType())) continue;
            if (EnumSet.of(ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.JAVA, ELanguage.CS).contains(token.getLanguage()) && !commaIndices.isEmpty() && token.getType() == ETokenType.GT && tokens.get((Integer)commaIndices.getLast()).getType() == ETokenType.LT) {
                commaIndices.removeLast();
                continue;
            }
            commaIndices.add(iterator.getCurrentIndex());
        }
        return commaIndices;
    }

    public static List<Integer> getTopLevelCommaIndices(List<IToken> tokens, int startTokenIndex, int endTokenIndex) {
        return TokenStreamUtils.getTopLevelCommaIndices(tokens, startTokenIndex, endTokenIndex, Collections.singletonList(ETokenType.LPAREN), Collections.singletonList(ETokenType.RPAREN));
    }

    public static List<Integer> getTopLevelTokenTypeIndices(List<IToken> tokens, Set<ETokenType> topLevelTypes, List<ETokenType> openingTypes, List<ETokenType> closingTypes) {
        return TokenStreamUtils.getTopLevelTokenTypeIndices(tokens, 0, tokens.size(), topLevelTypes, openingTypes, closingTypes);
    }

    public static boolean startsNewStatement(IToken token, IToken lastToken, ITokenMatcher continueTokens, ITokenMatcher nonContinuationTokens, ITokenMatcher newStatementToken) {
        if (lastToken == null) {
            return false;
        }
        if (token == null) {
            return true;
        }
        if (newStatementToken.matches(token)) {
            return true;
        }
        if (!nonContinuationTokens.matches(lastToken) && ETokenType.ETokenClass.OPERATOR.matches(lastToken)) {
            return false;
        }
        if (continueTokens.matches(token) || continueTokens.matches(lastToken)) {
            return false;
        }
        return lastToken.getLineNumber() < token.getLineNumber();
    }

    public static int endIndexIfNotFound(int index, List<?> tokens) {
        if (index == -1) {
            return tokens.size();
        }
        return index;
    }

    public static void removeAllOfSequence(List<IToken> tokens, ETokenType ... sequence) {
        for (int i = 0; i <= tokens.size() - sequence.length; ++i) {
            if (!TokenStreamUtils.hasTokenTypeSequence(tokens, i, sequence)) continue;
            for (int j = 0; j < sequence.length; ++j) {
                tokens.remove(i);
            }
        }
    }

    public static List<IToken> removeDoxygenTokens(Collection<IToken> tokens) {
        ArrayList<IToken> result = new ArrayList<IToken>();
        int nestingDepth = 0;
        int doxygenDepth = -1;
        for (IToken token : tokens) {
            if (token.getType() != ETokenType.PREPROCESSOR_DIRECTIVE) {
                if (doxygenDepth != -1) continue;
                result.add(token);
                continue;
            }
            if (token.getText().startsWith("#ifdef")) {
                ++nestingDepth;
                if (doxygenDepth == -1 && token.getText().contains("DOXYGEN")) {
                    doxygenDepth = nestingDepth;
                    result.add(token);
                }
            } else if (token.getText().startsWith("#endif")) {
                if (--nestingDepth < doxygenDepth) {
                    doxygenDepth = -1;
                }
            } else if (token.getText().startsWith("#else") && nestingDepth == doxygenDepth) {
                doxygenDepth = -1;
            }
            if (doxygenDepth != -1) continue;
            result.add(token);
        }
        return result;
    }

    public static void removeTokensInRange(List<IToken> tokens, int startIndex, int endIndex) {
        if (endIndex >= tokens.size() || startIndex >= tokens.size()) {
            return;
        }
        while (endIndex >= startIndex) {
            tokens.remove(endIndex);
            --endIndex;
        }
    }

    public static List<IToken> tokensFromTo(List<IToken> tokens, int start, ETokenType ... tokenTypes) {
        int endOfStatement = TokenStreamUtils.firstTokenMatching(tokens, start, ITokenMatcher.anyOfType((ETokenType[])tokenTypes));
        if (endOfStatement == -1) {
            return Collections.emptyList();
        }
        return tokens.subList(start, endOfStatement);
    }

    private TokenStreamUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

