/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.cobol;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.languages.cobol.ECobolParserState;
import java.util.List;

public class NoElseRecognizer
extends RecognizerBase<ECobolParserState> {
    private final ETokenType ifType;
    private final ETokenType endIfType;

    public NoElseRecognizer(ETokenType ifType, ETokenType endIfType) {
        this.ifType = ifType;
        this.endIfType = endIfType;
    }

    @Override
    protected int matchesLocally(ParserState<ECobolParserState> parserState, List<IToken> tokens, int startOffset) {
        int countElseTokens;
        int endIfOrDotTokenIndex = TokenStreamUtils.firstTokenMatching(tokens, startOffset, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{this.endIfType, ETokenType.DOT}));
        if (endIfOrDotTokenIndex == -1) {
            return -1;
        }
        List<IToken> newTokens = tokens.subList(startOffset, endIfOrDotTokenIndex);
        int countIfTokens = TokenStreamUtils.count(newTokens, this.ifType);
        ETokenType elseType = ETokenType.ELSE;
        if (this.ifType == ETokenType.DOLLAR_IF) {
            elseType = ETokenType.DOLLAR_ELSE;
        }
        if (countIfTokens >= (countElseTokens = TokenStreamUtils.count(newTokens, elseType))) {
            return super.matchesLocally(parserState, newTokens, startOffset);
        }
        return -1;
    }
}

