/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.esql;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;

public class EsqlShallowParser
extends ShallowParserBase<EEsqlParserStates> {
    private static final ITokenMatcher ESQL_NODE_TYPES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COMPUTE, ETokenType.DATABASE, ETokenType.DATABASEEVENT, ETokenType.FILTER});
    private static final ITokenMatcher GENERAL_RULE_START_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ATTACH, ETokenType.CALL, ETokenType.CONTINUE, ETokenType.DELETE, ETokenType.DETACH, ETokenType.EVAL, ETokenType.EXEC, ETokenType.EXECUTE, ETokenType.KILL, ETokenType.LEAVE, ETokenType.LOG, ETokenType.MERGE, ETokenType.MOVE, ETokenType.PRINT, ETokenType.PROPAGATE, ETokenType.RESIGNAL, ETokenType.SAVE, ETokenType.SEND, ETokenType.SET, ETokenType.SETUSER, ETokenType.SHUTDOWN, ETokenType.THROW, ETokenType.WAITFOR});
    private static final ITokenMatcher ESQL_IDENTIFIER = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.AND, ETokenType.ANY, ETokenType.AS, ETokenType.ATOMIC, ETokenType.ATTACH, ETokenType.BEGIN, ETokenType.BIT, ETokenType.BLOB, ETokenType.BOOLEAN, ETokenType.BROKER, ETokenType.BY, ETokenType.CALL, ETokenType.CHAR, ETokenType.CHARACTER, ETokenType.COMPUTE, ETokenType.CONDITION, ETokenType.CONSTANT, ETokenType.CONTINUE, ETokenType.COUNT, ETokenType.CREATE, ETokenType.DATA, ETokenType.DATABASEEVENT, ETokenType.DATE, ETokenType.DAY, ETokenType.DAY_OF_WEEK, ETokenType.DAY_OF_YEAR, ETokenType.DECIMAL, ETokenType.DECLARE, ETokenType.DEFAULT, ETokenType.DELETE, ETokenType.DETACH, ETokenType.DO, ETokenType.DYNAMIC, ETokenType.ELSE, ETokenType.ELSEIF, ETokenType.ENCODING, ETokenType.END, ETokenType.ENVIRONMENT, ETokenType.ESCAPE, ETokenType.EVAL, ETokenType.EVENT, ETokenType.EXCEPTION, ETokenType.EXISTS, ETokenType.EXIT, ETokenType.EXTERNAL, ETokenType.FIELD, ETokenType.FILTER, ETokenType.FINALIZATION, ETokenType.FLOAT, ETokenType.FOR, ETokenType.FORMAT, ETokenType.FOUND, ETokenType.FULL, ETokenType.FUNCTION, ETokenType.GROUP, ETokenType.HANDLER, ETokenType.HAVING, ETokenType.HOUR, ETokenType.IDENTITY, ETokenType.IF, ETokenType.IN, ETokenType.INFINITY, ETokenType.INOUT, ETokenType.INSERT, ETokenType.INT, ETokenType.INTEGER, ETokenType.INTERVAL, ETokenType.INTO, ETokenType.IS, ETokenType.ITERATE, ETokenType.LABEL, ETokenType.LANGUAGE, ETokenType.LAST, ETokenType.LEAVE, ETokenType.LIKE, ETokenType.LIST, ETokenType.LOG, ETokenType.LOOP, ETokenType.MAX, ETokenType.MESSAGE, ETokenType.MIN, ETokenType.MINUTE, ETokenType.MODIFIES, ETokenType.MODULE, ETokenType.MONTH, ETokenType.MONTHS, ETokenType.MOVE, ETokenType.NAMESPACE, ETokenType.NAN, ETokenType.NONE, ETokenType.NUMBER, ETokenType.OF, ETokenType.OPTIONS, ETokenType.OR, ETokenType.ORDER, ETokenType.OUT, ETokenType.PARSE, ETokenType.PASSTHRU, ETokenType.PATH, ETokenType.PROCEDURE, ETokenType.PROPAGATE, ETokenType.READS, ETokenType.REFERENCE, ETokenType.REPEAT, ETokenType.RESIGNAL, ETokenType.RESULT, ETokenType.RETURN, ETokenType.RETURNS, ETokenType.ROW, ETokenType.SCHEMA, ETokenType.SECOND, ETokenType.SELECT, ETokenType.SET, ETokenType.SHARED, ETokenType.SHORT, ETokenType.SOME, ETokenType.SQL, ETokenType.SQLCODE, ETokenType.SQLEXCEPTION, ETokenType.SQLSTATE, ETokenType.SQLWARNING, ETokenType.SUM, ETokenType.TABLE, ETokenType.TERMINAL, ETokenType.THE, ETokenType.THEN, ETokenType.THROW, ETokenType.TIME, ETokenType.TIMESTAMP, ETokenType.TO, ETokenType.TRACE, ETokenType.TYPE, ETokenType.UNKNOWN, ETokenType.UNTIL, ETokenType.UPDATE, ETokenType.USER, ETokenType.VALUES, ETokenType.WHERE, ETokenType.WHILE, ETokenType.YEAR, ETokenType.ALL, ETokenType.ALTER, ETokenType.BETWEEN, ETokenType.CHECK, ETokenType.CURRENT, ETokenType.DROP, ETokenType.FETCH, ETokenType.GRANT, ETokenType.INDEX, ETokenType.INTERSECT, ETokenType.ON, ETokenType.PUBLIC, ETokenType.REVOKE, ETokenType.UNION, ETokenType.UNIQUE, ETokenType.WITH});
    private static final ITokenMatcher INSERT_TOKENS_TO_SKIP = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.INTO, ETokenType.OUTPUT, ETokenType.TOP, ETokenType.INTEGER_LITERAL, ETokenType.LPAREN, ETokenType.RPAREN, ETokenType.LBRACE, ETokenType.RBRACE, ETokenType.DOT, ETokenType.COMMA, ETokenType.WITH, ETokenType.TABLE, ETokenType.SCHEMA}).or(new ITokenMatcher[]{ESQL_IDENTIFIER}).except(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DEFAULT, ETokenType.VALUES, ETokenType.EXEC, ETokenType.EXECUTE, ETokenType.SELECT})});

    public EsqlShallowParser() {
        super(EEsqlParserStates.class, EEsqlParserStates.STATEMENTS);
        this.createTopLevelRules();
    }

    private void createTopLevelRules() {
        this.createMetaRules();
        this.createDatabaseRules();
        this.createCreateRules();
        this.createVariableRules();
        this.createCommonTableExpressionRules();
        this.createReturnRules();
        this.createBlockRules();
        this.createOtherStartRules();
    }

    private void createMetaRules() {
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.USE}).createNode(EShallowEntityType.META, ETokenType.USE.name().toLowerCase()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.BROKER, ETokenType.SCHEMA, ESQL_IDENTIFIER}).createNode(EShallowEntityType.META, "broker schema", INameResolver.previousTokenText()).optionalSubRecognizer(this.createRecognizer(start -> start.skipAfter(new ITokenMatcher[]{ETokenType.PATH}).skipAfterWithNesting((ITokenMatcher)ETokenType.SEMICOLON, Arrays.asList(ETokenType.LPAREN, ETokenType.CASE), Arrays.asList(ETokenType.RPAREN, ETokenType.END)))).endNode();
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.PATH}).createNode(EShallowEntityType.META, ETokenType.PATH.name().toLowerCase()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createDatabaseRules() {
        this.createSelectRule();
        this.createInsertRules();
        this.createUpdateRules();
        this.createGrantRule();
        this.createPassthruRules();
        this.createDeleteFromRule();
    }

    private void createSelectRule() {
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.SELECT}).createNode(EShallowEntityType.STATEMENT, "select").skipAfterWithNesting((ITokenMatcher)ETokenType.SEMICOLON, Arrays.asList(ETokenType.LPAREN, ETokenType.CASE, ETokenType.UNION, ETokenType.INTERSECT, ETokenType.EXCEPT), Arrays.asList(ETokenType.RPAREN, ETokenType.END, ETokenType.SELECT, ETokenType.SELECT, ETokenType.SELECT)).endNode();
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.CTE}).sequence(new ITokenMatcher[]{ETokenType.SELECT}).createNode(EShallowEntityType.STATEMENT, "select").skipBeforeWithNesting((ITokenMatcher)ETokenType.RPAREN, Arrays.asList(ETokenType.LPAREN, ETokenType.CASE, ETokenType.UNION, ETokenType.INTERSECT, ETokenType.EXCEPT), Arrays.asList(ETokenType.RPAREN, ETokenType.END, ETokenType.SELECT, ETokenType.SELECT, ETokenType.SELECT)).endNode();
    }

    private void createInsertRules() {
        RecognizerBase fromInsertTo = this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.INSERT}).skipWhile(INSERT_TOKENS_TO_SKIP);
        EsqlShallowParser.createInsertStatement(fromInsertTo.optional(new ITokenMatcher[]{ETokenType.DEFAULT}).sequence(new ITokenMatcher[]{ETokenType.VALUES}));
        EsqlShallowParser.createInsertStatement(fromInsertTo.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EXEC, ETokenType.EXECUTE})));
        EsqlShallowParser.createInsertStatement(fromInsertTo.sequence(new ITokenMatcher[]{ETokenType.SELECT}));
        RecognizerBase withSubRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.WITH, ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN));
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.BULK, ETokenType.INSERT}).createNode(EShallowEntityType.STATEMENT, "bulk insert").skipAfter(new ITokenMatcher[]{ETokenType.FROM}).sequence(ESQL_IDENTIFIER.or(new ITokenMatcher[]{ETokenType.STRING_LITERAL})).optionalSubRecognizer(withSubRecognizer).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private static void createInsertStatement(RecognizerBase<EEsqlParserStates> recognizerBase) {
        recognizerBase.createNode(EShallowEntityType.STATEMENT, "insert").skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createUpdateRules() {
        this.createUpdateSetRecognizerBase().skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.createUpdateSetRecognizerBase().skipAfterWithNesting((ITokenMatcher)ETokenType.WHERE, Arrays.asList(ETokenType.LPAREN, ETokenType.CASE), Arrays.asList(ETokenType.RPAREN, ETokenType.END)).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private RecognizerBase<EEsqlParserStates> createUpdateSetRecognizerBase() {
        return this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.UPDATE}).createNode(EShallowEntityType.STATEMENT, "update").skipAfterWithNesting((ITokenMatcher)ETokenType.SET, Arrays.asList(ETokenType.LPAREN, ETokenType.CASE), Arrays.asList(ETokenType.RPAREN, ETokenType.END));
    }

    private void createGrantRule() {
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.GRANT}).skipAfter(new ITokenMatcher[]{ETokenType.ON}).createNode(EShallowEntityType.STATEMENT, "grant", INameResolver.secondMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createPassthruRules() {
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.PASSTHRU, ETokenType.STRING_LITERAL}).optional(new ITokenMatcher[]{ETokenType.TO}).createNode(EShallowEntityType.STATEMENT, "passthru").skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.PASSTHRU, ETokenType.LPAREN}).createNode(EShallowEntityType.STATEMENT, "passthru").skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, Arrays.asList(ETokenType.LPAREN, ETokenType.CASE), Arrays.asList(ETokenType.RPAREN, ETokenType.END)).sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.PASSTHRU, ESQL_IDENTIFIER, ETokenType.LPAREN}).createNode(EShallowEntityType.STATEMENT, "passthru").skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, Arrays.asList(ETokenType.LPAREN, ETokenType.CASE), Arrays.asList(ETokenType.RPAREN, ETokenType.END)).sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createDeleteFromRule() {
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.DELETE, ETokenType.FROM}).createNode(EShallowEntityType.STATEMENT, "delete").skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createCreateRules() {
        this.createSchemaRule();
        this.createModuleRule();
        this.createFunctionOrProcedureRules();
        this.createDeclareHandlerRule();
        this.createTableRule();
        this.createGeneralCreateRules();
    }

    private RecognizerBase<EEsqlParserStates> startCreateRule() {
        return this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.CREATE});
    }

    private void createSchemaRule() {
        this.startCreateRule().sequence(new ITokenMatcher[]{ETokenType.SCHEMA, ESQL_IDENTIFIER}).createNode(EShallowEntityType.META, INameResolver.concat(INameResolver.firstMatchedTokenText(), INameResolver.ofString("schema")), INameResolver.previousTokenText()).endNode();
    }

    private void createModuleRule() {
        this.startCreateRule().optional(new ITokenMatcher[]{ETokenType.OR, ETokenType.REPLACE}).optional(ESQL_NODE_TYPES).sequence(new ITokenMatcher[]{ETokenType.MODULE, ESQL_IDENTIFIER}).createNode(EShallowEntityType.MODULE, INameResolver.concat(INameResolver.firstMatchedTokenText(), INameResolver.ofString("module")), INameResolver.previousTokenText()).parseMultiple(EEsqlParserStates.STATEMENTS).skipAfter(new ITokenMatcher[]{ETokenType.END, ETokenType.MODULE, ETokenType.SEMICOLON}).endNode();
    }

    private void createFunctionOrProcedureRules() {
        this.createFunctionBlockRules();
        this.createFunctionWithInstantReturn();
        this.createRoutineRules();
    }

    private void createFunctionBlockRules() {
        for (ETokenType type : EnumSet.of(ETokenType.FUNCTION, ETokenType.PROCEDURE)) {
            this.startCreateRule().sequence(new ITokenMatcher[]{type}).skipAfter(new ITokenMatcher[]{ETokenType.BEGIN}).createNode(EShallowEntityType.METHOD, type.name().toLowerCase(), INameResolver.ofIndex(2)).parseMultiple(EEsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END}).optional(ESQL_IDENTIFIER).sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        }
    }

    private void createFunctionWithInstantReturn() {
        for (ETokenType type : EnumSet.of(ETokenType.FUNCTION, ETokenType.PROCEDURE)) {
            this.startCreateRule().sequence(new ITokenMatcher[]{type}).skipAfter(new ITokenMatcher[]{ETokenType.RETURNS}).skipForward(1).sequenceBefore(new ITokenMatcher[]{ETokenType.RETURN}).createNode(EShallowEntityType.METHOD, type.name().toLowerCase(), INameResolver.ofIndex(2)).parseOnce(EEsqlParserStates.STATEMENTS).endNode();
        }
    }

    private void createRoutineRules() {
        this.startCreateRule().sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.FUNCTION, ETokenType.PROCEDURE})).skipAfter(new ITokenMatcher[]{ETokenType.LANGUAGE}).createNode(EShallowEntityType.METHOD, "routine", INameResolver.ofIndex(2)).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createDeclareHandlerRule() {
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.DECLARE, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CONTINUE, ETokenType.EXIT}), ETokenType.HANDLER, ETokenType.FOR}).skipAfter(new ITokenMatcher[]{ETokenType.BEGIN}).createNode(EShallowEntityType.STATEMENT, "declare_handler").parseMultiple(EEsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END, ETokenType.SEMICOLON}).endNode();
    }

    private void createTableRule() {
        this.startCreateRule().sequence(new ITokenMatcher[]{ETokenType.TABLE, ESQL_IDENTIFIER, ETokenType.LPAREN}).createNode(EShallowEntityType.STATEMENT, INameResolver.concat(INameResolver.firstMatchedTokenText(), INameResolver.ofString("table")), INameResolver.ofIndex(-2)).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, Collections.singletonList(ETokenType.LPAREN), Collections.singletonList(ETokenType.RPAREN)).endNode();
    }

    private void createGeneralCreateRules() {
        this.startCreateRule().createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createVariableRules() {
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.DECLARE}).createNode(EShallowEntityType.STATEMENT, "declare").skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createCommonTableExpressionRules() {
        RecognizerBase columnList = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN));
        RecognizerBase innerCte = this.createRecognizer(start -> start.sequence(ESQL_IDENTIFIER).optionalSubRecognizer(columnList).sequence(new ITokenMatcher[]{ETokenType.AS, ETokenType.LPAREN}).parseOnce(EEsqlParserStates.CTE).sequence(new ITokenMatcher[]{ETokenType.RPAREN}));
        RecognizerBase cteListRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.COMMA}).subRecognizer(innerCte));
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.WITH}).createNode(EShallowEntityType.STATEMENT, "common table expression").subRecognizer(innerCte).repeatedSubRecognizer(cteListRecognizer).parseOnce(EEsqlParserStates.STATEMENTS).endNode();
    }

    private void createReturnRules() {
        RecognizerBase<EEsqlParserStates> returnStatement = this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.RETURN}).createNode(EShallowEntityType.STATEMENT, "return");
        returnStatement.sequence(new ITokenMatcher[]{ETokenType.ETokenClass.LITERAL}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        returnStatement.parseOnce(EEsqlParserStates.STATEMENTS).endNode();
        returnStatement.skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createBlockRules() {
        this.createIfBlockRules();
        this.createLoopBlockRules();
        this.createBasicBlockRules();
        this.createCaseWhenBlockRules();
    }

    private void createIfBlockRules() {
        RecognizerBase<EEsqlParserStates> ifAlternative = this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IF, ETokenType.ELSEIF})).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.THEN, ETokenType.CASE, ETokenType.END).parseUntil(EEsqlParserStates.STATEMENTS).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ELSEIF, ETokenType.ELSE, ETokenType.END}));
        ifAlternative.sequence(new ITokenMatcher[]{ETokenType.END, ETokenType.IF, ETokenType.SEMICOLON}).endNode();
        ifAlternative.endNodeWithContinuation();
        RecognizerBase<EEsqlParserStates> elseMatcher = this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.ELSE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).parseUntil(EEsqlParserStates.STATEMENTS);
        elseMatcher.sequence(new ITokenMatcher[]{ETokenType.END, ETokenType.IF}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        elseMatcher.sequenceBefore(new ITokenMatcher[]{ETokenType.END, ETokenType.CASE}).endNode();
        elseMatcher.sequenceBefore(new ITokenMatcher[]{ETokenType.END}).endNode();
    }

    private void createLoopBlockRules() {
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.LOOP}).createNode(EShallowEntityType.STATEMENT, "loop").parseUntil(EEsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END, ETokenType.LOOP, ETokenType.SEMICOLON}).endNode();
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ESQL_IDENTIFIER, ETokenType.COLON, ETokenType.LOOP}).createNode(EShallowEntityType.STATEMENT, "loop", INameResolver.firstMatchedTokenText()).parseUntil(EEsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END, ETokenType.LOOP}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        ITokenMatcher forAndWhile = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.FOR, ETokenType.WHILE});
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(forAndWhile).createNode(EShallowEntityType.STATEMENT, INameResolver.previousTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DO}).parseUntil(EEsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END, forAndWhile, ETokenType.SEMICOLON}).endNode();
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ESQL_IDENTIFIER, ETokenType.COLON, forAndWhile}).createNode(EShallowEntityType.STATEMENT, INameResolver.previousTokenText(), INameResolver.firstMatchedTokenText()).parseUntil(EEsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END, forAndWhile}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.REPEAT}).createNode(EShallowEntityType.STATEMENT, "repeat until", INameResolver.firstMatchedTokenText()).parseUntil(EEsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.UNTIL}).skipAfter(new ITokenMatcher[]{ETokenType.END, ETokenType.REPEAT, ETokenType.SEMICOLON}).endNode();
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ESQL_IDENTIFIER, ETokenType.COLON, ETokenType.REPEAT}).createNode(EShallowEntityType.STATEMENT, "repeat until", INameResolver.firstMatchedTokenText()).parseUntil(EEsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.UNTIL}).skipAfter(new ITokenMatcher[]{ETokenType.END, ETokenType.REPEAT}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createBasicBlockRules() {
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.BEGIN}).createNode(EShallowEntityType.STATEMENT, "block").parseUntil(EEsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END, ETokenType.SEMICOLON}).endNode();
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ESQL_IDENTIFIER, ETokenType.COLON, ETokenType.BEGIN}).createNode(EShallowEntityType.STATEMENT, "block", INameResolver.firstMatchedTokenText()).parseUntil(EEsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END, ESQL_IDENTIFIER, ETokenType.SEMICOLON}).endNode();
    }

    private void createCaseWhenBlockRules() {
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.CASE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.WHEN, ETokenType.ELSE})).parseUntil(EEsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.WHEN}).skipAfter(new ITokenMatcher[]{ETokenType.THEN}).createNode(EShallowEntityType.STATEMENT, "when").parseUntil(EEsqlParserStates.STATEMENTS).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.WHEN, ETokenType.ELSE, ETokenType.END})).endNode();
    }

    private void createOtherStartRules() {
        this.inState(new EEsqlParserStates[]{EEsqlParserStates.STATEMENTS}).sequence(GENERAL_RULE_START_TOKENS).createNode(EShallowEntityType.STATEMENT, INameResolver.matchStartTokenTypeName()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    public static enum EEsqlParserStates {
        STATEMENTS,
        CTE;

    }
}

