/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.go;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.languages.base.EGenericParserStates;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class GoSkipToEndOfStatementRecognizer
extends RecognizerBase<EGenericParserStates> {
    private static final ITokenMatcher CONTINUE_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BACKSLASH, ETokenType.DOT, ETokenType.QUESTION, ETokenType.COLON, ETokenType.NOT, ETokenType.ADD});
    private static final ITokenMatcher NON_CONTINUATION_OPERATORS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.MINUSMINUS, ETokenType.PLUSPLUS});
    private static final Map<ETokenType, ETokenType> NESTING_MATCH = new EnumMap<ETokenType, ETokenType>(ETokenType.class);
    private static final ITokenMatcher NON_ANON_FUNCTION_TOKENS;
    private final boolean forceMatch;
    private final boolean parseAnonymousFunctions;

    GoSkipToEndOfStatementRecognizer() {
        this.forceMatch = false;
        this.parseAnonymousFunctions = true;
    }

    GoSkipToEndOfStatementRecognizer(boolean forceMatch, boolean parseAnonymousFunctions) {
        this.forceMatch = forceMatch;
        this.parseAnonymousFunctions = parseAnonymousFunctions;
    }

    @Override
    protected int matchesLocally(ParserState<EGenericParserStates> parserState, List<IToken> tokens, int startOffset) {
        if (startOffset < 0) {
            return -1;
        }
        IToken previousToken = null;
        if (!this.forceMatch && startOffset > 0) {
            previousToken = tokens.get(startOffset - 1);
        }
        Stack<ETokenType> expectedClosing = new Stack<ETokenType>();
        while (startOffset < tokens.size()) {
            IToken token = tokens.get(startOffset);
            ETokenType tokenType = token.getType();
            if (!expectedClosing.isEmpty() && tokenType == expectedClosing.peek()) {
                expectedClosing.pop();
            } else {
                if (expectedClosing.isEmpty() && tokenType == ETokenType.SEMICOLON && !ETokenType.FOR.matches(tokens.getFirst())) {
                    return startOffset + 1;
                }
                if (expectedClosing.isEmpty() && TokenStreamUtils.startsNewStatement(token, previousToken, CONTINUE_TOKENS, NON_CONTINUATION_OPERATORS, (ITokenMatcher)ETokenType.RBRACE)) {
                    return startOffset;
                }
                if (NESTING_MATCH.containsKey(tokenType)) {
                    expectedClosing.push(NESTING_MATCH.get(tokenType));
                } else if (this.parseAnonymousFunctions && (tokenType == ETokenType.FUNC && previousToken == null || tokenType == ETokenType.FUNC && !NON_ANON_FUNCTION_TOKENS.matches(previousToken))) {
                    int nextOffset = parserState.parse(EGenericParserStates.IN_EXPRESSION, tokens, startOffset);
                    if (nextOffset != -1) {
                        startOffset = nextOffset;
                        previousToken = tokens.get(startOffset - 1);
                        continue;
                    }
                } else {
                    previousToken = tokens.get(++startOffset - 1);
                    continue;
                }
            }
            previousToken = token;
            ++startOffset;
        }
        return startOffset;
    }

    static {
        NESTING_MATCH.put(ETokenType.LPAREN, ETokenType.RPAREN);
        NESTING_MATCH.put(ETokenType.LBRACK, ETokenType.RBRACK);
        NESTING_MATCH.put(ETokenType.LBRACE, ETokenType.RBRACE);
        NON_ANON_FUNCTION_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.RBRACK, ETokenType.RPAREN, ETokenType.CHAN});
    }
}

