/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.javascript;

import com.google.common.collect.Sets;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.javascript.GenericTypeAssigningEqualsRecognizer;
import eu.cqse.check.framework.shallowparser.languages.javascript.JavaScriptSimpleStatementRecognizer;
import eu.cqse.check.framework.shallowparser.languages.javascript.MethodNameIsUserDefinedRecognizer;
import eu.cqse.check.framework.shallowparser.languages.javascript.YuiCallRecognizer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.function.UnaryOperator;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class JavaScriptShallowParser
extends ShallowParserBase<EJavaScriptParserStates> {
    public static final ITokenMatcher ALL_IDENTIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.CLASS, ETokenType.IMPLEMENTS, ETokenType.DECLARE, ETokenType.ENUM, ETokenType.EXPORT, ETokenType.EXTENDS, ETokenType.INSTANCEOF, ETokenType.INTERFACE, ETokenType.MODULE, ETokenType.NAMESPACE, ETokenType.PRIVATE, ETokenType.PROTECTED, ETokenType.PUBLIC, ETokenType.STATIC, ETokenType.TYPE, ETokenType.SET, ETokenType.GET, ETokenType.ASYNC, ETokenType.DELETE, ETokenType.IMPORT, ETokenType.ABSTRACT, ETokenType.ASSERTS, ETokenType.IS, ETokenType.AS, ETokenType.FROM});
    private static final ITokenMatcher IDENTIFIER_LIKE = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.ABSTRACT, ETokenType.AS, ETokenType.ASSERTS, ETokenType.ASYNC, ETokenType.AWAIT, ETokenType.BOOLEAN_LITERAL, ETokenType.BREAK, ETokenType.CASE, ETokenType.CATCH, ETokenType.CLASS, ETokenType.CONST, ETokenType.CONSTRUCTOR, ETokenType.CONTINUE, ETokenType.DEBUGGER, ETokenType.DECLARE, ETokenType.DEFAULT, ETokenType.DELETE, ETokenType.DO, ETokenType.ELSE, ETokenType.ENUM, ETokenType.EXPORT, ETokenType.EXTENDS, ETokenType.FINALLY, ETokenType.FOR, ETokenType.FROM, ETokenType.FUNCTION, ETokenType.GET, ETokenType.IF, ETokenType.IMPLEMENTS, ETokenType.IMPORT, ETokenType.IN, ETokenType.INSTANCEOF, ETokenType.INTERFACE, ETokenType.IS, ETokenType.KEYOF, ETokenType.LET, ETokenType.MODULE, ETokenType.NAMESPACE, ETokenType.NEW, ETokenType.PACKAGE, ETokenType.PRIVATE, ETokenType.PROTECTED, ETokenType.PUBLIC, ETokenType.READONLY, ETokenType.RETURN, ETokenType.SET, ETokenType.STATIC, ETokenType.SUPER, ETokenType.SWITCH, ETokenType.THIS, ETokenType.THROW, ETokenType.TRY, ETokenType.TYPE, ETokenType.TYPEOF, ETokenType.VAR, ETokenType.VOID, ETokenType.WHILE, ETokenType.WITH, ETokenType.YIELD});
    public static final ITokenMatcher PROPERTY_NAME = IDENTIFIER_LIKE.or(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.STRING_LITERAL, ETokenType.INTEGER_LITERAL})});
    private static final ITokenMatcher TYPESCRIPT_MODIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.STATIC, ETokenType.PUBLIC, ETokenType.PRIVATE, ETokenType.PROTECTED, ETokenType.READONLY, ETokenType.GET, ETokenType.SET, ETokenType.ASYNC, ETokenType.ABSTRACT, ETokenType.OVERRIDE});
    private static final ITokenMatcher TYPESCRIPT_ACCESS_MODIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PUBLIC, ETokenType.PRIVATE, ETokenType.PROTECTED});
    private static final UnmodifiableList<ETokenType> OPEN_DELIMITER = CollectionUtils.asUnmodifiable(Arrays.asList(ETokenType.LBRACE, ETokenType.LBRACK, ETokenType.LPAREN));
    private static final UnmodifiableList<ETokenType> CLOSE_DELIMITER = CollectionUtils.asUnmodifiable(Arrays.asList(ETokenType.RBRACE, ETokenType.RBRACK, ETokenType.RPAREN));

    public JavaScriptShallowParser() {
        super(EJavaScriptParserStates.class, EJavaScriptParserStates.TOP_LEVEL);
        this.createLambdaRules();
        this.createMetaRules();
        this.createAngularRules();
        this.createModuleRules();
        this.createBaseJSRules();
        this.createClosureRecognizers();
        this.createClosureES6Recognizers();
        this.createTypeRules();
        this.createExtJsTypeSupport();
        this.createTypeMemberRules();
        this.recognizeCommonJSExports();
        this.createFunctionRules();
        this.createStatementRules();
        this.createTypescriptTypeRules();
    }

    @Override
    protected RecognizerBase<EJavaScriptParserStates> inAnyState() {
        return this.inState(EnumSet.complementOf(EnumSet.of(EJavaScriptParserStates.IN_TYPESCRIPT_TYPE, EJavaScriptParserStates.IN_LAMBDA_EXPRESSION, EJavaScriptParserStates.IN_SWITCH)).toArray(new EJavaScriptParserStates[0]));
    }

    private void createLambdaRules() {
        this.createLambda(this.inAnyState(), r -> r.createNode(EShallowEntityType.METHOD, "lambda"));
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.IN_LAMBDA_EXPRESSION}).subRecognizer(new JavaScriptSimpleStatementRecognizer(EShallowEntityType.STATEMENT, "lambda expression", true, true)).endNode();
    }

    private void createLambda(RecognizerBase<EJavaScriptParserStates> initialState, UnaryOperator<RecognizerBase<EJavaScriptParserStates>> nodeCreator) {
        this.completeLambda(initialState.repeated(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.DOT}).sequence(ALL_IDENTIFIERS), nodeCreator);
        this.completeLambda(initialState.optional(new ITokenMatcher[]{ETokenType.ASYNC}).skipNested(ETokenType.LT, ETokenType.GT).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN), nodeCreator);
    }

    private void completeLambda(RecognizerBase<EJavaScriptParserStates> ruleStart, UnaryOperator<RecognizerBase<EJavaScriptParserStates>> nodeCreator) {
        RecognizerBase<EJavaScriptParserStates> lambdaAlternativeWithReturnType = this.completeMethodTypeRecognizer(ruleStart.sequence(new ITokenMatcher[]{ETokenType.COLON}));
        ((RecognizerBase)nodeCreator.apply(lambdaAlternativeWithReturnType.sequence(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW, ETokenType.LBRACE}))).parseUntil(EJavaScriptParserStates.ANY).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        ((RecognizerBase)nodeCreator.apply(lambdaAlternativeWithReturnType.sequence(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW, ETokenType.LPAREN}).sequenceBefore(new ITokenMatcher[]{ETokenType.LBRACE}))).parseOnce(EJavaScriptParserStates.IN_LAMBDA_EXPRESSION).sequence(new ITokenMatcher[]{ETokenType.RPAREN}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        ((RecognizerBase)nodeCreator.apply(lambdaAlternativeWithReturnType.sequence(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW}))).parseOnce(EJavaScriptParserStates.IN_LAMBDA_EXPRESSION).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        RecognizerBase lambdaAlternativeWithCurrying = (RecognizerBase)nodeCreator.apply(ruleStart.repeatedSubRecognizer(this.createCurryingLambdaFunctionSubRecognizer()).sequenceBefore(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW, ETokenType.LBRACE}));
        lambdaAlternativeWithCurrying.sequence(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW, ETokenType.LBRACE}).parseUntil(EJavaScriptParserStates.ANY).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        lambdaAlternativeWithCurrying.sequence(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW, ETokenType.LPAREN, ETokenType.LBRACE}).parseUntil(EJavaScriptParserStates.ANY).sequence(new ITokenMatcher[]{ETokenType.RBRACE, ETokenType.RPAREN}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        RecognizerBase lambdaAlternative = (RecognizerBase)nodeCreator.apply(ruleStart.sequenceBefore(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW}));
        lambdaAlternative.sequence(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW, ETokenType.LBRACE}).parseUntil(EJavaScriptParserStates.ANY).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        lambdaAlternative.sequence(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW, ETokenType.LPAREN}).sequenceBefore(new ITokenMatcher[]{ETokenType.LBRACE}).parseOnce(EJavaScriptParserStates.IN_LAMBDA_EXPRESSION).sequence(new ITokenMatcher[]{ETokenType.RPAREN}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        lambdaAlternative.sequence(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW}).parseOnce(EJavaScriptParserStates.IN_LAMBDA_EXPRESSION).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private RecognizerBase<EJavaScriptParserStates> createCurryingLambdaFunctionSubRecognizer() {
        return this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW, ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN));
    }

    private void createMetaRules() {
        this.recognizeES6Imports();
        this.recognizeES6Exports();
        this.recognizeCommonJSImports();
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"goog"})}), ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"provide", "require", "inherits"})}), ETokenType.LPAREN}).skipAfter(new ITokenMatcher[]{ETokenType.RPAREN}).createNode(EShallowEntityType.META, INameResolver.ofRange(0, 2), INameResolver.ofRange(4, -2)).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"goog"})}), ETokenType.DOT, ETokenType.MODULE, ETokenType.LPAREN}).skipAfter(new ITokenMatcher[]{ETokenType.RPAREN}).createNode(EShallowEntityType.META, INameResolver.ofRange(0, 2), INameResolver.ofRange(4, -2)).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.VAR, ETokenType.CONST}), ETokenType.IDENTIFIER, ETokenType.EQ, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"goog"})}), ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"require"})}), ETokenType.LPAREN}).skipAfter(new ITokenMatcher[]{ETokenType.RPAREN}).createNode(EShallowEntityType.META, INameResolver.ofRange(3, 5), INameResolver.ofRange(7, -2)).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.NAMESPACE, ETokenType.LPAREN}).createNode(EShallowEntityType.META, "namespace", INameResolver.ofIndex(2)).skipAfter(new ITokenMatcher[]{ETokenType.RPAREN}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.recognizeTypeScriptImports();
        this.recognizeTypeScriptExports();
        RecognizerBase<EJavaScriptParserStates> decoratorStart = this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.AT, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.META, "decorator", INameResolver.ofRange(0, 1));
        decoratorStart.sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).endNode();
        decoratorStart.endNode();
    }

    private void recognizeCommonJSImports() {
        this.inAnyState().optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.VAR, ETokenType.CONST, ETokenType.LET})).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).skipAfter(new ITokenMatcher[]{ETokenType.RBRACE}).sequence(new ITokenMatcher[]{ETokenType.EQ}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"require"})}), ETokenType.LPAREN, ETokenType.STRING_LITERAL, ETokenType.RPAREN}).createNode(EShallowEntityType.META, "commonjs require", INameResolver.ofIndex(-2)).repeated(new ITokenMatcher[]{ETokenType.DOT, ETokenType.IDENTIFIER}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inAnyState().optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.VAR, ETokenType.CONST, ETokenType.LET})).optional(new ITokenMatcher[]{ETokenType.THIS, ETokenType.DOT}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optional(new ITokenMatcher[]{ETokenType.DOT, ETokenType.IDENTIFIER}).sequence(new ITokenMatcher[]{ETokenType.EQ}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"require"})}), ETokenType.LPAREN, ETokenType.STRING_LITERAL, ETokenType.RPAREN}).createNode(EShallowEntityType.META, "commonjs require", INameResolver.ofIndex(-2)).repeated(new ITokenMatcher[]{ETokenType.DOT, ETokenType.IDENTIFIER}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void recognizeCommonJSExports() {
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.MODULE, ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"exports"})})}).optional(new ITokenMatcher[]{ETokenType.DOT, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.STATEMENT, "nodejs module.exports", INameResolver.previousTokenText()).sequence(new ITokenMatcher[]{ETokenType.EQ}).parseOnce(EJavaScriptParserStates.ANY).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inAnyState().sequence(ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"exports"})})).sequence(new ITokenMatcher[]{ETokenType.DOT, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.STATEMENT, "commonjs exports", INameResolver.previousTokenText()).sequence(new ITokenMatcher[]{ETokenType.EQ}).parseOnce(EJavaScriptParserStates.ANY).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void recognizeTypeScriptImports() {
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.TRIPLE_SLASH_DIRECTIVE}).createNode(EShallowEntityType.META, "triple slash directive import", INameResolver.firstMatchedTokenText()).endNode();
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.IMPORT, ETokenType.IDENTIFIER, ETokenType.EQ, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"require"})}), ETokenType.LPAREN, ETokenType.STRING_LITERAL}).createNode(EShallowEntityType.META, "object export import", INameResolver.previousTokenText()).sequence(new ITokenMatcher[]{ETokenType.RPAREN}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.IMPORT, ETokenType.IDENTIFIER, ETokenType.EQ}).markStart().repeated(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.DOT})).createNode(EShallowEntityType.META, "alias import", INameResolver.ofRange(0, -1)).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void recognizeTypeScriptExports() {
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.EXPORT, ETokenType.EQ}).subRecognizer(new JavaScriptSimpleStatementRecognizer(EShallowEntityType.META, "object export", false), 1, 1).endNode();
    }

    private void recognizeES6Imports() {
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.IMPORT, ETokenType.LBRACE}).skipAfter(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.RBRACE, ETokenType.FROM, ETokenType.STRING_LITERAL}).createNode(EShallowEntityType.META, "import", INameResolver.concat(INameResolver.ofIndex(2), INameResolver.ofString(":#from#:"), INameResolver.previousTokenText())).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.IMPORT, ETokenType.MULT}).skipAfter(new ITokenMatcher[]{ETokenType.FROM}).skipAfter(new ITokenMatcher[]{ETokenType.STRING_LITERAL}).createNode(EShallowEntityType.META, "star import", INameResolver.previousTokenText()).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.IMPORT, ETokenType.IDENTIFIER, ETokenType.FROM, ETokenType.STRING_LITERAL}).createNode(EShallowEntityType.META, "default export import", INameResolver.previousTokenText()).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.IMPORT, ETokenType.STRING_LITERAL}).createNode(EShallowEntityType.META, "default export import", INameResolver.previousTokenText()).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void recognizeES6Exports() {
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.EXPORT, ETokenType.MULT}).optional(new ITokenMatcher[]{ETokenType.AS, ETokenType.IDENTIFIER}).sequence(new ITokenMatcher[]{ETokenType.FROM, ETokenType.STRING_LITERAL}).createNode(EShallowEntityType.META, "re-export", INameResolver.previousTokenText()).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        RecognizerBase exportStatementFirstPart = this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.EXPORT, ETokenType.LBRACE}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.DEFAULT})).skipAfter(new ITokenMatcher[]{ETokenType.RBRACE});
        exportStatementFirstPart.sequence(new ITokenMatcher[]{ETokenType.FROM, ETokenType.STRING_LITERAL}).createNode(EShallowEntityType.META, "re-export", INameResolver.previousTokenText()).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        exportStatementFirstPart.createNode(EShallowEntityType.META, "export", INameResolver.ofIndex(-2)).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createBaseJSRules() {
        RecognizerBase<EJavaScriptParserStates> baseJSTypeRecognizer = this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.TOP_LEVEL}).repeated(new ITokenMatcher[]{ALL_IDENTIFIERS, ETokenType.DOT}).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.uppercaseStart()}), ETokenType.EQ}).repeated(new ITokenMatcher[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.allLowercase()}), ETokenType.DOT}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.uppercaseStart()}), ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"extend"})}), ETokenType.LPAREN, ETokenType.LBRACE}).createNode(EShallowEntityType.TYPE, "class", INameResolver.firstMatchedTokenText()).parseUntil(EJavaScriptParserStates.BASE_JS_EXTEND).sequence(new ITokenMatcher[]{ETokenType.RBRACE});
        baseJSTypeRecognizer.sequence(new ITokenMatcher[]{ETokenType.RPAREN}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        baseJSTypeRecognizer.sequence(new ITokenMatcher[]{ETokenType.COMMA, ETokenType.LBRACE}).parseUntil(EJavaScriptParserStates.BASE_JS_EXTEND).sequence(new ITokenMatcher[]{ETokenType.RBRACE, ETokenType.RPAREN}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createClosureRecognizers() {
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.TOP_LEVEL}).repeated(new ITokenMatcher[]{ALL_IDENTIFIERS, ETokenType.DOT}).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.uppercaseStart()}), ETokenType.EQ, ETokenType.FUNCTION}).createNode(EShallowEntityType.METHOD, "constructor", INameResolver.ofRange(0, -3)).skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EJavaScriptParserStates.CLOSURE_CONSTRUCTOR).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        RecognizerBase attributeBeginning = this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.CLOSURE_CONSTRUCTOR}).sequence(new ITokenMatcher[]{ETokenType.THIS, ETokenType.DOT, ALL_IDENTIFIERS});
        attributeBeginning.sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.THIS, ETokenType.RBRACE, ETokenType.SEMICOLON})).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.ATTRIBUTE, "attribute", INameResolver.ofRange(0, 2)).endNode();
        attributeBeginning.sequence(new ITokenMatcher[]{ETokenType.EQ, ETokenType.FUNCTION}).createNode(EShallowEntityType.METHOD, "method", INameResolver.ofRange(0, 2)).skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EJavaScriptParserStates.ANY).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        RecognizerBase attributeAssignment = attributeBeginning.sequence(new ITokenMatcher[]{ETokenType.EQ}).createNode(EShallowEntityType.ATTRIBUTE, "attribute", INameResolver.ofRange(0, 2));
        attributeAssignment.sequenceBefore(new ITokenMatcher[]{ETokenType.LBRACE}).skipAfterWithNesting((ITokenMatcher)ETokenType.SEMICOLON, ETokenType.LBRACE, ETokenType.RBRACE).endNode();
        attributeAssignment.skipBeforeWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.THIS}), ETokenType.LPAREN, ETokenType.RPAREN).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createClosureES6Recognizers() {
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.TOP_LEVEL}).markStart().repeated(new ITokenMatcher[]{ALL_IDENTIFIERS, ETokenType.DOT}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.uppercaseStart()}), ETokenType.EQ, ETokenType.CLASS}).createNode(EShallowEntityType.TYPE, "class", INameResolver.ofRange(0, -3)).skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EJavaScriptParserStates.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createAngularRules() {
        this.inAnyState().optional(new ITokenMatcher[]{ETokenType.VAR, ALL_IDENTIFIERS, ETokenType.EQ}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"angular"})}), ETokenType.DOT, ETokenType.MODULE, ETokenType.LPAREN}).createNode(EShallowEntityType.META, "AngularJS module declaration").skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        RecognizerBase<EJavaScriptParserStates> angularMethodDeclarationStart = this.inAnyState().optional(ALL_IDENTIFIERS).markStart().sequence(new ITokenMatcher[]{ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"controller", "filter", "factory", "directive", "provider", "service", "decorator", "animation", "value", "component", "constant"})}), ETokenType.LPAREN});
        JavaScriptShallowParser.createAngularFunctionRule(angularMethodDeclarationStart.sequence(new ITokenMatcher[]{ETokenType.STRING_LITERAL, ETokenType.COMMA}), true);
        JavaScriptShallowParser.createAngularFunctionRule(angularMethodDeclarationStart.repeated(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.DOT}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.COMMA}), false);
        RecognizerBase<EJavaScriptParserStates> singleParameterMethodRecognizer = this.inAnyState().optional(ALL_IDENTIFIERS).markStart().sequence(new ITokenMatcher[]{ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"config", "run"})}), ETokenType.LPAREN});
        JavaScriptShallowParser.createAngularFunctionRule(singleParameterMethodRecognizer, false);
        RecognizerBase<EJavaScriptParserStates> angularConstantRecognizer = this.inAnyState().optional(ALL_IDENTIFIERS).markStart().sequence(new ITokenMatcher[]{ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"value", "component", "constant"})}), ETokenType.LPAREN, ETokenType.STRING_LITERAL, ETokenType.COMMA}).createNode(EShallowEntityType.METHOD, INameResolver.concat(INameResolver.ofString("AngularJS"), INameResolver.secondMatchedTokenText()), INameResolver.ofIndex(3)).skipBeforeWithNesting((ITokenMatcher)ETokenType.RPAREN, (List<ETokenType>)OPEN_DELIMITER, (List<ETokenType>)CLOSE_DELIMITER);
        angularConstantRecognizer.parseUntil(EJavaScriptParserStates.ANY).sequence(new ITokenMatcher[]{ETokenType.RPAREN}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private static void createAngularFunctionRule(RecognizerBase<EJavaScriptParserStates> angularMethodRecognizer, boolean includeFunctionName) {
        JavaScriptShallowParser.createAngularMethodNode(angularMethodRecognizer.optional(new ITokenMatcher[]{ETokenType.NEW}).repeated(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.DOT}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.STRING_LITERAL, ETokenType.IDENTIFIER, ETokenType.INTEGER_LITERAL})).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}), includeFunctionName).endNode();
        angularMethodRecognizer = angularMethodRecognizer.optional(new ITokenMatcher[]{ETokenType.LBRACK}).repeated(new ITokenMatcher[]{ETokenType.STRING_LITERAL, ETokenType.COMMA}).sequence(new ITokenMatcher[]{ETokenType.FUNCTION});
        JavaScriptShallowParser.createAngularMethodNode(angularMethodRecognizer, includeFunctionName).skipAfterWithNesting((ITokenMatcher)ETokenType.LBRACE, ETokenType.LPAREN, ETokenType.RPAREN).parseUntil(EJavaScriptParserStates.ANY).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).optional(new ITokenMatcher[]{ETokenType.COMMA}).optional(new ITokenMatcher[]{ETokenType.RBRACK}).sequence(new ITokenMatcher[]{ETokenType.RPAREN}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private static RecognizerBase<EJavaScriptParserStates> createAngularMethodNode(RecognizerBase<EJavaScriptParserStates> angularMethodRecognizer, boolean includeFunctionName) {
        if (includeFunctionName) {
            return angularMethodRecognizer.createNode(EShallowEntityType.METHOD, INameResolver.concat(INameResolver.ofString("AngularJS"), INameResolver.secondMatchedTokenText()), INameResolver.ofIndex(3));
        }
        return angularMethodRecognizer.createNode(EShallowEntityType.METHOD, INameResolver.concat(INameResolver.ofString("AngularJS"), INameResolver.secondMatchedTokenText()));
    }

    private void createModuleRules() {
        JavaScriptShallowParser.completeModuleRecognizer(this.inAnyState().ensureTopLevel().subRecognizer(new YuiCallRecognizer("add"), 1, 1).skipAfter(new ITokenMatcher[]{ETokenType.STRING_LITERAL}).createNode(EShallowEntityType.MODULE, "YUI module", INameResolver.previousTokenText()));
        JavaScriptShallowParser.completeModuleRecognizer(this.inAnyState().ensureTopLevel().subRecognizer(new YuiCallRecognizer("use"), 1, 1).createNode(EShallowEntityType.MODULE, "YUI code", INameResolver.previousTokenText()));
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.DECLARE, ETokenType.MODULE}).markStart().sequence(new ITokenMatcher[]{ETokenType.STRING_LITERAL}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.MODULE, "module", INameResolver.ofIndex(-2)).parseUntil(EJavaScriptParserStates.TOP_LEVEL).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.TOP_LEVEL}).repeated(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DECLARE, ETokenType.EXPORT})).markStart().optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.NAMESPACE, ETokenType.MODULE})).sequence(ALL_IDENTIFIERS).repeated(new ITokenMatcher[]{ETokenType.DOT, ALL_IDENTIFIERS}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.MODULE, INameResolver.firstMatchedTokenText(), INameResolver.ofRange(1, -2)).parseUntil(EJavaScriptParserStates.TOP_LEVEL).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private static void completeModuleRecognizer(RecognizerBase<EJavaScriptParserStates> recognizer) {
        recognizer.skipAfter(new ITokenMatcher[]{ETokenType.FUNCTION}).skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EJavaScriptParserStates.ANY).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createTypeRules() {
        RecognizerBase<EJavaScriptParserStates> typeRecognizer = this.inAnyState().repeated(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DECLARE, ETokenType.EXPORT, ETokenType.DEFAULT})).markStart();
        this.completeTypeAliasRecognizer(typeRecognizer.sequence(new ITokenMatcher[]{ETokenType.TYPE, ETokenType.IDENTIFIER}).subRecognizer(new GenericTypeAssigningEqualsRecognizer())).createNode(EShallowEntityType.TYPE, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).endNode();
        typeRecognizer.optional(new ITokenMatcher[]{ETokenType.ABSTRACT}).markStart().sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CLASS, ETokenType.INTERFACE}), ETokenType.IDENTIFIER}).createNode(EShallowEntityType.TYPE, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.LBRACE, ETokenType.LT, ETokenType.GT).parseUntil(EJavaScriptParserStates.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inAnyState().repeated(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DECLARE, ETokenType.EXPORT, ETokenType.CONST})).markStart().sequence(new ITokenMatcher[]{ETokenType.ENUM, ETokenType.IDENTIFIER, ETokenType.LBRACE}).createNode(EShallowEntityType.TYPE, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACE, ETokenType.LBRACE, ETokenType.RBRACE).endNode();
    }

    private RecognizerBase<EJavaScriptParserStates> completeTypeAliasRecognizer(RecognizerBase<EJavaScriptParserStates> recognizer) {
        return recognizer.repeated(new ITokenMatcher[]{ETokenType.KEYOF}).subRecognizer(this.createConditionalTypeRecognizer()).optional(new ITokenMatcher[]{ETokenType.SEMICOLON});
    }

    private void createTypescriptTypeRules() {
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.IN_TYPESCRIPT_TYPE}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COLON, ETokenType.EQ})).repeated(new ITokenMatcher[]{ETokenType.KEYOF}).subRecognizer(this.createConditionalTypeRecognizer());
    }

    private RecognizerBase<EJavaScriptParserStates> completeMethodTypeRecognizer(RecognizerBase<EJavaScriptParserStates> recognizer) {
        return recognizer.repeated(new ITokenMatcher[]{ETokenType.KEYOF}).subRecognizer(this.createPredicateAssertionTypeRecognizer());
    }

    private RecognizerBase<EJavaScriptParserStates> createPredicateAssertionTypeRecognizer() {
        RecognizerBase<EJavaScriptParserStates> standardTypeRecognizer = this.createConditionalTypeRecognizer();
        RecognizerBase predicateAssertionTypeRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.ASSERTS}).sequence(new ITokenMatcher[]{ALL_IDENTIFIERS, ETokenType.IS}).subRecognizer(standardTypeRecognizer));
        predicateAssertionTypeRecognizer.sequence(new ITokenMatcher[]{ETokenType.ASSERTS, ALL_IDENTIFIERS});
        RecognizerBase<EJavaScriptParserStates> combinedRecognizer = this.createRecognizer(start -> start.subRecognizer(predicateAssertionTypeRecognizer));
        combinedRecognizer.subRecognizer(standardTypeRecognizer);
        return combinedRecognizer;
    }

    private RecognizerBase<EJavaScriptParserStates> createConditionalTypeRecognizer() {
        RecognizerBase<EJavaScriptParserStates> nonConditionalTypeRecognizer = this.createLambdaTypeRecognizer();
        return this.createRecognizer(start -> start.subRecognizer(nonConditionalTypeRecognizer).optionalSubRecognizer(this.createRecognizer(start2 -> start2.sequence(new ITokenMatcher[]{ETokenType.EXTENDS}).subRecognizer(nonConditionalTypeRecognizer).sequence(new ITokenMatcher[]{ETokenType.QUESTION}).subRecognizer(start).sequence(new ITokenMatcher[]{ETokenType.COLON}).subRecognizer(start))));
    }

    private RecognizerBase<EJavaScriptParserStates> createLambdaTypeRecognizer() {
        RecognizerBase<EJavaScriptParserStates> arrayUnionIntersectionTypeRecognizer = this.createArrayUnionIntersectionTypeRecognizer();
        RecognizerBase lambdaStartRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.NEW}).skipNested(ETokenType.LT, ETokenType.GT).optional(new ITokenMatcher[]{ETokenType.QUESTION}).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).sequence(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW}));
        RecognizerBase lambdaRecognizer = this.createRecognizer(start -> start.subRecognizer(lambdaStartRecognizer).repeatedSubRecognizer(lambdaStartRecognizer).subRecognizer(arrayUnionIntersectionTypeRecognizer));
        RecognizerBase<EJavaScriptParserStates> combinedRecognizer = this.createRecognizer(start -> start.subRecognizer(lambdaRecognizer));
        combinedRecognizer.subRecognizer(arrayUnionIntersectionTypeRecognizer);
        return combinedRecognizer;
    }

    private RecognizerBase<EJavaScriptParserStates> createArrayUnionIntersectionTypeRecognizer() {
        RecognizerBase arrayRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.READONLY}).subRecognizer(this.createSimpleTypeRecognizer()).repeatedSubRecognizer(this.createRecognizer(sub -> sub.skipNested(ETokenType.LBRACK, ETokenType.RBRACK))));
        RecognizerBase innerUnionAndIntersectionRecognizer = this.createRecognizer(start -> start.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.OR, ETokenType.AND})).subRecognizer(arrayRecognizer));
        return this.createRecognizer(start -> start.optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.OR, ETokenType.AND})).subRecognizer(arrayRecognizer).repeatedSubRecognizer(innerUnionAndIntersectionRecognizer));
    }

    private RecognizerBase<EJavaScriptParserStates> createSimpleTypeRecognizer() {
        RecognizerBase typeImportRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.IMPORT, ETokenType.LPAREN}).skipAfter(new ITokenMatcher[]{ETokenType.RPAREN}).repeated(new ITokenMatcher[]{ETokenType.DOT, ETokenType.IDENTIFIER}).skipNested(ETokenType.LT, ETokenType.GT));
        RecognizerBase identifierRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.QUESTION}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).repeated(new ITokenMatcher[]{ETokenType.DOT, ETokenType.IDENTIFIER}).skipNested(ETokenType.LT, ETokenType.GT));
        RecognizerBase tupleRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LBRACK}).skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACK, ETokenType.LBRACK, ETokenType.RBRACK));
        RecognizerBase objectRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACE, ETokenType.LBRACE, ETokenType.RBRACE));
        RecognizerBase typeQueryRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.TYPEOF, ETokenType.IDENTIFIER}).repeated(new ITokenMatcher[]{ETokenType.DOT, ETokenType.IDENTIFIER}));
        RecognizerBase stringLiteralRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.STRING_LITERAL}));
        RecognizerBase intLiteralRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.MINUS}).sequence(new ITokenMatcher[]{ETokenType.INTEGER_LITERAL}));
        RecognizerBase templateLiteralRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.TEMPLATE_LITERAL}));
        stringLiteralRecognizer.sequence(new ITokenMatcher[]{ETokenType.BOOLEAN_LITERAL});
        HashSet keywordTypes = Sets.newHashSet((Object[])new ETokenType[]{ETokenType.ANY, ETokenType.VOID, ETokenType.NULL_LITERAL, ETokenType.UNDEFINED, ETokenType.UNKNOWN, ETokenType.OBJECT, ETokenType.THIS});
        RecognizerBase parenthesizedRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN));
        RecognizerBase<EJavaScriptParserStates> simpleTypeRecognizer = this.createRecognizer(start -> start.subRecognizer(identifierRecognizer));
        simpleTypeRecognizer.subRecognizer(typeImportRecognizer);
        simpleTypeRecognizer.subRecognizer(tupleRecognizer);
        simpleTypeRecognizer.subRecognizer(objectRecognizer);
        simpleTypeRecognizer.subRecognizer(typeQueryRecognizer);
        simpleTypeRecognizer.subRecognizer(stringLiteralRecognizer);
        simpleTypeRecognizer.subRecognizer(intLiteralRecognizer);
        simpleTypeRecognizer.subRecognizer(templateLiteralRecognizer);
        keywordTypes.stream().map(keyword -> this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{keyword}))).forEach(simpleTypeRecognizer::subRecognizer);
        simpleTypeRecognizer.subRecognizer(parenthesizedRecognizer);
        return simpleTypeRecognizer;
    }

    private void createExtJsTypeSupport() {
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"Ext"})}), ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"define"})}), ETokenType.LPAREN, ETokenType.STRING_LITERAL}).createNode(EShallowEntityType.TYPE, "class", INameResolver.ofIndex(4)).skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EJavaScriptParserStates.EXT_JS_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.EXT_JS_TYPE}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"config"})}), ETokenType.COLON, ETokenType.LBRACE}).createNode(EShallowEntityType.ATTRIBUTE, "config section").skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACE, ETokenType.LBRACE, ETokenType.RBRACE).optional(new ITokenMatcher[]{ETokenType.COMMA}).endNode();
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.EXT_JS_TYPE}).sequence(new ITokenMatcher[]{ETokenType.CONSTRUCTOR, ETokenType.COLON, ETokenType.FUNCTION}).createNode(EShallowEntityType.METHOD, "constructor").skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EJavaScriptParserStates.ANY).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).optional(new ITokenMatcher[]{ETokenType.COMMA}).endNode();
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.EXT_JS_TYPE}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"statics"})}), ETokenType.COLON, ETokenType.LBRACE}).createNode(EShallowEntityType.META, "statics").parseUntil(EJavaScriptParserStates.EXT_JS_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).optional(new ITokenMatcher[]{ETokenType.COMMA}).endNode();
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.EXT_JS_TYPE}).sequence(new ITokenMatcher[]{ALL_IDENTIFIERS.or(new ITokenMatcher[]{ETokenType.STRING_LITERAL}), ETokenType.COLON, ETokenType.ETokenClass.LITERAL}).optional(new ITokenMatcher[]{ETokenType.COMMA}).createNode(EShallowEntityType.ATTRIBUTE, "attribute", INameResolver.firstMatchedTokenText()).endNode();
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.EXT_JS_TYPE}).sequence(new ITokenMatcher[]{ALL_IDENTIFIERS.or(new ITokenMatcher[]{ETokenType.STRING_LITERAL}), ETokenType.COLON, ETokenType.LBRACE}).skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACE, ETokenType.LBRACE, ETokenType.RBRACE).optional(new ITokenMatcher[]{ETokenType.COMMA}).createNode(EShallowEntityType.ATTRIBUTE, "attribute", INameResolver.firstMatchedTokenText()).endNode();
    }

    private void createTypeMemberRules() {
        RecognizerBase constructorRecognizer = this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.IN_TYPE}).repeated(TYPESCRIPT_MODIFIERS).markStart().sequence(new ITokenMatcher[]{ETokenType.CONSTRUCTOR}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).createNode(EShallowEntityType.METHOD, "constructor", INameResolver.firstMatchedTokenText());
        constructorRecognizer.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EJavaScriptParserStates.ANY).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        constructorRecognizer.optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.createTypeMemberMethodRules();
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.IN_TYPE}).repeated(TYPESCRIPT_MODIFIERS).markStart().sequence(new ITokenMatcher[]{PROPERTY_NAME, ETokenType.COLON}).sequenceBefore(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.LT}).subRecognizer(new GenericTypeAssigningEqualsRecognizer(true)).subRecognizer(new JavaScriptSimpleStatementRecognizer(EShallowEntityType.ATTRIBUTE, "attribute", false), 1, 1).endNodeWithName(INameResolver.firstMatchedTokenText());
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.IN_TYPE}).repeated(TYPESCRIPT_MODIFIERS).markStart().sequenceBefore(PROPERTY_NAME, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EQ, ETokenType.COLON, ETokenType.QUESTION})).subRecognizer(new JavaScriptSimpleStatementRecognizer(EShallowEntityType.ATTRIBUTE, "attribute", true), 1, 1).endNode();
    }

    private void createTypeMemberMethodRules() {
        RecognizerBase genericDefinitionRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LT}).skipAfterWithNesting((ITokenMatcher)ETokenType.GT, ETokenType.LT, ETokenType.GT));
        RecognizerBase methodHeadRecognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.QUESTION}).optionalSubRecognizer(genericDefinitionRecognizer).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN));
        ITokenMatcher identifiersWithCatchAndFinally = ALL_IDENTIFIERS.or(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CATCH, ETokenType.FINALLY})});
        ITokenMatcher modifiersWithoutGetAndSet = TYPESCRIPT_MODIFIERS.except(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GET, ETokenType.SET})});
        RecognizerBase<EJavaScriptParserStates> methodAlternative = this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.IN_TYPE}).repeated(modifiersWithoutGetAndSet);
        RecognizerBase<EJavaScriptParserStates> methodWithUserDefinedNameAlternative = methodAlternative.preCondition(new MethodNameIsUserDefinedRecognizer()).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GET, ETokenType.SET})).markStart().repeatedAtLeastOnce(identifiersWithCatchAndFinally).subRecognizer(methodHeadRecognizer);
        RecognizerBase<EJavaScriptParserStates> methodWithSpecialIdentifierAsNameAlternative = methodAlternative.markStart().sequence(identifiersWithCatchAndFinally).subRecognizer(methodHeadRecognizer);
        RecognizerBase<EJavaScriptParserStates> methodAlternativeBrackedNamed = methodAlternative.optional(new ITokenMatcher[]{ETokenType.MULT}).sequence(new ITokenMatcher[]{ETokenType.LBRACK, ETokenType.IDENTIFIER, ETokenType.DOT}).markStart().sequence(new ITokenMatcher[]{ETokenType.ETokenClass.IDENTIFIER}).sequence(new ITokenMatcher[]{ETokenType.RBRACK}).subRecognizer(methodHeadRecognizer);
        RecognizerBase<EJavaScriptParserStates> methodWithNameFunction = methodAlternative.markStart().sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.FUNCTION, ETokenType.NEW})).subRecognizer(methodHeadRecognizer);
        this.continueParsingTypeMemberMethod(methodWithUserDefinedNameAlternative);
        this.continueParsingTypeMemberMethod(methodWithSpecialIdentifierAsNameAlternative);
        this.continueParsingTypeMemberMethod(methodAlternativeBrackedNamed);
        this.continueParsingTypeMemberMethod(methodWithNameFunction);
        RecognizerBase<EJavaScriptParserStates> methodWithNoName = methodAlternative.subRecognizer(methodHeadRecognizer);
        this.continueParsingCallSignature(methodWithNoName);
    }

    private void continueParsingTypeMemberMethod(RecognizerBase<EJavaScriptParserStates> methodRecognizer) {
        RecognizerBase<EJavaScriptParserStates> methodWithReturnType = methodRecognizer.sequence(new ITokenMatcher[]{ETokenType.COLON});
        this.completeRuleForTypeMemberMethod(this.completeMethodTypeRecognizer(methodWithReturnType));
        this.completeRuleForTypeMemberMethod(methodRecognizer);
    }

    private void completeRuleForTypeMemberMethod(RecognizerBase<EJavaScriptParserStates> recognizer) {
        recognizer.notPreCondition(this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LBRACE}))).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.COMMA})).createNode(EShallowEntityType.METHOD, "method declaration", INameResolver.firstMatchedTokenText()).endNode();
        RecognizerBase<EJavaScriptParserStates> methodWithBody = recognizer.preCondition(this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LBRACE}))).createNode(EShallowEntityType.METHOD, "method", INameResolver.firstMatchedTokenText());
        methodWithBody.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EJavaScriptParserStates.ANY).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.COMMA})).endNode();
    }

    private void continueParsingCallSignature(RecognizerBase<EJavaScriptParserStates> methodRecognizer) {
        RecognizerBase<EJavaScriptParserStates> methodWithReturnType = methodRecognizer.sequence(new ITokenMatcher[]{ETokenType.COLON});
        RecognizerBase<EJavaScriptParserStates> recognizer = this.completeMethodTypeRecognizer(methodWithReturnType);
        recognizer.notPreCondition(this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LBRACE}))).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.COMMA})).createNode(EShallowEntityType.METHOD, "method call signature", "").endNode();
    }

    private void createFunctionRules() {
        this.createAssignedFunctionRule();
        this.createNamedFunctionRule();
        this.createAttributeFunctionRule();
        this.createAnonymousAndDefaultFunctionRule();
        this.createGetterAndSetterFunctionRule();
        this.createFunctionalInterfaceRule();
    }

    private void createAssignedFunctionRule() {
        RecognizerBase<EJavaScriptParserStates> startRecognizer = this.inAnyState().repeated(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DECLARE, ETokenType.EXPORT})).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.VAR, ETokenType.CONST, ETokenType.LET})).repeated(new ITokenMatcher[]{IDENTIFIER_LIKE, ETokenType.DOT}).markStart().sequence(IDENTIFIER_LIKE).optional(new ITokenMatcher[]{ETokenType.COLON, IDENTIFIER_LIKE}).repeated(new ITokenMatcher[]{ETokenType.DOT, IDENTIFIER_LIKE}).sequence(new ITokenMatcher[]{ETokenType.EQ});
        startRecognizer.sequence(new ITokenMatcher[]{ETokenType.FUNCTION}).createNode(EShallowEntityType.METHOD, "assigned function", INameResolver.firstMatchedTokenText()).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EJavaScriptParserStates.ANY).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.createLambda(startRecognizer, r -> r.createNode(EShallowEntityType.METHOD, "assigned lambda", INameResolver.firstMatchedTokenText()));
    }

    private void createNamedFunctionRule() {
        RecognizerBase<EJavaScriptParserStates> functionWithoutType = this.inAnyState().repeated(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DECLARE, ETokenType.EXPORT})).optional(new ITokenMatcher[]{ETokenType.ASYNC}).sequence(new ITokenMatcher[]{ETokenType.FUNCTION}).optional(new ITokenMatcher[]{ETokenType.MULT}).markStart().sequence(ALL_IDENTIFIERS).skipNested(ETokenType.LT, ETokenType.GT).skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
        RecognizerBase<EJavaScriptParserStates> functionWithType = this.completeMethodTypeRecognizer(functionWithoutType.sequence(new ITokenMatcher[]{ETokenType.COLON}));
        functionWithoutType.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, "named function", INameResolver.firstMatchedTokenText()).parseUntil(EJavaScriptParserStates.ANY).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        functionWithoutType.optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.METHOD, "function declaration", INameResolver.firstMatchedTokenText()).endNode();
        functionWithType.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, "named function", INameResolver.firstMatchedTokenText()).parseUntil(EJavaScriptParserStates.ANY).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        functionWithType.optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.METHOD, "function declaration", INameResolver.firstMatchedTokenText()).endNode();
    }

    private void createGetterAndSetterFunctionRule() {
        RecognizerBase getterWithoutType = this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.IN_TYPE}).optional(TYPESCRIPT_ACCESS_MODIFIERS).sequence(new ITokenMatcher[]{ETokenType.GET}).markStart().sequence(ALL_IDENTIFIERS).skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
        RecognizerBase<EJavaScriptParserStates> getterWithType = this.completeMethodTypeRecognizer(getterWithoutType.sequence(new ITokenMatcher[]{ETokenType.COLON}));
        RecognizerBase setter = this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.IN_TYPE}).optional(TYPESCRIPT_ACCESS_MODIFIERS).sequence(new ITokenMatcher[]{ETokenType.SET}).markStart().sequence(ALL_IDENTIFIERS).skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
        getterWithoutType.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, "get", INameResolver.firstMatchedTokenText()).parseUntil(EJavaScriptParserStates.ANY).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        getterWithType.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, "get", INameResolver.firstMatchedTokenText()).parseUntil(EJavaScriptParserStates.ANY).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.COMMA})).endNode();
        setter.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, "set", INameResolver.firstMatchedTokenText()).parseUntil(EJavaScriptParserStates.ANY).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.COMMA})).endNode();
    }

    private void createAttributeFunctionRule() {
        this.inAnyState().sequence(new ITokenMatcher[]{PROPERTY_NAME, ETokenType.COLON, ETokenType.FUNCTION}).optional(new ITokenMatcher[]{ETokenType.MULT}).createNode(EShallowEntityType.METHOD, "attribute function", INameResolver.firstMatchedTokenText()).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EJavaScriptParserStates.ANY).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).optional(new ITokenMatcher[]{ETokenType.COMMA}).endNode();
        this.inAnyState().sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.STATIC, ETokenType.ASYNC, ETokenType.GET, ETokenType.SET})).markStart().sequence(new ITokenMatcher[]{ALL_IDENTIFIERS, ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, "attribute function", INameResolver.firstMatchedTokenText()).parseUntil(EJavaScriptParserStates.ANY).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).optional(new ITokenMatcher[]{ETokenType.COMMA}).endNode();
        this.inAnyState().markStart().sequence(new ITokenMatcher[]{ALL_IDENTIFIERS, ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, "attribute function", INameResolver.firstMatchedTokenText()).parseUntil(EJavaScriptParserStates.ANY).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).optional(new ITokenMatcher[]{ETokenType.COMMA}).endNode();
    }

    private void createAnonymousAndDefaultFunctionRule() {
        RecognizerBase<EJavaScriptParserStates> functionStart = this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.FUNCTION}).optional(new ITokenMatcher[]{ETokenType.MULT}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
        this.completeAnonymousAndDefaultFunctionRule(this.completeMethodTypeRecognizer(functionStart.sequence(new ITokenMatcher[]{ETokenType.COLON})));
        this.completeAnonymousAndDefaultFunctionRule(functionStart);
    }

    private void completeAnonymousAndDefaultFunctionRule(RecognizerBase<EJavaScriptParserStates> recognizer) {
        recognizer.notPreCondition(this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LBRACE}))).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.METHOD, "anonymous function").endNode();
        RecognizerBase<EJavaScriptParserStates> methodWithBody = recognizer.preCondition(this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LBRACE}))).createNode(EShallowEntityType.METHOD, "anonymous function");
        methodWithBody.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EJavaScriptParserStates.ANY).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createFunctionalInterfaceRule() {
        RecognizerBase<EJavaScriptParserStates> functionStart = this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.ANY}).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).sequence(new ITokenMatcher[]{ETokenType.COLON});
        this.completeMethodTypeRecognizer(functionStart).notPreCondition(this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW}))).createNode(EShallowEntityType.METHOD, "anonymous function").optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createStatementRules() {
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.STATEMENT, "empty statement").endNode();
        RecognizerBase baseJsAttribute = this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.BASE_JS_EXTEND}).sequence(new ITokenMatcher[]{ALL_IDENTIFIERS, ETokenType.COLON}).createNode(EShallowEntityType.ATTRIBUTE, "attribute", INameResolver.firstMatchedTokenText());
        baseJsAttribute.skipAfterWithNesting((ITokenMatcher)ETokenType.COMMA, ETokenType.LBRACE, ETokenType.RBRACE).endNode();
        baseJsAttribute.skipBeforeWithNesting((ITokenMatcher)ETokenType.RBRACE, ETokenType.LBRACE, ETokenType.RBRACE).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ALL_IDENTIFIERS, ETokenType.COLON}).createNode(EShallowEntityType.META, "label", INameResolver.firstMatchedTokenText()).endNode();
        this.createElseIfRule();
        this.createSimpleBlockRules();
        this.createSwitchCaseRules();
        this.createDoWhileRules();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.STATEMENT, "anonymous block").parseUntil(EJavaScriptParserStates.ANY).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inAnyState().sequenceBefore(new ITokenMatcher[]{ETokenType.EXPORT, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.VAR, ETokenType.CONST, ETokenType.LET})}).subRecognizer(new JavaScriptSimpleStatementRecognizer(EShallowEntityType.ATTRIBUTE, "exported variable", true), 1, 1).endNodeWithName(INameResolver.ofIndex(2));
        this.inAnyState().sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.VAR, ETokenType.CONST, ETokenType.LET})).subRecognizer(new JavaScriptSimpleStatementRecognizer(EShallowEntityType.STATEMENT, "local variable", true), 1, 1).endNodeWithName(INameResolver.secondMatchedTokenText());
        this.inAnyState().subRecognizer(new JavaScriptSimpleStatementRecognizer(EShallowEntityType.STATEMENT, "simple statement", true), 1, 1).endNode();
    }

    private void createElseIfRule() {
        RecognizerBase<EJavaScriptParserStates> elseIfAlternative = this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.ELSE, ETokenType.IF}).createNode(EShallowEntityType.STATEMENT, INameResolver.ofIndices(0, 1));
        this.blockRuleWithContinuationHelper(elseIfAlternative, (ITokenMatcher)ETokenType.ELSE, true, EJavaScriptParserStates.ANY);
    }

    private void createSimpleBlockRules() {
        this.createBlockRuleWithContinuation(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.WHILE, ETokenType.FOR, ETokenType.WITH}), null, true, EJavaScriptParserStates.ANY);
        this.createBlockRuleWithContinuation((ITokenMatcher)ETokenType.SWITCH, null, true, EJavaScriptParserStates.IN_SWITCH);
        this.createBlockRuleWithContinuation(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ELSE, ETokenType.FINALLY}), null, false, EJavaScriptParserStates.ANY);
        this.createBlockRuleWithContinuation((ITokenMatcher)ETokenType.IF, (ITokenMatcher)ETokenType.ELSE, true, EJavaScriptParserStates.ANY);
        this.createBlockRuleWithContinuation(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.TRY, ETokenType.CATCH}), ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CATCH, ETokenType.FINALLY}), true, EJavaScriptParserStates.ANY);
    }

    private void createDoWhileRules() {
        RecognizerBase<EJavaScriptParserStates> doWhileAlternative = this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.ANY}).sequence(new ITokenMatcher[]{ETokenType.DO}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText());
        doWhileAlternative.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EJavaScriptParserStates.ANY).sequence(new ITokenMatcher[]{ETokenType.RBRACE, ETokenType.WHILE}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, this.createFunctionRecognizer()).endNode();
        doWhileAlternative.parseOnce(EJavaScriptParserStates.ANY).sequence(new ITokenMatcher[]{ETokenType.WHILE}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, this.createFunctionRecognizer()).endNode();
    }

    private void createSwitchCaseRules() {
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.IN_SWITCH}).sequence(new ITokenMatcher[]{ETokenType.CASE, ITokenMatcher.anyOfClass((ETokenType.ETokenClass[])new ETokenType.ETokenClass[]{ETokenType.ETokenClass.LITERAL, ETokenType.ETokenClass.IDENTIFIER}), ETokenType.COLON}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).endNode();
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.IN_SWITCH}).sequence(new ITokenMatcher[]{ETokenType.CASE}).skipAfterWithNesting((ITokenMatcher)ETokenType.COLON, ETokenType.LPAREN, ETokenType.RPAREN).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).endNode();
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.IN_SWITCH}).sequence(new ITokenMatcher[]{ETokenType.DEFAULT, ETokenType.COLON}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).endNode();
        this.inState(new EJavaScriptParserStates[]{EJavaScriptParserStates.IN_SWITCH}).parseOnce(EJavaScriptParserStates.ANY);
    }

    private void createBlockRuleWithContinuation(ITokenMatcher startTokens, ITokenMatcher continuationTokens, boolean canBeFollowedByParentheses, EJavaScriptParserStates stateInsideBlock) {
        RecognizerBase<EJavaScriptParserStates> alternative = this.inAnyState().sequence(startTokens).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText());
        this.blockRuleWithContinuationHelper(alternative, continuationTokens, canBeFollowedByParentheses, stateInsideBlock);
    }

    private void blockRuleWithContinuationHelper(RecognizerBase<EJavaScriptParserStates> alternative, ITokenMatcher continuationTokens, boolean canBeFollowedByParentheses, EJavaScriptParserStates stateInsideBlock) {
        if (canBeFollowedByParentheses) {
            alternative = alternative.skipNested(ETokenType.LPAREN, ETokenType.RPAREN, this.createFunctionRecognizer());
        }
        this.endWithPossibleContinuation(alternative.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(stateInsideBlock).sequence(new ITokenMatcher[]{ETokenType.RBRACE}), continuationTokens);
        this.endWithPossibleContinuation(alternative.parseOnce(EJavaScriptParserStates.ANY), continuationTokens);
    }

    @Override
    protected boolean isFilteredToken(IToken token, IToken previousToken) {
        return super.isFilteredToken(token, previousToken) && token.getType() != ETokenType.TRIPLE_SLASH_DIRECTIVE;
    }

    private RecognizerBase<EJavaScriptParserStates> createFunctionRecognizer() {
        return this.createRecognizer(start -> start.sequenceBefore(new ITokenMatcher[]{ETokenType.FUNCTION}).parseOnce(EJavaScriptParserStates.ANY));
    }

    public static enum EJavaScriptParserStates {
        TOP_LEVEL,
        ANY,
        IN_TYPE,
        IN_LAMBDA_EXPRESSION,
        IN_SWITCH,
        CLOSURE_CONSTRUCTOR,
        BASE_JS_EXTEND,
        EXT_JS_TYPE,
        IN_TYPESCRIPT_TYPE;

    }
}

