/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class JavaAnalysisUtils {
    public static final Set<String> COMMON_MAP_IMPLEMENTATIONS = Set.of("java.util.HashMap", "java.util.LinkedHashMap", "java.util.TreeMap", "java.util.concurrent.ConcurrentHashMap", "java.util.concurrent.ConcurrentSkipListMap", "java.util.Hashtable", "java.util.WeakHashMap", "java.util.IdentityHashMap", "java.util.EnumMap", "com.google.common.collect.ImmutableMap", "com.google.common.collect.ImmutableSortedMap", "com.google.common.collect.HashBiMap", "com.google.common.collect.EnumHashBiMap", "com.google.common.collect.ClassToInstanceMap", "com.google.common.collect.MutableClassToInstanceMap", "com.google.common.collect.TreeBasedTable", "com.google.common.collect.HashBasedTable", "org.apache.commons.collections4.map.HashedMap", "org.apache.commons.collections4.map.LinkedMap", "org.apache.commons.collections4.map.LRUMap", "org.apache.commons.collections4.map.MultiValueMap", "org.apache.commons.collections4.map.ReferenceMap", "org.apache.commons.collections4.map.CaseInsensitiveMap", "org.apache.commons.collections4.bidimap.DualHashBidiMap", "org.apache.commons.collections4.bidimap.TreeBidiMap");
    public static final Set<String> COMMON_COLLECTION_IMPLEMENTATIONS = Set.of("java.util.ArrayList", "java.util.LinkedList", "java.util.HashSet", "java.util.Set", "java.util.LinkedHashSet", "java.util.TreeSet", "java.util.PriorityQueue", "java.util.ArrayDeque", "java.util.concurrent.CopyOnWriteArrayList", "java.util.concurrent.CopyOnWriteArraySet", "java.util.concurrent.ConcurrentLinkedQueue", "java.util.concurrent.ConcurrentLinkedDeque", "java.util.Vector", "java.util.Stack", "com.google.common.collect.ImmutableList", "com.google.common.collect.ImmutableSet", "com.google.common.collect.ImmutableSortedSet", "com.google.common.collect.ImmutableMultiset", "com.google.common.collect.HashMultiset", "com.google.common.collect.LinkedHashMultiset", "com.google.common.collect.TreeMultiset", "com.google.common.collect.Lists", "com.google.common.collect.Sets", "com.google.common.collect.Queues", "org.apache.commons.collections4.list.TreeList", "org.apache.commons.collections4.list.NodeCachingLinkedList", "org.apache.commons.collections4.list.CursorableLinkedList", "org.apache.commons.collections4.set.ListOrderedSet", "org.apache.commons.collections4.set.MapBackedSet", "org.apache.commons.collections4.bag.HashBag", "org.apache.commons.collections4.bag.TreeBag", "org.apache.commons.collections4.bag.SynchronizedBag", "org.apache.commons.collections4.bag.TransformedBag");
    public static final Set<String> COMMON_LIST_IMPLEMENTATIONS = Set.of("java.util.List", "java.util.AbstractList", "java.util.AbstractSequentialList", "java.util.ArrayList", "javax.management.AttributeList", "java.util.concurrency.CopyOnWriteArrayList", "java.util.LinkedList", "javax.management.relation.RoleList", "javax.management.relation.RoleUnresolvedList", "java.util.Stack", "java.util.Vector", "com.google.common.collect.ImmutableList", "com.google.common.collect.RegularImmutableList", "com.google.common.collect.SingletonImmutableList");
    private static final Pattern UNNECESSARY_BRACES_PATTERN = Pattern.compile("([\\s=<>(])\\(([\\w_]+)\\)");

    public static String removeUnnecessaryBraces(String code) {
        String previousCode;
        String currentCode = code.trim();
        do {
            if (!(currentCode = UNNECESSARY_BRACES_PATTERN.matcher(previousCode = currentCode).replaceAll("$1$2")).startsWith("(") || !currentCode.endsWith(")")) continue;
            currentCode = currentCode.substring(1, currentCode.length() - 1);
        } while (!currentCode.equals(previousCode));
        return currentCode;
    }

    private JavaAnalysisUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

