/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.ILanguageFeatureParser;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class MatlabLanguageFeatureParser
implements ILanguageFeatureParser {
    MatlabLanguageFeatureParser() {
    }

    public List<IToken> extractOutputParameterTokens(ShallowEntity method) {
        List<IToken> outputParameterTokens = MatlabLanguageFeatureParser.getOutputParameterTokens(method);
        ArrayList<IToken> result = new ArrayList<IToken>();
        for (int i = 0; i < outputParameterTokens.size(); i += 2) {
            result.add(outputParameterTokens.get(i));
        }
        return result;
    }

    private static List<IToken> getOutputParameterTokens(ShallowEntity method) {
        UnmodifiableList tokens = method.ownStartTokens();
        int equalIndex = TokenStreamUtils.firstTokenMatching((List<IToken>)tokens, (ITokenMatcher)ETokenType.EQ);
        if (equalIndex == -1) {
            return CollectionUtils.emptyList();
        }
        int startIndex = 1;
        int endIndex = equalIndex;
        if (((IToken)tokens.get(1)).getType() == ETokenType.LBRACK && ((IToken)tokens.get(equalIndex - 1)).getType() == ETokenType.RBRACK) {
            ++startIndex;
            --endIndex;
        }
        return tokens.subList(startIndex, endIndex);
    }

    public List<IToken> extractParentClassTokens(ShallowEntity classEntity) {
        IToken currentToken;
        UnmodifiableList ownStartTokens = classEntity.ownStartTokens();
        int inheritanceTokenIndex = TokenStreamUtils.firstTokenMatching((List<IToken>)ownStartTokens, (ITokenMatcher)ETokenType.LT);
        if (inheritanceTokenIndex == -1 || inheritanceTokenIndex == ownStartTokens.size() - 1) {
            return CollectionUtils.emptyList();
        }
        ArrayList<IToken> parentClassTokens = new ArrayList<IToken>();
        for (int i = inheritanceTokenIndex + 1; i < ownStartTokens.size() && ((currentToken = (IToken)ownStartTokens.get(i)).getType() == ETokenType.IDENTIFIER || currentToken.getType() == ETokenType.DOT); ++i) {
            parentClassTokens.add(currentToken);
        }
        return parentClassTokens;
    }

    public boolean containsInputParameter(ShallowEntity entity, String inputParameter) {
        List<List<IToken>> inputParameterTokenLists = MatlabLanguageFeatureParser.extractInputParameterTokens(entity);
        for (List<IToken> inputParameterTokenList : inputParameterTokenLists) {
            if (!TokenStreamTextUtils.concatTokenTexts(inputParameterTokenList).equals(inputParameter)) continue;
            return true;
        }
        return false;
    }

    private static List<List<IToken>> extractInputParameterTokens(ShallowEntity method) {
        UnmodifiableList ownStartTokens = method.ownStartTokens();
        List<IToken> inputParameterTokens = TokenStreamUtils.tokensBetweenWithNesting((List<IToken>)ownStartTokens, ETokenType.LPAREN, ETokenType.RPAREN);
        return TokenStreamUtils.split(inputParameterTokens, ETokenType.ARRAY_SEPARATOR);
    }

    public boolean hasEmptyOrMissingElseClause(List<IToken> tokens) {
        List<Integer> elseifIndices = TokenStreamUtils.allStartingIndicesOfTypeSequence(tokens, 0, tokens.size() - 1, ETokenType.ELSEIF);
        for (Integer index : elseifIndices) {
            int endToken;
            List<IToken> tokensStartingFromElseifIndex = tokens.subList(index, tokens.size() - 1);
            int elseToken = MatlabLanguageFeatureParser.findElseTokenAfterIfOrElseIf(tokensStartingFromElseifIndex, 0, endToken = TokenStreamUtils.findMatchingClosingToken(tokensStartingFromElseifIndex, 0, ETokenType.IF, ETokenType.END));
            if (elseToken == -1) {
                return true;
            }
            List<IToken> tokensBetweenElseAndEnd = tokensStartingFromElseifIndex.subList(elseToken + 1, endToken);
            if (!tokensBetweenElseAndEnd.isEmpty() && !tokensBetweenElseAndEnd.stream().allMatch(token -> token.getType() == ETokenType.EOL)) continue;
            return true;
        }
        return false;
    }

    private static int findElseTokenAfterIfOrElseIf(List<IToken> tokens, int startTokenIndex, int endTokenIndex) {
        int nesting = 1;
        for (int currentTokenIndex = startTokenIndex; currentTokenIndex < endTokenIndex; ++currentTokenIndex) {
            ETokenType tokenType = tokens.get(currentTokenIndex).getType();
            if (tokenType == ETokenType.IF) {
                ++nesting;
                continue;
            }
            if (tokenType == ETokenType.END) {
                --nesting;
                continue;
            }
            if (tokenType != ETokenType.ELSE || nesting != 1) continue;
            return currentTokenIndex;
        }
        return -1;
    }

    @Override
    public ELanguage getLanguage() {
        return ELanguage.MATLAB;
    }
}

