/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.clike;

import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.clike.EConditionalType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ConditionalBlock {
    protected EConditionalType blockType;
    protected List<IToken> condition;
    protected List<ShallowEntity> content;

    public ConditionalBlock(EConditionalType blockType, List<ShallowEntity> content) {
        this(blockType, new ArrayList<IToken>(), content);
    }

    public ConditionalBlock(EConditionalType blockType, List<IToken> condition, List<ShallowEntity> content) {
        this.setBlockType(blockType);
        this.setCondition(condition);
        this.setContent(content);
    }

    public EConditionalType getBlockType() {
        return this.blockType;
    }

    public void setBlockType(EConditionalType blockType) {
        this.blockType = blockType;
    }

    public List<IToken> getCondition() {
        return this.condition;
    }

    public void setCondition(List<IToken> condition) {
        this.condition = condition;
    }

    public List<ShallowEntity> getContent() {
        return this.content;
    }

    public void setContent(List<ShallowEntity> content) {
        this.content = content;
    }

    public boolean hasCondition() {
        return !this.condition.isEmpty();
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.blockType.toString() + " ");
        this.condition.forEach(token -> s.append(token.getText()));
        s.append("\r\n");
        return s.append(this.content.toString()).toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConditionalBlock)) {
            return false;
        }
        ConditionalBlock other = (ConditionalBlock)obj;
        return other.blockType.equals((Object)this.blockType) && other.condition.equals(this.condition) && other.content.equals(this.content);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getBlockType(), this.condition, this.content});
    }

    public boolean hasContent() {
        return !this.content.isEmpty();
    }
}

