/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.clike;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.clike.EConditionalType;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ConditionalBlockUtils {
    public static final UnmodifiableSet<EConditionalType> BLOCKS_WITH_CONDITION = CollectionUtils.asUnmodifiable(EnumSet.of(EConditionalType.IF, EConditionalType.ELSE_IF, EConditionalType.CASE));
    public static final UnmodifiableSet<EConditionalType> BLOCKS_WITHOUT_CONDITION = CollectionUtils.asUnmodifiable(EnumSet.of(EConditionalType.SWITCH, EConditionalType.ELSE, EConditionalType.DEFAULT));
    public static final UnmodifiableSet<EConditionalType> BLOCKS_CORRESPONDING_TO_IF = CollectionUtils.asUnmodifiable(EnumSet.of(EConditionalType.ELSE_IF, EConditionalType.ELSE));
    public static final UnmodifiableSet<EConditionalType> BLOCKS_CORRESPONDING_TO_SWITCH = CollectionUtils.asUnmodifiable(EnumSet.of(EConditionalType.CASE, EConditionalType.DEFAULT));
    public static final UnmodifiableSet<ETokenType> UNWANTED_TOKEN_TYPES_IN_CONDITION = CollectionUtils.asUnmodifiable(EnumSet.of(ETokenType.SWITCH, new ETokenType[]{ETokenType.LBRACE, ETokenType.IF, ETokenType.ELSEIF, ETokenType.CASE, ETokenType.DOUBLE_DOT, ETokenType.COLON}));

    public static EConditionalType getBlockTypeFromEntity(ShallowEntity entity) throws IllegalArgumentException {
        return ConditionalBlockUtils.getBlockTypeFromEntitySubtype(entity.getSubtype());
    }

    public static EConditionalType getBlockTypeFromEntitySubtype(String subtype) throws IllegalArgumentException {
        switch (subtype) {
            case "if": 
            case "if let": 
            case "if var": {
                return EConditionalType.IF;
            }
            case "elif": 
            case "elsif": 
            case "else if": 
            case "elseif": {
                return EConditionalType.ELSE_IF;
            }
            case "else": {
                return EConditionalType.ELSE;
            }
            case "switch": {
                return EConditionalType.SWITCH;
            }
            case "case": {
                return EConditionalType.CASE;
            }
            case "default": {
                return EConditionalType.DEFAULT;
            }
        }
        return null;
    }

    public static List<IToken> extractCondition(ShallowEntity entity) {
        List<IToken> tokens = ConditionalBlockUtils.getHeaderTokens(entity);
        return CollectionUtils.filter(tokens, token -> !UNWANTED_TOKEN_TYPES_IN_CONDITION.contains((Object)token.getType()) && token.getLineNumber() == ((IToken)tokens.get(0)).getLineNumber());
    }

    private static List<IToken> getHeaderTokens(ShallowEntity entity) {
        int endTokenIndex;
        int startTokenIndex = entity.getStartOffset();
        if (entity.getChildren().isEmpty()) {
            UnmodifiableList includedTokens = entity.includedTokens();
            endTokenIndex = ((IToken)includedTokens.get(includedTokens.size() - 1)).getOffset();
        } else {
            endTokenIndex = ((ShallowEntity)entity.getChildren().get(0)).getStartOffset();
        }
        return entity.includedTokens().stream().filter(token -> token.getOffset() > startTokenIndex && token.getEndOffset() < endTokenIndex).collect(Collectors.toList());
    }

    private ConditionalBlockUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

