/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.clike;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.typetracker.TypedVariable;
import eu.cqse.check.framework.util.JavaLanguageFeatureParser;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.SetMap;

public class HardcodedParameterEvaluator {
    private static final Set<String> KNOWN_STRING_RELATED_METHODS = Set.of("getBytes", "toString", "toUpperCase", "toLowerCase", "substring", "trim", "concat", "replace", "charAt", "length", "hashCode", "equals", "compareTo", "String", "valueOf", "stripTrailing", "stripLeading", "stripIndent", "intern", "translateEscapes", "StandardCharsets", "UTF_8", "UTF_16", "ISO_8859_1", "US_ASCII", "toCharArray", "Base64", "encode", "TextCodec", "BASE64", "getEncoder", "defaultCharset", "Charset", "subSequence", "Locale", "ROOT", "replaceAll");
    private static final Set<String> IMMUTABLE_TYPES = Set.of("String", "int", "float", "double", "char", "long", "short", "byte");
    private final ShallowEntity statement;
    private final List<IToken> expressionToCheck;
    private final ITypeResolution typeResolution;
    private @Nullable SetMap<String, ShallowEntity> fieldsByTypeName = null;

    public HardcodedParameterEvaluator(ShallowEntity statement, List<IToken> expression, ITypeResolution typeResolution) {
        this.statement = statement;
        this.expressionToCheck = expression;
        this.typeResolution = typeResolution;
    }

    public boolean isHardcodedExpression() {
        if (this.expressionToCheck.isEmpty()) {
            return false;
        }
        List<IToken> unknownIdentifiersInExpression = HardcodedParameterEvaluator.getUniqueIdentifiersWithoutStringMethods(this.expressionToCheck);
        if (unknownIdentifiersInExpression.isEmpty()) {
            return HardcodedParameterEvaluator.isHardcodedAndNotEmpty(this.expressionToCheck);
        }
        return unknownIdentifiersInExpression.stream().allMatch(this::isHardcodedIdentifier);
    }

    private boolean isHardcodedIdentifier(IToken identifier) {
        Optional<FieldDefinition> fieldDefinition;
        ScopedTypeLookup typeLookup = this.typeResolution.getTypeLookup(this.statement);
        List<VariableAssignment> valueAssignments = HardcodedParameterEvaluator.resolveLocalVariableRecursive(this.statement, identifier.getText(), null);
        if (!valueAssignments.isEmpty()) {
            VariableAssignment mostRecentValue = valueAssignments.getLast();
            if (mostRecentValue.variableDeclaration().getType() == EShallowEntityType.METHOD) {
                return false;
            }
            if (HardcodedParameterEvaluator.isHardcodedAndNotEmpty(mostRecentValue.definition) && !HardcodedParameterEvaluator.couldBeAlteredInPreviousMethodCall(identifier.getText(), typeLookup.getTypeInfo(identifier.getText()), mostRecentValue, this.statement)) {
                return true;
            }
        }
        if ((fieldDefinition = this.resolveFieldReferenceRecursive(this.statement, this.expressionToCheck.getFirst().getText())).isPresent() && JavaLanguageFeatureParser.isFinal(fieldDefinition.get().field())) {
            return HardcodedParameterEvaluator.isHardcodedAndNotEmpty(fieldDefinition.get().definition);
        }
        return HardcodedParameterEvaluator.isHardcodedAndNotEmpty(this.expressionToCheck);
    }

    private static boolean couldBeAlteredInPreviousMethodCall(String variableName, @Nullable TypedVariable typeInfo, VariableAssignment mostRecentAssignment, ShallowEntity untilStatement) {
        if (typeInfo != null && IMMUTABLE_TYPES.contains(typeInfo.getTypeName())) {
            return false;
        }
        ShallowEntity sibling = ShallowEntityTraversalUtils.getSubsequentSiblingEntity((ShallowEntity)mostRecentAssignment.variableDeclaration);
        while (sibling != null && sibling.getStartLine() < untilStatement.getStartLine()) {
            if (sibling.getType() != EShallowEntityType.STATEMENT) continue;
            List relevantTokens = new ArrayList(sibling.ownStartTokens());
            int eqIndex = CollectionUtils.indexOfFirstMatch(relevantTokens, token -> token.getType() == ETokenType.EQ);
            if (eqIndex > -1) {
                relevantTokens = relevantTokens.subList(eqIndex + 1, relevantTokens.size());
            }
            for (int i = 0; i < relevantTokens.size(); ++i) {
                IToken token2 = (IToken)relevantTokens.get(i);
                if (!token2.getText().equals(variableName) || i <= 1 || i >= relevantTokens.size() - 1 || KNOWN_STRING_RELATED_METHODS.contains(((IToken)relevantTokens.get(i - 2)).getText()) || ((IToken)relevantTokens.get(i + 1)).getType() == ETokenType.DOT) continue;
                return true;
            }
            sibling = ShallowEntityTraversalUtils.getSubsequentSiblingEntity((ShallowEntity)sibling);
        }
        return false;
    }

    private static boolean isHardcodedAndNotEmpty(List<IToken> definitionTokens) {
        if (definitionTokens.isEmpty()) {
            return false;
        }
        if (HardcodedParameterEvaluator.isEmptyOrNullLiteral(definitionTokens)) {
            return false;
        }
        if (Set.of("new String ( )", "new char [ 0 ]", "new byte [ 0 ]").contains(TokenStreamTextUtils.concatTokenTexts(definitionTokens, " "))) {
            return false;
        }
        if (definitionTokens.stream().filter(token -> !Set.of("Byte", "String", "Integer", "Float", "Double").contains(token.getText())).noneMatch(token -> token.getType().isIdentifier())) {
            return true;
        }
        if (definitionTokens.stream().allMatch(token -> token.getType() == ETokenType.STRING_LITERAL || token.getType() == ETokenType.PLUS || token.getText().equals("concat"))) {
            return true;
        }
        return HardcodedParameterEvaluator.getUniqueIdentifiersWithoutStringMethods(definitionTokens).isEmpty();
    }

    private static boolean isEmptyOrNullLiteral(List<IToken> definitionTokens) {
        if (definitionTokens.size() == 1 && ETokenType.NULL_LITERAL == definitionTokens.getFirst().getType()) {
            return true;
        }
        return definitionTokens.getFirst().getText().equals("\"\"") && (definitionTokens.size() == 1 || ETokenType.DOT.matches(definitionTokens.get(1)));
    }

    private static List<VariableAssignment> resolveLocalVariableRecursive(ShallowEntity statement, String variableName, @Nullable ShallowEntity method) {
        int depthOfTargetLine;
        if (method == null) {
            Optional methodSurroundingAndDepth = ShallowEntityTraversalUtils.findParentEntityAndCountDepth((ShallowEntity)statement, parent -> parent.getType() == EShallowEntityType.METHOD);
            if (methodSurroundingAndDepth.isEmpty()) {
                return Collections.emptyList();
            }
            method = (ShallowEntity)((Pair)methodSurroundingAndDepth.get()).getFirst();
            depthOfTargetLine = (Integer)((Pair)methodSurroundingAndDepth.get()).getSecond();
        } else {
            depthOfTargetLine = 1;
        }
        TokenPattern declarationPattern = new TokenPattern().notPrecededBy(ETokenType.DOT).tokenText(variableName).sequence(ETokenType.EQ).group(0);
        ArrayList<Pair<ShallowEntity, Integer>> childrenWithDepth = new ArrayList<Pair<ShallowEntity, Integer>>();
        HardcodedParameterEvaluator.findChildrenWithDepth(method, 0, statement.getStartOffset(), childEntity -> childEntity.getType() == EShallowEntityType.STATEMENT, childrenWithDepth);
        List<AssignmentInfo> variableDeclarations = childrenWithDepth.stream().map(statementBeforeUse -> new AssignmentInfo((ShallowEntity)statementBeforeUse.getFirst(), declarationPattern.findFirstMatch((List<IToken>)((ShallowEntity)statementBeforeUse.getFirst()).ownStartTokens()), (Integer)statementBeforeUse.getSecond())).filter(pair -> pair.match() != null).toList();
        if (variableDeclarations.stream().anyMatch(assignment -> assignment.depthInsideMethod > depthOfTargetLine)) {
            return Collections.emptyList();
        }
        if (!variableDeclarations.isEmpty()) {
            ShallowEntity finalMethod = method;
            return variableDeclarations.stream().map(declaration -> {
                List<IToken> definitionPart = TokenStreamUtils.tokensBetween((List<IToken>)declaration.statement().ownStartTokens(), ETokenType.EQ, ETokenType.SEMICOLON);
                Optional<String> deferredVariable = HardcodedParameterEvaluator.getDeferredVariableFromDefinition(definitionPart);
                if (deferredVariable.isPresent()) {
                    return HardcodedParameterEvaluator.resolveLocalVariableRecursive(declaration.statement(), deferredVariable.get(), finalMethod);
                }
                return List.of(new VariableAssignment(declaration.statement(), definitionPart));
            }).flatMap(Collection::stream).toList();
        }
        Optional<List> methodParameterDefinition = LanguageFeatureParser.JAVA.getMethodArguments(method, 0).stream().filter(argument -> ((IToken)argument.getLast()).getText().equals(variableName)).findFirst();
        if (methodParameterDefinition.isEmpty()) {
            return Collections.emptyList();
        }
        return List.of(new VariableAssignment(method, methodParameterDefinition.get()));
    }

    private static void findChildrenWithDepth(ShallowEntity current, int depth, int maxOffset, Predicate<ShallowEntity> predicate, List<Pair<ShallowEntity, Integer>> result) {
        if (current.getStartOffset() >= maxOffset) {
            return;
        }
        if (predicate.test(current)) {
            result.add((Pair<ShallowEntity, Integer>)Pair.createPair((Object)current, (Object)depth));
        }
        for (ShallowEntity child : current.getChildren()) {
            HardcodedParameterEvaluator.findChildrenWithDepth(child, depth + 1, maxOffset, predicate, result);
        }
    }

    static Optional<String> getDeferredVariableFromDefinition(List<IToken> definitionPart) {
        if (definitionPart.isEmpty()) {
            return Optional.empty();
        }
        if (definitionPart.getFirst().getType().isLiteral()) {
            return Optional.empty();
        }
        if (definitionPart.size() == 1 && definitionPart.getFirst().getType() == ETokenType.IDENTIFIER) {
            return Optional.of(definitionPart.getFirst().getText());
        }
        List<IToken> identifiersInCleanedAssignment = HardcodedParameterEvaluator.getUniqueIdentifiersWithoutStringMethods(definitionPart);
        if (identifiersInCleanedAssignment.size() == 1) {
            return Optional.of(identifiersInCleanedAssignment.getFirst().getText());
        }
        return Optional.empty();
    }

    private static List<IToken> getUniqueIdentifiersWithoutStringMethods(List<IToken> definitionPart) {
        return definitionPart.stream().filter(token -> !KNOWN_STRING_RELATED_METHODS.contains(token.getText())).filter(token -> token.getType() == ETokenType.IDENTIFIER).distinct().collect(Collectors.toMap(IToken::getText, token -> token, (existing, replacement) -> existing)).values().stream().toList();
    }

    private Optional<FieldDefinition> resolveFieldReferenceRecursive(ShallowEntity codeLocation, String fieldName) {
        Map<String, ShallowEntity> fieldDefinitionsByFieldName = this.getFieldDeclarationsOfSurroundingType(codeLocation);
        ShallowEntity fieldEntity = fieldDefinitionsByFieldName.get(fieldName);
        if (fieldEntity != null && JavaLanguageFeatureParser.isFinal(fieldEntity)) {
            List<IToken> fieldDefinitionTokens = JavaLanguageFeatureParser.getFieldDeclarationTokens(fieldEntity);
            Optional<String> deferredFieldValue = HardcodedParameterEvaluator.getDeferredVariableFromDefinition(fieldDefinitionTokens);
            if (deferredFieldValue.isPresent() && !deferredFieldValue.get().equals(fieldName)) {
                return this.resolveFieldReferenceRecursive(codeLocation, deferredFieldValue.get());
            }
            return Optional.of(new FieldDefinition(fieldEntity, fieldDefinitionTokens));
        }
        return Optional.empty();
    }

    private Map<String, ShallowEntity> getFieldDeclarationsOfSurroundingType(ShallowEntity entity) {
        Optional surroundingType = ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)entity, parent -> parent.getType() == EShallowEntityType.TYPE);
        if (surroundingType.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, ShallowEntity> attributeByName = new HashMap<String, ShallowEntity>();
        String typeName = ((ShallowEntity)surroundingType.get()).getName();
        Set attributes = this.fieldsByTypeName != null && this.fieldsByTypeName.containsCollection((Object)typeName) ? (Set)this.fieldsByTypeName.getCollectionOrEmpty((Object)typeName) : new HashSet(ShallowEntityTraversalUtils.listEntitiesOfTypeNonRecursive(List.of((ShallowEntity)surroundingType.get()), (EShallowEntityType)EShallowEntityType.ATTRIBUTE));
        for (ShallowEntity attribute : attributes) {
            attributeByName.put(attribute.getName(), attribute);
            if (this.fieldsByTypeName == null) {
                this.fieldsByTypeName = new SetMap();
            }
            this.fieldsByTypeName.add((Object)typeName, (Object)attribute);
        }
        return attributeByName;
    }

    private record VariableAssignment(ShallowEntity variableDeclaration, List<IToken> definition) {
    }

    private record FieldDefinition(ShallowEntity field, List<IToken> definition) {
    }

    private record AssignmentInfo(ShallowEntity statement, TokenPatternMatch match, int depthInsideMethod) {
    }
}

