/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.tokens;

import eu.cqse.check.framework.util.tokens.TokenPatternBase;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.framework.util.tokens.TokenStream;
import java.util.Arrays;

public class SkipPattern
extends TokenPatternBase {
    private final TokenPatternBase[] matchers;
    private final boolean matchesEndOfStream;

    public SkipPattern(TokenPatternBase[] matchers, boolean matchesEndOfStream) {
        this.matchers = matchers;
        this.matchesEndOfStream = matchesEndOfStream;
    }

    @Override
    protected TokenPatternMatch matchesLocally(TokenStream stream) {
        while (!stream.isExhausted()) {
            for (TokenPatternBase matcher : this.matchers) {
                int beforeMatch = stream.getPosition();
                TokenPatternMatch match = matcher.matches(stream);
                stream.setPosition(beforeMatch);
                if (match == null) continue;
                return SkipPattern.createMatch(stream);
            }
            stream.next();
        }
        return this.matchesEndOfStream ? SkipPattern.createMatch(stream) : null;
    }

    public String toString() {
        return "Skip " + Arrays.toString(this.matchers);
    }
}

