/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.config.provider;

import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.core.config.ConfigurationProperties;

public class PropertiesAdapter
implements ConfigurationProperties {
    @Nonnull
    private Properties properties;

    public PropertiesAdapter(@Nonnull Properties wrappedProperties) {
        this.properties = (Properties)Constraint.isNotNull((Object)wrappedProperties, (String)"Wrapped Properties was null");
    }

    @Override
    @Nullable
    public String getProperty(@Nonnull String key) {
        Constraint.isNotNull((Object)key, (String)"Key was null");
        return this.properties.getProperty(key);
    }

    @Override
    @Nonnull
    public String getProperty(@Nonnull String key, @Nonnull String defaultValue) {
        Constraint.isNotNull((Object)key, (String)"Key was null");
        Constraint.isNotNull((Object)defaultValue, (String)"Default value was null");
        String value = this.properties.getProperty(key, defaultValue);
        assert (value != null);
        return value;
    }
}

