/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.ui;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreator;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.config.ServerConfiguration;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.ui.TeamscaleStarter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectIdBase;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.config.DatabaseConfiguration;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.sharded.IShardingStrategy;
import org.conqat.engine.persistence.store.sharded.ShardingStorageSystemProvider;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class StorageShardingSupport {
    private static final String SHARD_ID_MAP_PREFIX = "shard-id-mapping:";
    private static final String SEPARATOR = "#!#";
    private final ServerConfiguration serverConfiguration;
    private final DatabaseConfiguration databaseConfiguration;
    private MetaIndex globalMetaIndex;
    private final Map<String, List<String>> internalToPublicProjectIdCache = new HashMap<String, List<String>>();

    public StorageShardingSupport(ServerConfiguration serverConfiguration, DatabaseConfiguration databaseConfiguration) {
        this.serverConfiguration = serverConfiguration;
        this.databaseConfiguration = databaseConfiguration;
    }

    public void setGlobalMetaIndex(MetaIndex globalMetaIndex) {
        this.globalMetaIndex = globalMetaIndex;
    }

    public IStorageSystemProvider createStorageSystemProvider(String shardingDescription) throws StorageException {
        File originalStorageDirectory = this.databaseConfiguration.getStorageDirectory();
        IShardingStrategy shardingStrategy = IShardingStrategy.parse((String)shardingDescription, (File)originalStorageDirectory, this::resolvePublicProjectIdsForSharding);
        ProjectCreator.registerCreationListener(this::projectAboutToBeCreated);
        ArrayList<IStorageSystemProvider> providers = new ArrayList<IStorageSystemProvider>();
        for (int i = 0; i < shardingStrategy.getShardCount(); ++i) {
            providers.add(TeamscaleStarter.createSingleStorageSystemProvider(this.serverConfiguration, this.databaseConfiguration.withStorageDirectory(shardingStrategy.getShardDirectory(i))));
        }
        return new ShardingStorageSystemProvider(shardingStrategy, providers);
    }

    private List<String> resolvePublicProjectIdsForSharding(String storageSystemName) throws StorageException {
        if ("__global__".equals(storageSystemName)) {
            return List.of("__global__");
        }
        storageSystemName = StringUtils.stripPrefix((String)storageSystemName, (String)"re_analyze_temp_partition_");
        Map<String, List<String>> map = this.internalToPublicProjectIdCache;
        synchronized (map) {
            List<String> mapped = this.internalToPublicProjectIdCache.get(storageSystemName);
            if (mapped != null) {
                return mapped;
            }
            Optional storedMapping = this.globalMetaIndex.getStringValue(StorageShardingSupport.makeStorageKey(new InternalProjectId(storageSystemName)));
            if (storedMapping.isPresent()) {
                List<String> storedProjectIds = StorageShardingSupport.splitStorageValue((String)storedMapping.get());
                this.internalToPublicProjectIdCache.put(storageSystemName, storedProjectIds);
                return storedProjectIds;
            }
            throw new StorageException("Unknown internal project id: " + storageSystemName + ". Failing hard!");
        }
    }

    public void connectToStorageLayer(IndexLayer indexLayer) throws StorageException {
        ProjectIndex projectIndex = indexLayer.openProjectIndex();
        for (ProjectInfo projectInfo : projectIndex.getAllProjectInfos()) {
            if (!this.globalMetaIndex.getStringValue(StorageShardingSupport.makeStorageKey(projectInfo.getInternalId())).isEmpty()) continue;
            this.globalMetaIndex.setStringValue(StorageShardingSupport.makeStorageKey(projectInfo.getInternalId()), StorageShardingSupport.makeStorageValue(List.of(projectInfo.getInternalId().toString())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void projectAboutToBeCreated(ProjectConfiguration projectConfiguration) throws ProjectConfigurationException {
        Map<String, List<String>> map = this.internalToPublicProjectIdCache;
        synchronized (map) {
            InternalProjectId internalId = projectConfiguration.getInternalId();
            if (this.internalToPublicProjectIdCache.containsKey(internalId.toString())) {
                return;
            }
            List publicIds = CollectionUtils.map((Collection)projectConfiguration.getPublicIds(), ProjectIdBase::toString);
            this.internalToPublicProjectIdCache.put(internalId.toString(), publicIds);
            try {
                this.globalMetaIndex.setStringValue(StorageShardingSupport.makeStorageKey(internalId), StorageShardingSupport.makeStorageValue(publicIds));
            }
            catch (StorageException e) {
                throw new ProjectConfigurationException("Failed to store sharding mapping: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static String makeStorageKey(InternalProjectId internalId) {
        return SHARD_ID_MAP_PREFIX + String.valueOf(internalId);
    }

    private static String makeStorageValue(List<String> ids) {
        return StringUtils.concat(ids, (String)SEPARATOR);
    }

    private static List<String> splitStorageValue(String value) {
        return List.of(value.split(SEPARATOR));
    }
}

