/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.ui;

import com.teamscale.ui.TrustStoreValidationException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class TrustStoreValidator {
    static final String JAVAX_NET_SSL_TRUST_STORE = "javax.net.ssl.trustStore";
    static final String JAVAX_NET_SSL_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private static final String JAVAX_NET_SSL_TRUST_STORE_TYPE = "javax.net.ssl.trustStoreType";
    private static final String JVM_DEFAULT_TRUST_STORE_PASSWORD = "changeit";

    private TrustStoreValidator() {
    }

    private static void isTrustStorePathValid() throws TrustStoreValidationException {
        String customTrustStorePath = System.getProperty(JAVAX_NET_SSL_TRUST_STORE);
        if (customTrustStorePath == null) {
            return;
        }
        if (!Files.exists(Paths.get(customTrustStorePath, new String[0]), new LinkOption[0])) {
            throw new TrustStoreValidationException("Cannot find trust store at " + customTrustStorePath + ". Please check the value provided with the javax.net.ssl.trustStore system property.");
        }
    }

    private static void isTrustStorePasswordValid() throws TrustStoreValidationException {
        String customTrustStorePath = System.getProperty(JAVAX_NET_SSL_TRUST_STORE);
        String customTrustStorePassword = System.getProperty(JAVAX_NET_SSL_TRUST_STORE_PASSWORD);
        String customTrustStoreType = System.getProperty(JAVAX_NET_SSL_TRUST_STORE_TYPE);
        if (customTrustStorePath == null) {
            return;
        }
        String passwordOrDefault = customTrustStorePassword;
        if (customTrustStorePassword == null) {
            passwordOrDefault = JVM_DEFAULT_TRUST_STORE_PASSWORD;
        }
        if (customTrustStoreType == null) {
            customTrustStoreType = KeyStore.getDefaultType();
        }
        try (FileInputStream customTrustStoreFileInputStream2 = new FileInputStream(customTrustStorePath);){
            KeyStore customTrustStore = KeyStore.getInstance(customTrustStoreType);
            customTrustStore.load(customTrustStoreFileInputStream2, passwordOrDefault.toCharArray());
        }
        catch (FileNotFoundException | KeyStoreException | NoSuchAlgorithmException | CertificateException customTrustStoreFileInputStream2) {
        }
        catch (IOException ioException) {
            if (customTrustStorePassword == null) {
                throw new TrustStoreValidationException("Default password 'changeit' does not work for trust store at " + customTrustStorePath + ". Please provide the password with the javax.net.ssl.trustStorePassword system property.", ioException);
            }
            throw new TrustStoreValidationException("Wrong password given for trust store at " + customTrustStorePath + ". Please check the password provided with the javax.net.ssl.trustStorePassword system property.", ioException);
        }
    }

    public static void validateTrustStoreConfiguration() throws TrustStoreValidationException {
        TrustStoreValidator.isTrustStorePathValid();
        TrustStoreValidator.isTrustStorePasswordValid();
    }
}

