/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.ai;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.ai.AiEngineProviderOptionBase;
import com.teamscale.core.ai.AiEngineUsageIndex;
import com.teamscale.core.ai.IAiEngineProvider;
import com.teamscale.core.ai.ILlmCompleter;
import com.teamscale.core.ai.LlmPrompt;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.server.ServerOptionIndex;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

public class DefaultAiEngineProvider
implements IAiEngineProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long USAGE_PERSIST_PERIOD_MILLIS = Duration.ofSeconds(5L).toMillis();
    private final ServerOptionIndex serverOptionIndex;
    private final AiEngineUsageIndex usageIndex;
    private final List<IAiEngineProvider.AiEngineDescription> availableAiEngines = new ArrayList<IAiEngineProvider.AiEngineDescription>();
    private final Map<String, ILlmCompleter> completerByName = new HashMap<String, ILlmCompleter>();
    private final Map<String, Long> usage = new HashMap<String, Long>();

    public DefaultAiEngineProvider(ServerOptionIndex serverOptionIndex, AiEngineUsageIndex usageIndex, IMessageBroker messageBroker) {
        this.serverOptionIndex = serverOptionIndex;
        this.usageIndex = usageIndex;
        this.refresh();
        new Timer("LLM Usage Sync Timer", true).schedule(new TimerTask(){

            @Override
            public void run() {
                DefaultAiEngineProvider.this.persistUsageStatistics();
            }
        }, USAGE_PERSIST_PERIOD_MILLIS, USAGE_PERSIST_PERIOD_MILLIS);
        messageBroker.registerListener("ai-options-changed", _unused -> this.refresh());
        messageBroker.registerListener("backup-import-finished", _unused -> this.refresh());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistUsageStatistics() {
        PairList valuesToPersist;
        Map<String, Long> map = this.usage;
        synchronized (map) {
            if (this.usage.isEmpty()) {
                return;
            }
            valuesToPersist = new PairList(this.usage);
            this.usage.clear();
        }
        try {
            this.usageIndex.updateUsages((PairList<String, Long>)valuesToPersist);
        }
        catch (StorageException e) {
            LOGGER.error("Failed to persist LLM usage statistics: " + e.getMessage(), (Throwable)e);
        }
    }

    private void refresh() {
        try {
            PairList<String, IOption> options = this.serverOptionIndex.getOptionsStartingWith("server:ai-engine.");
            this.updateAiProvidersFromOptions(options);
        }
        catch (StorageException e) {
            LOGGER.error("Failed to read options during AI engine provider refresh: " + e.getMessage(), (Throwable)e);
        }
    }

    private void updateAiProvidersFromOptions(PairList<String, IOption> options) {
        ArrayList<IAiEngineProvider.AiEngineDescription> aiEngineDescriptions = new ArrayList<IAiEngineProvider.AiEngineDescription>();
        HashMap<String, ILlmCompleter> completers = new HashMap<String, ILlmCompleter>();
        for (IOption option : options.extractSecondList()) {
            if (option instanceof AiEngineProviderOptionBase) {
                AiEngineProviderOptionBase aiEngineProviderOption = (AiEngineProviderOptionBase)option;
                this.registerAiEngine(aiEngineProviderOption, aiEngineDescriptions, completers);
                continue;
            }
            LOGGER.error("Obtained an option that is not a " + AiEngineProviderOptionBase.class.getSimpleName() + " but a " + String.valueOf(option.getClass()) + " during AI engine provider refresh!");
        }
        aiEngineDescriptions.sort(Comparator.comparing(IAiEngineProvider.AiEngineDescription::displayName));
        this.storeLlmProviderInformation(aiEngineDescriptions, completers);
    }

    private void registerAiEngine(AiEngineProviderOptionBase aiEngineProviderOption, List<IAiEngineProvider.AiEngineDescription> aiEngineDescriptions, Map<String, ILlmCompleter> completers) {
        try {
            String internalAiEngineName = aiEngineProviderOption.getInternalName();
            Optional<ILlmCompleter> completer = aiEngineProviderOption.createCompleter((name, value) -> {
                Map<String, Long> map = this.usage;
                synchronized (map) {
                    this.usage.merge(internalAiEngineName + "." + name, (Long)value, Long::sum);
                }
            });
            if (completer.isPresent()) {
                aiEngineDescriptions.add(new IAiEngineProvider.AiEngineDescription(internalAiEngineName, aiEngineProviderOption.getDisplayName()));
                completers.put(aiEngineProviderOption.getInternalName(), completer.get());
            }
        }
        catch (ServiceCallException e) {
            LOGGER.error("Could not instantiate completer from AI engine option " + aiEngineProviderOption.getInternalName() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeLlmProviderInformation(List<IAiEngineProvider.AiEngineDescription> aiEngineDescriptions, Map<String, ILlmCompleter> completers) {
        List<IAiEngineProvider.AiEngineDescription> list = this.availableAiEngines;
        synchronized (list) {
            Map<String, ILlmCompleter> map = this.completerByName;
            synchronized (map) {
                this.availableAiEngines.clear();
                this.availableAiEngines.addAll(aiEngineDescriptions);
                this.completerByName.clear();
                this.completerByName.putAll(completers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IAiEngineProvider.AiEngineDescription> listAvailableAiEngines() {
        List<IAiEngineProvider.AiEngineDescription> list = this.availableAiEngines;
        synchronized (list) {
            return new ArrayList<IAiEngineProvider.AiEngineDescription>(this.availableAiEngines);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String complete(String internalAiEngineName, LlmPrompt prompt) throws ServiceCallException {
        ILlmCompleter completer;
        Map<String, ILlmCompleter> map = this.completerByName;
        synchronized (map) {
            completer = this.completerByName.get(internalAiEngineName);
        }
        if (completer == null) {
            throw new ServiceCallException("No LLM completer found for internal name " + internalAiEngineName);
        }
        return completer.complete(prompt);
    }
}

