/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis;

import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.core.configuration.EFeatureToggle;

public class IndexBasedAnalysisConstants {
    public static final Set<ELanguage> SUPPORTED_LANGUAGES = EnumSet.of(ELanguage.ABAP, new ELanguage[]{ELanguage.ADA, ELanguage.COBOL, ELanguage.CPP, ELanguage.C, ELanguage.CS, ELanguage.DART, ELanguage.DELPHI, ELanguage.ESQL, ELanguage.FORTRAN, ELanguage.GO, ELanguage.GOSU, ELanguage.GROOVY, ELanguage.HANA_VIEW, ELanguage.IEC61131, ELanguage.JAVA, ELanguage.JAVASCRIPT, ELanguage.KOTLIN, ELanguage.KUBERNETES, ELanguage.LINE, ELanguage.MATLAB, ELanguage.NL_ISSUES, ELanguage.NL_REQUIREMENTS, ELanguage.NL_TESTS, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP, ELanguage.OPEN_CL, ELanguage.OSCRIPT, ELanguage.PHP, ELanguage.PLSQL, ELanguage.POWERSHELL, ELanguage.PYTHON, ELanguage.RUST, ELanguage.SIMULINK, ELanguage.SQLSCRIPT, ELanguage.SWIFT, ELanguage.TSQL, ELanguage.VB, ELanguage.XML, ELanguage.XTEND, ELanguage.CPP_MS_CLI});
    private static final Set<ELanguage> NON_CODE_LANGUAGES = EnumSet.of(ELanguage.NL_ISSUES, ELanguage.NL_REQUIREMENTS, ELanguage.NL_TESTS, ELanguage.SIMULINK);
    private static final Set<ELanguage> CLONING_AND_STRUCTURING_DISABLED_LANGUAGES = EnumSet.of(ELanguage.KUBERNETES);

    public static Set<ELanguage> getLanguagesToShow() {
        if (!EFeatureToggle.SHOW_HIDDEN_LANGUAGES.isEnabled()) {
            return SUPPORTED_LANGUAGES.stream().filter(language -> !ELanguage.HIDDEN_LANGUAGES.contains(language)).collect(Collectors.toSet());
        }
        return SUPPORTED_LANGUAGES;
    }

    public static boolean containsCodeLanguage(Collection<ELanguage> languages) {
        for (ELanguage language : languages) {
            if (NON_CODE_LANGUAGES.contains(language)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsFindingsDensityLanguage(Collection<ELanguage> languages) {
        return IndexBasedAnalysisConstants.containsCodeLanguage(languages) || languages.contains(ELanguage.SIMULINK);
    }

    public static boolean allLanguagesHaveStructuringAndCloningDisabled(Collection<ELanguage> languages) {
        return CLONING_AND_STRUCTURING_DISABLED_LANGUAGES.containsAll(languages);
    }
}

