/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.conqat.lib.commons.error.ExceptionUtils;
import org.conqat.lib.commons.function.RunnableWithException;
import org.jetbrains.annotations.VisibleForTesting;

public final class ProjectConfigurationHooks {
    private final Map<UUID, IConfigurator> configurators = new HashMap<UUID, IConfigurator>();

    public static ProjectConfigurationHooks getInstance() {
        return Instance.getInstance();
    }

    public synchronized void registerConfigurator(UUID id, IConfigurator configurator) {
        this.configurators.put(id, configurator);
    }

    public void configure(ProjectCreationProxy proxy, ConfigurationInitializationContext context, boolean validateProject) throws ProjectConfigurationException {
        ArrayList<RunnableWithException> runnables = new ArrayList<RunnableWithException>();
        for (IConfigurator entry : this.configurators.values()) {
            runnables.add(() -> entry.configure(proxy, context, validateProject));
        }
        ExceptionUtils.runAllAndAddAsSuppressed(ProjectConfigurationException.class, (RunnableWithException[])runnables.toArray(new RunnableWithException[0]));
    }

    @VisibleForTesting
    ProjectConfigurationHooks() {
    }

    private static enum Instance {
        INSTANCE(new ProjectConfigurationHooks());

        private final ProjectConfigurationHooks instance;

        private static ProjectConfigurationHooks getInstance() {
            return Instance.INSTANCE.instance;
        }

        private Instance(ProjectConfigurationHooks instance) {
            this.instance = instance;
        }
    }

    @FunctionalInterface
    public static interface IConfigurator {
        public void configure(ProjectCreationProxy var1, ConfigurationInitializationContext var2, boolean var3) throws ProjectConfigurationException;
    }
}

