/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.base;

import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.AuthenticationToolStrategyBase;
import com.teamscale.core.authenticate.base.IAuthenticationToolProvider;
import com.teamscale.core.authenticate.base.IImportGroupsStrategy;
import com.teamscale.core.authenticate.base.IImportUsersStrategy;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.base.ServerDescriptionBase;
import com.teamscale.core.authenticate.base.ServerReference;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserGroupUtils;
import com.teamscale.core.user.UserIndex;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.function.FunctionWithException;

public abstract class ImportGroupsStrategyBase<ServerDescription extends ServerDescriptionBase>
extends AuthenticationToolStrategyBase<ServerDescription>
implements IImportGroupsStrategy {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final UserGroupIndex groupIndex;
    protected final UserIndex userIndex;
    protected final IMessageBroker messageBroker;
    private final FunctionWithException<EAuthenticationTool, IAuthenticationToolProvider, StorageException> toolProviderFactory;

    protected ImportGroupsStrategyBase(NamedServer<ServerDescription> server, UserGroupIndex groupIndex, UserIndex userIndex, IMessageBroker messageBroker, FunctionWithException<EAuthenticationTool, IAuthenticationToolProvider, StorageException> toolProviderFactory) {
        super(server);
        this.groupIndex = groupIndex;
        this.userIndex = userIndex;
        this.messageBroker = messageBroker;
        this.toolProviderFactory = toolProviderFactory;
    }

    @Override
    public List<String> importGroup(String groupName) throws StorageException, AuthenticationToolException {
        UserGroup group = this.findGroup(groupName);
        ListMap<NamedServer<ServerDescription>, String> serverToUsersMapping = this.getUsersInGroup(group);
        List<IImportUsersStrategy> importDelegates = this.getUserImportDelegates();
        ArrayList<String> result = new ArrayList<String>();
        for (NamedServer targetServer : serverToUsersMapping.getKeys()) {
            List users = (List)serverToUsersMapping.getCollection((Object)targetServer);
            result.addAll(this.importUsersFromServer(targetServer, group, users, importDelegates));
        }
        UserGroup oldGroup = this.groupIndex.getUserGroup(groupName);
        if (oldGroup != null) {
            UserGroupUtils.updateGroupMembership(oldGroup, group, this.userIndex, this.groupIndex, this.messageBroker);
        }
        this.groupIndex.setGroup(group);
        return result;
    }

    private List<String> importUsersFromServer(NamedServer<ServerDescription> targetServer, UserGroup group, List<String> users, List<IImportUsersStrategy> importDelegates) throws StorageException, AuthenticationToolException {
        ArrayList<String> result = new ArrayList<String>();
        for (String userName : users) {
            List<User> matchingUsers;
            if (!importDelegates.isEmpty()) {
                LOGGER.debug("Looking for user '" + userName + "' using getUserFromDelegates");
                matchingUsers = ImportGroupsStrategyBase.getUsersFromDelegates(importDelegates, userName);
            } else {
                LOGGER.debug("Looking for user '" + userName + "' using getImportUsersStrategy");
                matchingUsers = this.getImportUsersStrategy(((ServerDescriptionBase)targetServer.serverDescription()).getAuthenticationTool(), targetServer.name()).importUser(userName);
            }
            if (matchingUsers.isEmpty()) {
                LOGGER.warn("Tried synchronizing group member '" + userName + "' found in group '" + group.getName() + "', but did not find the actual user on the server.");
                continue;
            }
            if (matchingUsers.size() > 1) {
                LOGGER.warn("Found " + matchingUsers.size() + " users for username '" + userName + ": " + matchingUsers.stream().map(User::toString).collect(Collectors.joining(", ")));
            }
            matchingUsers.forEach(user -> {
                user.addGroup(group);
                group.addUser((User)user);
            });
            this.userIndex.setUsers(matchingUsers, this.messageBroker);
            result.add(userName);
        }
        return result;
    }

    private static List<User> getUsersFromDelegates(List<IImportUsersStrategy> importStrategies, String userName) throws StorageException, AuthenticationToolException {
        HashSet<User> users = new HashSet<User>();
        for (IImportUsersStrategy importStrategy : importStrategies) {
            List<User> foundUsers = importStrategy.importUser(userName);
            users.addAll(foundUsers);
        }
        return new ArrayList<User>(users);
    }

    private List<IImportUsersStrategy> getUserImportDelegates() throws StorageException, AuthenticationToolException {
        List<ServerReference> userDelegateServers = ((ServerDescriptionBase)this.getServer().serverDescription()).getUserDelegateServers();
        if (userDelegateServers.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        ArrayList<IImportUsersStrategy> result = new ArrayList<IImportUsersStrategy>();
        for (ServerReference userDelegateServer : userDelegateServers) {
            IImportUsersStrategy delegate = this.getImportUsersStrategy(userDelegateServer.authenticationTool(), userDelegateServer.serverName());
            result.add(delegate);
        }
        return result;
    }

    private IImportUsersStrategy getImportUsersStrategy(EAuthenticationTool authenticationTool, String serverName) throws StorageException, AuthenticationToolException {
        return ((IAuthenticationToolProvider)this.toolProviderFactory.apply((Object)authenticationTool)).createImportUsersStrategy(serverName);
    }

    protected abstract UserGroup findGroup(String var1) throws AuthenticationToolException;

    protected abstract ListMap<NamedServer<ServerDescription>, String> getUsersInGroup(UserGroup var1) throws StorageException, AuthenticationToolException;
}

