/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.base;

import com.teamscale.core.authenticate.base.AuthenticationToolStrategyBase;
import com.teamscale.core.authenticate.base.ISynchronizeUsersStrategy;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.base.ServerDescriptionBase;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserIndex;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public abstract class SynchronizeUsersStrategyBase<ServerDescription extends ServerDescriptionBase>
extends AuthenticationToolStrategyBase<ServerDescription>
implements ISynchronizeUsersStrategy {
    protected final UserIndex userIndex;

    protected SynchronizeUsersStrategyBase(NamedServer<ServerDescription> server, UserIndex userIndex) {
        super(server);
        this.userIndex = userIndex;
    }

    @Override
    public List<User> getUsersForServer() throws StorageException {
        return CollectionUtils.filter(this.userIndex.getAllUsers(), this::isUserIncluded);
    }

    private boolean isUserIncluded(User user) {
        String userAuthenticator = user.getAuthenticator();
        String strategyIdentifier = this.getAuthenticatorIdentifier();
        return userAuthenticator != null && strategyIdentifier != null && userAuthenticator.startsWith(strategyIdentifier) && this.isUserFromServer(user);
    }

    private boolean isUserFromServer(User user) {
        String authenticator = user.getAuthenticator();
        return authenticator != null && authenticator.endsWith(this.getServer().name());
    }

    protected abstract String getAuthenticatorIdentifier();
}

