/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.ldap;

import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.base.SynchronizeUsersStrategyBase;
import com.teamscale.core.authenticate.ldap.LDAPAuthenticator;
import com.teamscale.core.authenticate.ldap.LDAPServerDescription;
import com.teamscale.core.authenticate.ldap.LDAPUtils;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserIndex;
import com.unboundid.ldap.sdk.LDAPException;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;

class LDAPSynchronizeUsersStrategy
extends SynchronizeUsersStrategyBase<LDAPServerDescription> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ServerOptionIndex optionIndex;
    private final IMessageBroker messageBroker;

    public LDAPSynchronizeUsersStrategy(NamedServer<LDAPServerDescription> server, UserIndex userIndex, ServerOptionIndex optionIndex, IMessageBroker messageBroker) {
        super(server, userIndex);
        this.optionIndex = optionIndex;
        this.messageBroker = messageBroker;
    }

    @Override
    public Optional<String> synchronizeUser(User user) throws StorageException, AuthenticationToolException {
        try {
            String uid = LDAPUtils.getUserDN((LDAPServerDescription)this.getServer().serverDescription(), user, this.getServer().name(), this.optionIndex);
            if (uid == null) {
                LOGGER.warn("LDAP: Error retrieving dn for: " + user.getUsername());
                return Optional.empty();
            }
            Optional<User> ldapUser = LDAPUtils.updateOrImportUser(uid, (LDAPServerDescription)this.getServer().serverDescription(), this.getServer().name(), this.userIndex, this.optionIndex, this.messageBroker);
            if (ldapUser.isEmpty()) {
                LOGGER.warn(String.format("Could not find user '%s' under cached dn: '%s'. Falling back on search by username.", user.getUsername(), uid));
                ldapUser = LDAPUtils.updateOrImportUser(user.getUsername(), (LDAPServerDescription)this.getServer().serverDescription(), this.getServer().name(), this.userIndex, this.optionIndex, this.messageBroker);
            }
            if (ldapUser.isEmpty()) {
                LOGGER.warn("LDAP: Trying to synchronize non-existing LDAP user: " + user.getUsername());
                return Optional.empty();
            }
            return Optional.of(user.getUsername());
        }
        catch (LDAPException e) {
            throw new AuthenticationToolException("Synchronizing users failed: ", e);
        }
    }

    @Override
    protected String getAuthenticatorIdentifier() {
        return LDAPAuthenticator.IDENTIFIER;
    }
}

