/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.saml;

import com.teamscale.core.authenticate.saml.SamlAuthenticationOption;
import jakarta.ws.rs.BadRequestException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.conqat.lib.commons.string.StringUtils;

public class SamlUser {
    private final String nameId;
    private final SamlAuthenticationOption samlServer;
    private final Map<String, List<String>> attributes;

    public SamlUser(String nameId, Map<String, List<String>> attributes, SamlAuthenticationOption samlServer) {
        this.nameId = nameId;
        this.samlServer = samlServer;
        this.attributes = attributes;
    }

    public SamlAuthenticationOption getSamlServer() {
        return this.samlServer;
    }

    public Optional<String> getFirstAttributeValue(String name) {
        return this.getAttributeValues(name).stream().findFirst();
    }

    public List<String> getAttributeValues(String name) {
        return this.attributes.getOrDefault(name, Collections.emptyList());
    }

    public String getTeamscaleUserName() {
        String idAttribute = this.samlServer.idAttribute;
        if (StringUtils.isEmpty((String)idAttribute)) {
            return this.nameId;
        }
        return this.getFirstAttributeValue(idAttribute).orElseThrow(() -> new BadRequestException("SAML response did not contain a value for attribute '" + idAttribute + "'!"));
    }
}

