/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log;

import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.permissions.roles.EProjectPermission;
import java.util.EnumSet;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.collections.CollectionUtils;

public class AuditLogs {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<EBasicPermission> LOGGED_FAILED_BASIC_PERMISSIONS = CollectionUtils.asUnmodifiable(EnumSet.of(EBasicPermission.EDIT_ROLES));
    private static final Set<EGlobalPermission> LOGGED_FAILED_GLOBAL_PERMISSIONS = CollectionUtils.asUnmodifiable(EnumSet.of(EGlobalPermission.EDIT_ROLES, EGlobalPermission.EDIT_GLOBAL_ROLES, EGlobalPermission.CREATE_USERS, EGlobalPermission.CREATE_GROUPS));
    private static final Set<EProjectPermission> LOGGED_FAILED_PROJECT_PERMISSIONS = CollectionUtils.asUnmodifiable(EnumSet.of(EProjectPermission.EDIT_ROLES));

    public static void userAuthentication(String username) {
        LOGGER.info("User {} has been successfully authenticated.", (Object)StringEscapeUtils.escapeJava((String)username));
    }

    public static void userLogout(String username) {
        LOGGER.info("User {} successfully logged out", (Object)StringEscapeUtils.escapeJava((String)username));
    }

    public static void globalLogDeletion(String logName) {
        LOGGER.info("Deleted " + logName);
    }

    public static void projectLogDeletion(String logName, PublicProjectId projectId) {
        LOGGER.info("Deleted " + logName + " of project " + String.valueOf(projectId));
    }

    public static void permissionUpdate(String updateMessage) {
        LOGGER.info(updateMessage);
    }

    public static void failedBasicPermissionCheck(EBasicPermission permission, String message) {
        if (LOGGED_FAILED_BASIC_PERMISSIONS.contains(permission)) {
            LOGGER.info(message);
        }
    }

    public static void failedGlobalPermissionCheck(EGlobalPermission permission, String message) {
        if (LOGGED_FAILED_GLOBAL_PERMISSIONS.contains(permission)) {
            LOGGER.info(message);
        }
    }

    public static void failedProjectPermissionCheck(EProjectPermission permission, String message) {
        if (LOGGED_FAILED_PROJECT_PERMISSIONS.contains(permission)) {
            LOGGER.info(message);
        }
    }
}

