/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics.schema;

import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.source.IMetricSource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ProjectIndexWithDynamicNameBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;

@Index(name="(dynamic)", options={EStorageOption.COMPRESSED, EStorageOption.HISTORIZED}, valueClasses={MetricDirectorySchema.class, IMetricSource.class})
public class MetricSchemaIndex
extends ProjectIndexWithDynamicNameBase {
    public static final String INDEX_NAME = "metric-schema";
    private static final String SCHEMA_KEY = "schema";
    private static final String SOURCES_KEY = "sources";

    public MetricSchemaIndex(IStore store) {
        super(store);
    }

    public @Nullable MetricDirectorySchema getPublicSchema() throws StorageException {
        MetricDirectorySchema fullSchema = this.getFullSchema();
        if (fullSchema == null) {
            return null;
        }
        return fullSchema.extractPublicSchema();
    }

    public @Nullable MetricDirectorySchema getFullSchema() throws StorageException {
        return (MetricDirectorySchema)StorageUtils.deserialize((byte[])this.store.getWithString(SCHEMA_KEY));
    }

    public @Nullable MetricDirectorySchema findSchema(boolean publicOnly) throws StorageException {
        if (publicOnly) {
            return this.getPublicSchema();
        }
        return this.getFullSchema();
    }

    public MetricDirectorySchema getSchema(boolean publicOnly) throws StorageException {
        MetricDirectorySchema result = this.findSchema(publicOnly);
        CCSMAssert.isNotNull((Object)String.format("The schema returned for index '%s' is not expected to be null.", this.getName()));
        return result;
    }

    public void setSchema(MetricDirectorySchema schema) throws StorageException {
        this.store.putWithString(SCHEMA_KEY, StorageUtils.serialize((Serializable)schema));
    }

    public List<IMetricSource> getMetricSources() throws StorageException {
        return (List)((Object)StorageUtils.deserialize((byte[])this.store.getWithString(SOURCES_KEY)));
    }

    public void setMetricSources(List<IMetricSource> metricSources) throws StorageException {
        this.store.putWithString(SOURCES_KEY, StorageUtils.serialize(new ArrayList<IMetricSource>(metricSources)));
    }

    public static enum EMetricSchemaType {
        CODE("metric-schema"),
        PROCESS("process-metric-schema"),
        TEST_EXECUTION("test-execution-metric-schema"),
        WORK_ITEM("work-item-metrics-schema");

        private final String indexName;

        private EMetricSchemaType(String indexName) {
            this.indexName = indexName;
        }

        public String getIndexName() {
            return this.indexName;
        }
    }
}

