/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics.source;

import com.teamscale.core.metrics.source.DoubleCalculatorMetricSourceBase;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class DivisionMetricSource
extends DoubleCalculatorMetricSourceBase {
    private static final long serialVersionUID = 1L;
    private final double defaultValueIfDenominatorZero;
    private final Set<CodeScopeName> codeScopesWithDisabledDivisionMetric;

    public DivisionMetricSource(int numeratorOffset, int denominatorOffset, double defaultValueIfDenominatorZero, Set<CodeScopeName> codeScopesWithDisabledDivisionMetric) {
        super(numeratorOffset, denominatorOffset);
        this.defaultValueIfDenominatorZero = defaultValueIfDenominatorZero;
        this.codeScopesWithDisabledDivisionMetric = codeScopesWithDisabledDivisionMetric;
    }

    @Override
    protected @Nullable Double calculateValue(double arg1, double arg2, @Nullable CodeScopeName codeScopeName) {
        if (codeScopeName != null && this.codeScopesWithDisabledDivisionMetric.contains(codeScopeName)) {
            return null;
        }
        if (arg2 == 0.0) {
            return this.defaultValueIfDenominatorZero;
        }
        return arg1 / arg2;
    }
}

