/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.option.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.OptionDescriptor;
import com.teamscale.core.option.OptionRegistryBase;
import com.teamscale.core.option.server.ServerOptionIndex;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.TestOnly;

public class ServerOptionRegistry
extends OptionRegistryBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String SERVER_OPTION_CATEGORY = "server";
    private static final String HIDDEN_OPTIONS_KEY = "hidden";
    private static ServerOptionRegistry instance;
    private Map<String, IOption> optionsFromConfig = Collections.emptyMap();
    private final Set<String> hiddenOptionIds = new HashSet<String>();

    private ServerOptionRegistry() {
        super(EOptionType.SERVER);
    }

    public static synchronized ServerOptionRegistry getInstance() {
        if (instance == null) {
            instance = new ServerOptionRegistry();
        }
        return instance;
    }

    @TestOnly
    public static void resetSingletonInstanceForTesting() {
        instance = new ServerOptionRegistry();
    }

    public <T extends IOption> T getServerMultiOption(String optionId, String multiOptionSelector, Class<T> expectedClass, ServerOptionIndex index) throws StorageException {
        return super.getOption(SERVER_OPTION_CATEGORY, optionId, multiOptionSelector, expectedClass, index);
    }

    public static Map<String, IOption> getServerMultiOptionAll(String optionId, ServerOptionIndex index) throws StorageException {
        Map options = index.getOptionsStartingWith("server:" + optionId).toMap();
        PairList optionsFormAdminSettings = new PairList();
        ServerOptionRegistry.getInstance().appendDirectOptions("server:" + optionId, (PairList<String, IOption>)optionsFormAdminSettings);
        options.putAll(optionsFormAdminSettings.toMap());
        return options;
    }

    public Map<String, IOption> getServerOptions(String optionIdPrefix, ServerOptionIndex index) throws StorageException {
        return super.getOptions("server:" + optionIdPrefix, index, false);
    }

    public <T extends IOption> T getServerOption(String optionId, Class<T> expectedClass, ServerOptionIndex serverOptionIndex) throws StorageException {
        return super.getOption(SERVER_OPTION_CATEGORY, optionId, null, expectedClass, serverOptionIndex);
    }

    public static Map<String, IOption> getAllServerOptions(IndexLayer indexLayer) throws StorageException {
        ServerOptionIndex optionIndex = indexLayer.openGlobalIndex(ServerOptionIndex.class);
        return ServerOptionRegistry.getInstance().getOptions(SERVER_OPTION_CATEGORY, optionIndex, true);
    }

    public void loadServerOptionsFromFileContent(String configFileContent) {
        JsonNode node;
        if (configFileContent == null || configFileContent.isEmpty()) {
            LOGGER.warn("Attempt to load server options with no config file content");
            this.optionsFromConfig = Collections.emptyMap();
            this.hiddenOptionIds.clear();
            return;
        }
        try {
            node = JsonUtils.getObjectMapper().readTree(configFileContent);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Server options config file could not be parsed (invalid JSON): {}", (Object)e.getMessage());
            return;
        }
        if (!node.isObject()) {
            LOGGER.error("Server options config file did not contain a JSON object as expected!");
            return;
        }
        this.hiddenOptionIds.clear();
        this.optionsFromConfig = this.fillOptionsMap(node);
    }

    public boolean attemptFileConfigOptionsValidationAndLog(@Nullable IStorageInfo storageInfo, @Nullable InstanceConfiguration instanceConfiguration) {
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        ArrayList<CallSite> failures = new ArrayList<CallSite>();
        for (Map.Entry<String, IOption> entry : this.optionsFromConfig.entrySet()) {
            try {
                String message = entry.getValue().validate(storageInfo, instanceConfiguration);
                if (message == null || message.isEmpty()) continue;
                errors.add((CallSite)((Object)(entry.getKey() + ": " + message)));
            }
            catch (Throwable e) {
                failures.add((CallSite)((Object)(entry.getKey() + " (" + e.getMessage() + ")")));
            }
        }
        if (!errors.isEmpty()) {
            LOGGER.error("Encountered %d validation %s in config file options (%d %s loaded):\n%s".formatted(errors.size(), StringUtils.pluralize((String)"error", (int)errors.size()), this.optionsFromConfig.size(), StringUtils.pluralize((String)"option", (int)this.optionsFromConfig.size()), StringUtils.concat(errors, (String)"\n")));
        }
        if (!failures.isEmpty()) {
            LOGGER.info("The validation for some config file options was not performed:\n" + StringUtils.concat(failures, (String)"\n"));
        }
        return errors.isEmpty() && failures.isEmpty();
    }

    private Map<String, IOption> fillOptionsMap(JsonNode node) {
        HashMap<String, IOption> result = new HashMap<String, IOption>();
        Iterator fieldIterator = node.fields();
        while (fieldIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldIterator.next();
            String optionName = (String)field.getKey();
            try {
                if (optionName.equals(HIDDEN_OPTIONS_KEY)) {
                    this.hiddenOptionIds.addAll((Collection)JsonUtils.getObjectMapper().readerFor(JsonUtils.getJavaListType(String.class)).readValue((JsonNode)field.getValue()));
                    continue;
                }
                OptionDescriptor descriptor = this.getOptionDescriptor((String)ServerOptionRegistry.extractOptionNameAndSelector(optionName).getFirst());
                if (descriptor == null) {
                    LOGGER.error("No server option descriptor found for option name: {}", (Object)optionName);
                    continue;
                }
                IOption option = (IOption)JsonUtils.getObjectMapper().readerFor(descriptor.getOptionClass()).readValue((JsonNode)field.getValue());
                result.put(optionName, option);
            }
            catch (IOException e) {
                LOGGER.error("Could not parse option stored for name {}: {}", (Object)optionName, (Object)e.getMessage());
            }
        }
        return result;
    }

    @Override
    protected @Nullable IOption getOptionValueOverride(String optionCategory, String optionId, String multiOptionSelector) {
        IOption value;
        Object key = optionId;
        if (multiOptionSelector != null) {
            key = (String)key + "/" + multiOptionSelector;
        }
        if ((value = this.optionsFromConfig.get(key)) == null) {
            return null;
        }
        return (IOption)SerializationUtils.cloneBySerialization((Serializable)value);
    }

    @Override
    protected void appendDirectOptions(String optionPrefix, PairList<String, IOption> optionList) {
        for (Map.Entry<String, IOption> entry : this.optionsFromConfig.entrySet()) {
            String fullOptionName = "server:" + entry.getKey();
            if (!fullOptionName.startsWith(optionPrefix)) continue;
            optionList.add((Object)fullOptionName, (Object)((IOption)SerializationUtils.cloneBySerialization((Serializable)entry.getValue())));
        }
    }

    @Override
    protected boolean isOverridden(OptionDescriptor optionDescriptor) {
        return this.hiddenOptionIds.contains(optionDescriptor.getId()) || this.optionsFromConfig.containsKey(optionDescriptor.getId());
    }
}

