/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.options;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.MultilineOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="file-system-access", name="File System Access", type=EOptionType.SERVER, category=EOptionCategory.SERVER, orderingHint=1500)
@IndexValueClass(containedInBackup=true)
public class FileSystemAccessOption
implements IOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "file-system-access";
    public static final String OPTION_NAME = "File System Access";
    @JsonProperty(value="accessibleFilepaths")
    @MultilineOption
    @OptionFieldDescription(name="Accessible Server Paths", description="The absolute paths of all directories on the server where file system connectors should be granted recursive read access (one path per line). To avoid potential security problems, this is a required setting for using file system connectors.")
    private String accessibleFilepaths = "";
    private transient List<Path> accessibleFilepathsList = null;

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        ArrayList<String> invalidPaths = new ArrayList<String>();
        for (Path path : this.getAccessibleFilepaths()) {
            try {
                path.toRealPath(new LinkOption[0]);
            }
            catch (IOException e) {
                invalidPaths.add(path.toString());
            }
        }
        if (invalidPaths.isEmpty()) {
            return null;
        }
        return "Some paths could not be accessed. Please check if they really exist and Teamscale has the proper access rights: " + StringUtils.concat(invalidPaths, (String)", ") + ".";
    }

    public List<Path> getAccessibleFilepaths() {
        if (this.accessibleFilepathsList == null) {
            this.accessibleFilepathsList = FileSystemAccessOption.extractAccessibleFilePathsList(this.accessibleFilepaths);
        }
        return this.accessibleFilepathsList;
    }

    private static List<Path> extractAccessibleFilePathsList(String accessibleFilepaths) {
        return StringUtils.splitLinesAsList((String)accessibleFilepaths).stream().map(String::trim).map(x$0 -> Paths.get(x$0, new String[0])).map(Path::normalize).collect(Collectors.toList());
    }

    public void validateConnectorAccess(Path path) throws ConnectorValidationException {
        try {
            if (EFeatureToggle.ENABLE_DEV_MODE.isEnabled()) {
                return;
            }
            if (this.getAccessibleFilepaths().isEmpty()) {
                throw new ConnectorValidationException(FileSystemAccessOption.createInvalidAccessErrorMessage("all paths"));
            }
            if (!this.isAccessible(path)) {
                throw new ConnectorValidationException(FileSystemAccessOption.createInvalidAccessErrorMessage(path));
            }
        }
        catch (IOException e) {
            throw new ConnectorValidationException(FileSystemAccessOption.createInvalidAccessErrorMessage(path));
        }
    }

    public void validateRepositoryAccess(Path path) throws RepositoryException, IOException {
        if (!this.isAccessible(path)) {
            throw new RepositoryException(FileSystemAccessOption.createInvalidAccessErrorMessage(path));
        }
    }

    private static String createInvalidAccessErrorMessage(Path path) {
        return FileSystemAccessOption.createInvalidAccessErrorMessage("path '" + String.valueOf(path.normalize()) + "'");
    }

    private static String createInvalidAccessErrorMessage(String locationMessagePart) {
        return "File system access is forbidden for " + locationMessagePart + " (configure under Admin > Settings > Server Settings > File System Access or contact your Teamscale administrator. ";
    }

    private boolean isAccessible(Path path) throws IOException {
        if (EFeatureToggle.ENABLE_DEV_MODE.isEnabled()) {
            return true;
        }
        Path pathToCheck = path.toRealPath(new LinkOption[0]).normalize();
        return this.getAccessibleFilepaths().stream().anyMatch(pathToCheck::startsWith);
    }

    public static FileSystemAccessOption getOption(ServerOptionIndex serverOptionIndex) throws StorageException {
        return Optional.ofNullable(ServerOptionRegistry.getInstance().getServerOption(OPTION_ID, FileSystemAccessOption.class, serverOptionIndex)).orElse(new FileSystemAccessOption());
    }
}

