/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.options;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;

@ExportToTypeScript
@Option(id="git.clone.directory", name="Code Repository Cloning", type=EOptionType.SERVER, category=EOptionCategory.GIT, orderingHint=500)
@IndexValueClass(containedInBackup=true)
public class RepositoryCloneOption
implements IOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "git.clone.directory";
    public static final String OPTION_NAME = "Code Repository Cloning";
    @JsonProperty(value="cloneDirectory")
    @OptionFieldDescription(name="Repository Clone Directory", description="Path to the directory that is used for cloning remote repositories. Path has to be absolute or relative to the working directory.")
    private String cloneDirectory = "repo";

    public RepositoryCloneOption() {
    }

    @VisibleForTesting
    public RepositoryCloneOption(String cloneDirectory) {
        this.cloneDirectory = cloneDirectory;
    }

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        String resolvedCloneDirectory = this.getRepositoryCloneDirectory().toString();
        if (!FileSystemUtils.isValidPath((String)resolvedCloneDirectory)) {
            return "The git cloning directory is not a valid path: '" + resolvedCloneDirectory + "'. Path separators have to be used according to the server OS ('/' on unix, '\\' on Windows) and paths must not contain the respective other separator.";
        }
        if (!FileSystemUtils.isPathWriteable((Path)Paths.get(resolvedCloneDirectory, new String[0]))) {
            return "The git cloning directory path is not a writeable path: " + resolvedCloneDirectory;
        }
        return null;
    }

    public static Path getRepositoryCloneDirectory(ServerOptionIndex serverOptionIndex) throws StorageException {
        RepositoryCloneOption option = ServerOptionRegistry.getInstance().getServerOption(OPTION_ID, RepositoryCloneOption.class, serverOptionIndex);
        return option.getRepositoryCloneDirectory();
    }

    public Path getRepositoryCloneDirectory() {
        if (StringUtils.isEmpty((String)this.cloneDirectory)) {
            return FileSystemUtils.getJvmWorkingDirOrTempForDevMode().toPath();
        }
        Path path = Path.of(this.cloneDirectory, new String[0]);
        if (path.isAbsolute()) {
            return path;
        }
        return FileSystemUtils.getJvmWorkingDirOrTempForDevMode().toPath().resolve(path);
    }
}

