/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis;

import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.runtime.impl.analysis.trigger.ETriggerType;
import com.teamscale.core.runtime.impl.analysis.trigger.PrivilegedTrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class JobDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final InternalProjectId internalProjectId;
    private final ETriggerType triggerType;
    private final String triggerName;
    private final @Nullable CommitDescriptor schedulingCommit;
    private final @Nullable String parameter;
    private final boolean rollbackRelevant;
    private final boolean isCritical;
    private final String schedulingReason;
    private final @Nullable UUID rollbackId;
    private final boolean cancelable;

    public JobDescriptor(InternalProjectId internalProjectId, ETriggerType triggerType, String triggerName, CommitDescriptor schedulingCommit, boolean rollbackRelevant, String schedulingReason, boolean cancelable) {
        this(internalProjectId, triggerType, triggerName, schedulingCommit, rollbackRelevant, null, false, schedulingReason, null, cancelable);
    }

    public JobDescriptor(InternalProjectId internalProjectId, Class<? extends PrivilegedTriggerBase> triggerClass, @Nullable CommitDescriptor schedulingCommit, String schedulingReason) {
        this(internalProjectId, triggerClass, schedulingCommit, null, false, schedulingReason, null);
    }

    public JobDescriptor(InternalProjectId internalProjectId, Class<? extends PrivilegedTriggerBase> triggerClass, @Nullable CommitDescriptor schedulingCommit, String schedulingReason, UUID rollbackId) {
        this(internalProjectId, triggerClass, schedulingCommit, null, true, schedulingReason, rollbackId);
    }

    public JobDescriptor(InternalProjectId internalProjectId, Class<? extends PrivilegedTriggerBase> triggerClass, @Nullable CommitDescriptor schedulingCommit, @Nullable Object parameter, String schedulingReason) {
        this(internalProjectId, ETriggerType.PRIVILEGED, triggerClass.getName(), schedulingCommit, true, parameter, false, schedulingReason, null, JobDescriptor.isTriggerCancelable(triggerClass));
    }

    private JobDescriptor(InternalProjectId internalProjectId, Class<? extends PrivilegedTriggerBase> triggerClass, CommitDescriptor schedulingCommit, String parameter, boolean isCritical, String schedulingReason, UUID rollbackId) {
        this(internalProjectId, ETriggerType.PRIVILEGED, triggerClass.getName(), schedulingCommit, true, parameter, isCritical, schedulingReason, rollbackId, JobDescriptor.isTriggerCancelable(triggerClass));
    }

    private JobDescriptor(InternalProjectId internalProjectId, ETriggerType triggerType, String triggerName, @Nullable CommitDescriptor schedulingCommit, boolean rollbackRelevant, @Nullable Object parameter, boolean isCritical, String schedulingReason, @Nullable UUID rollbackId, boolean cancelable) {
        this.internalProjectId = internalProjectId;
        this.triggerType = triggerType;
        this.triggerName = triggerName;
        this.schedulingCommit = schedulingCommit;
        this.rollbackRelevant = rollbackRelevant;
        this.parameter = parameter == null || parameter instanceof String ? (String)parameter : JsonUtils.serializeToJSON((Object)parameter);
        this.isCritical = isCritical;
        this.schedulingReason = schedulingReason;
        this.rollbackId = rollbackId;
        this.cancelable = cancelable;
    }

    public JobDescriptor copyWithNewSchedulingReason(String schedulingReason) {
        return new JobDescriptor(this.internalProjectId, this.triggerType, this.triggerName, this.schedulingCommit, this.rollbackRelevant, this.parameter, this.isCritical, schedulingReason, this.rollbackId, this.cancelable);
    }

    public InternalProjectId getInternalProjectId() {
        return this.internalProjectId;
    }

    public ETriggerType getTriggerType() {
        return this.triggerType;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public @Nullable CommitDescriptor getSchedulingCommit() {
        return this.schedulingCommit;
    }

    public @Nullable String getParameter() {
        return this.parameter;
    }

    public <T> T getParameterObject(Class<T> expectedClass) throws JsonSerializationException {
        return (T)JsonUtils.deserializeFromJson((String)this.parameter, expectedClass);
    }

    public boolean isRollbackRelevant() {
        return this.rollbackRelevant;
    }

    public boolean isCritical() {
        return this.isCritical;
    }

    public @Nullable UUID getRollbackId() {
        return this.rollbackId;
    }

    public static JobDescriptor createMaintenanceTriggerWithParameter(Class<? extends PrivilegedTriggerBase> triggerClass, String parameter, String schedulingReason) {
        return new JobDescriptor(SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID, triggerClass, null, (Object)parameter, schedulingReason);
    }

    public static JobDescriptor createMaintenanceTriggerWithParameter(Class<? extends PrivilegedTriggerBase> triggerClass, Object parameter, String schedulingReason) {
        return new JobDescriptor(SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID, triggerClass, null, parameter, schedulingReason);
    }

    private static boolean isTriggerCancelable(Class<? extends PrivilegedTriggerBase> triggerClass) {
        try {
            return PrivilegedTrigger.createTrigger(triggerClass.getName()).isCancelable();
        }
        catch (TriggerCompilationException e) {
            return false;
        }
    }

    public String getSchedulingReason() {
        return this.schedulingReason;
    }

    public String toString() {
        return String.valueOf(this.internalProjectId) + "/" + this.triggerName + " (@" + String.valueOf(this.schedulingCommit) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobDescriptor that = (JobDescriptor)o;
        return this.rollbackRelevant == that.rollbackRelevant && this.isCritical == that.isCritical && this.internalProjectId.equals((Object)that.internalProjectId) && this.triggerType == that.triggerType && this.triggerName.equals(that.triggerName) && Objects.equals(this.schedulingCommit, that.schedulingCommit) && Objects.equals(this.parameter, that.parameter) && Objects.equals(this.schedulingReason, that.schedulingReason) && Objects.equals(this.rollbackId, that.rollbackId) && Objects.equals(this.cancelable, that.cancelable);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.internalProjectId, this.triggerType, this.triggerName, this.schedulingCommit, this.parameter, this.rollbackRelevant, this.isCritical, this.schedulingReason, this.rollbackId, this.cancelable});
    }

    public boolean isCancelable() {
        return this.cancelable;
    }
}

