/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis.step;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepIndexAccessBase;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepParameter;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import java.lang.reflect.Field;
import java.util.List;
import org.conqat.engine.persistence.index.IProjectIndexBase;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.lib.commons.string.StringUtils;

public class AnalysisStepIndexAccess
extends AnalysisStepIndexAccessBase {
    private final IndexAccess indexAccess;

    AnalysisStepIndexAccess(Field field, List<Field> fieldStack, IndexAccess indexAccess) throws TriggerCompilationException {
        super(field, fieldStack, AnalysisStepIndexAccess.resolveIndexName(field, indexAccess));
        this.indexAccess = indexAccess;
        if (indexAccess.value() != EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY && !IProjectIndexBase.class.isAssignableFrom(field.getType())) {
            throw new TriggerCompilationException("May use index access annotation only for project indexes, not for " + field.getType().getSimpleName());
        }
    }

    private static String resolveIndexName(Field field, IndexAccess indexAccess) throws TriggerCompilationException {
        if (indexAccess.value() == EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY) {
            return AnalysisStepIndexAccess.resolveIndexNameForAllParentRevisionsMode(field, indexAccess);
        }
        if (StringUtils.isEmpty((String)indexAccess.indexName())) {
            return AnalysisStepIndexAccess.resolveIndexNameFromIndexClass(AnalysisStepIndexAccess.asProjectIndexBase(field, field.getType()), field);
        }
        return indexAccess.indexName();
    }

    private static String resolveIndexNameForAllParentRevisionsMode(Field field, IndexAccess indexAccess) throws TriggerCompilationException {
        if (!field.getType().equals(List.class)) {
            throw new TriggerCompilationException("Field " + String.valueOf(field) + " annotated with mode " + String.valueOf((Object)EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY) + " must be of type List");
        }
        Class<? extends IProjectIndexBase> indexClass = AnalysisStepIndexAccess.asProjectIndexBase(field, AnalysisStepParameter.getNthGenericTypeArgument(field, 0));
        if (!StringUtils.isEmpty((String)indexAccess.indexName())) {
            return indexAccess.indexName();
        }
        return AnalysisStepIndexAccess.resolveIndexNameFromIndexClass(indexClass, field);
    }

    private static Class<? extends IProjectIndexBase> asProjectIndexBase(Field field, Class<?> indexClass) throws TriggerCompilationException {
        if (!IProjectIndexBase.class.isAssignableFrom(indexClass)) {
            throw new TriggerCompilationException("May use index access annotation only for project indexes, not for " + field.getType().getSimpleName());
        }
        return indexClass.asSubclass(IProjectIndexBase.class);
    }

    @Override
    public EIndexAccessMode getAccessMode() {
        return this.indexAccess.value();
    }

    public boolean isSkipDeltaCreation() {
        return this.getAccessMode() != EIndexAccessMode.READ_WRITE || this.indexAccess.skipDeltaCreation();
    }

    @Override
    public Class<? extends IStorageIndex> getIndexClass() {
        if (this.getAccessMode() == EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY) {
            try {
                return AnalysisStepParameter.getNthGenericTypeArgument(this.getField(), 0).asSubclass(IStorageIndex.class);
            }
            catch (TriggerCompilationException | ClassCastException e) {
                throw new AssertionError("Failed to determine generic parameter for " + String.valueOf(this.getField()) + ": " + e.getMessage(), e);
            }
        }
        return super.getIndexClass();
    }

    @Override
    protected String getToStringPrefix() {
        return "index access: " + this.getIndexName();
    }
}

