/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreator;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.trigger.PostRevisionCommitDescriptor;
import com.teamscale.core.analysis.trigger.RichCommitDescriptor;
import com.teamscale.core.analysis.trigger.RollbackRequestedCommitDescriptor;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.log.RollbackLogMessage;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.core.runtime.api.progress.AnalysisState;
import com.teamscale.core.runtime.impl.CommitChildrenIndex;
import com.teamscale.core.runtime.impl.analysis.DeltaIndex;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.analysis.TriggerIndex;
import com.teamscale.core.runtime.impl.analysis.VirtualStoreIndex;
import com.teamscale.core.runtime.impl.analysis.trigger.AnalysisTrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.ETriggerType;
import com.teamscale.core.runtime.impl.analysis.trigger.ITrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateIndex;
import com.teamscale.core.runtime.impl.rollback.PostRevisionAnalysisTriggerBase;
import com.teamscale.core.runtime.impl.rollback.RollbackTrigger;
import com.teamscale.core.runtime.impl.scheduling.CommitDescriptorMerger;
import com.teamscale.core.runtime.impl.scheduling.JobQueue;
import com.teamscale.core.runtime.impl.scheduling.PeriodicJobSupport;
import com.teamscale.core.runtime.impl.scheduling.ProjectProgressPublisher;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import com.teamscale.core.runtime.impl.scheduling.SchedulingHelper;
import com.teamscale.core.runtime.impl.worker.JobExecutionResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.cache.StorageCacheProvider;
import org.conqat.engine.persistence.cache.StorageCacheRegistry;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.distribution.LocalMessageBroker;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.engine.persistence.store.transaction.TransactionHandler;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.string.StringUtils;

public class JobCompletionSupport {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int INITIAL_RESCHEDULE_DELAY = 10;
    private static final int MAX_RESCHEDULE_DELAY = 3600;
    private final InternalProjectId projectId;
    private final DeltaIndex deltaIndex;
    private final VirtualStoreIndex virtualStoreIndex;
    private final SchedulingHelper schedulingHelper;
    private final PeriodicJobSupport periodicJobSupport;
    private final IndexLayer indexLayer;
    private final ProjectProgressPublisher projectProgressPublisher;

    public JobCompletionSupport(InternalProjectId projectId, DeltaIndex deltaIndex, VirtualStoreIndex virtualStoreIndex, PeriodicJobSupport periodicJobSupport, IndexLayer indexLayer, ProjectProgressPublisher projectProgressPublisher) {
        this.projectId = projectId;
        this.deltaIndex = deltaIndex;
        this.virtualStoreIndex = virtualStoreIndex;
        this.schedulingHelper = periodicJobSupport.getSchedulingHelper();
        this.periodicJobSupport = periodicJobSupport;
        this.indexLayer = indexLayer;
        this.projectProgressPublisher = projectProgressPublisher;
    }

    public boolean completeJob(ScheduledJob scheduledJob, JobExecutionResult executionResult, Consumer<Throwable> errorHandler) throws StorageException, TriggerCompilationException {
        boolean completedJob = this.completeJobInternal(scheduledJob, executionResult, errorHandler);
        if (!completedJob) {
            this.projectProgressPublisher.publishProgress(scheduledJob);
        }
        return completedJob;
    }

    private boolean completeJobInternal(ScheduledJob scheduledJob, JobExecutionResult executionResult, Consumer<Throwable> errorHandler) throws TriggerCompilationException, StorageException {
        if (!this.periodicJobSupport.isInvalid()) {
            this.schedulingHelper.getAssignedJobs().removeJob(scheduledJob);
        }
        if (this.rescheduleIfNecessary(scheduledJob, executionResult)) {
            return false;
        }
        LOGGER.debug(() -> "Completed job: " + String.valueOf(scheduledJob.getJob()) + " (" + String.valueOf(scheduledJob.getInputDeltaStoreNames()) + " -> " + String.valueOf(executionResult.getOutputDeltas()));
        this.removeDeltasAndVirtualStores(scheduledJob);
        if (executionResult.getResult() == JobExecutionResult.EJobResult.COMPLETED_WITH_UNRECOVERABLE_ERROR) {
            return false;
        }
        CommitDescriptor outputCommit = executionResult.getOutputCommit();
        if (outputCommit instanceof RollbackRequestedCommitDescriptor) {
            this.performRequestedRollback(scheduledJob.getJob(), (RollbackRequestedCommitDescriptor)outputCommit);
            return false;
        }
        if (JobCompletionSupport.isJobWithEmptyOutputDelta(executionResult)) {
            this.completeEmptyDeltaJob(scheduledJob, outputCommit);
        } else {
            this.insertNewDeltasFromJob(scheduledJob, executionResult);
        }
        return this.executePostExecutionSteps(scheduledJob, executionResult, errorHandler);
    }

    private void removeDeltasAndVirtualStores(ScheduledJob scheduledJob) throws StorageException {
        List deltaIdsToRemove = CollectionUtils.filter(scheduledJob.getInputDeltaIds(), this.schedulingHelper::isUnusedDelta);
        List virtualStoreIdsToRemove = CollectionUtils.filter(scheduledJob.getAllVirtualStoreIds(), this.schedulingHelper::isUnusedVirtualStore);
        if (!deltaIdsToRemove.isEmpty()) {
            LOGGER.debug(() -> "Removing unused input deltas: " + StringUtils.concat((Iterable)deltaIdsToRemove));
            this.deltaIndex.removeDeltas(deltaIdsToRemove);
        }
        if (!virtualStoreIdsToRemove.isEmpty()) {
            LOGGER.debug(() -> "Removing unused virtual stores: " + StringUtils.concat((Iterable)virtualStoreIdsToRemove));
            this.virtualStoreIndex.discardVirtualStores(virtualStoreIdsToRemove);
        }
    }

    private static boolean isJobWithEmptyOutputDelta(JobExecutionResult executionResult) {
        CommitDescriptor outputCommit = executionResult.getOutputCommit();
        return outputCommit == null || RichCommitDescriptor.isOnlyHints(outputCommit) || executionResult.getOutputDeltas().isEmpty();
    }

    private boolean rescheduleIfNecessary(ScheduledJob scheduledJob, JobExecutionResult executionResult) throws TriggerCompilationException {
        ITrigger trigger = this.schedulingHelper.getTriggerCache().getTrigger(scheduledJob);
        if (executionResult.getResult() != JobExecutionResult.EJobResult.RESCHEDULE_REQUESTED) {
            trigger.setRescheduleDelaySeconds(0);
            return false;
        }
        if (executionResult.getRescheduleAfterTimestamp() > DateTimeUtils.millisNow()) {
            ScheduledJob rescheduledJob = ScheduledJob.copyWithRescheduleUpdate(scheduledJob, executionResult.getRescheduleAfterTimestamp(), scheduledJob.getRetryCount() + 1);
            this.schedulingHelper.rescheduleJob(rescheduledJob);
            return true;
        }
        int delaySeconds = 10;
        if (trigger.getRescheduleDelaySeconds() > 0) {
            delaySeconds = Math.min(3600, 2 * trigger.getRescheduleDelaySeconds());
        }
        trigger.setRescheduleDelaySeconds(delaySeconds);
        ScheduledJob rescheduledJob = ScheduledJob.copyWithRescheduleUpdate(scheduledJob, DateTimeUtils.millisNow() + (long)delaySeconds * 1000L, scheduledJob.getRetryCount() + 1);
        this.schedulingHelper.rescheduleJob(rescheduledJob);
        return true;
    }

    private void insertNewDeltasFromJob(ScheduledJob scheduledJob, JobExecutionResult executionResult) throws StorageException, TriggerCompilationException {
        CommitDescriptor outputCommit = executionResult.getOutputCommit();
        JobCompletionSupport.assertConstraintsForCompletedJob(scheduledJob, executionResult, outputCommit);
        PairList<String, Long> outputDeltas = executionResult.getOutputDeltas();
        ArrayList<Long> deltaIdsToRemove = new ArrayList<Long>();
        ArrayList<Long> virtualStoreIdsToRemove = new ArrayList<Long>();
        for (int i = 0; i < outputDeltas.size(); ++i) {
            String store = (String)outputDeltas.getFirst(i);
            long deltaId = (Long)outputDeltas.getSecond(i);
            Optional<Long> virtualStoreId = executionResult.getVirtualStoreId(store);
            this.insertNewDeltaFromJob(scheduledJob, outputCommit, store, deltaId, virtualStoreId.orElse(null));
            if (this.schedulingHelper.isUnusedDelta(deltaId)) {
                deltaIdsToRemove.add(deltaId);
            }
            if (!virtualStoreId.isPresent() || !this.schedulingHelper.isUnusedVirtualStore(virtualStoreId.get())) continue;
            virtualStoreIdsToRemove.add(virtualStoreId.get());
        }
        if (!deltaIdsToRemove.isEmpty()) {
            this.deltaIndex.removeDeltas(deltaIdsToRemove);
        }
        if (!virtualStoreIdsToRemove.isEmpty()) {
            this.virtualStoreIndex.discardVirtualStores(virtualStoreIdsToRemove);
        }
    }

    private static void assertConstraintsForCompletedJob(ScheduledJob scheduledJob, JobExecutionResult executionResult, CommitDescriptor outputCommit) {
        CCSMAssert.isNotNull((Object)scheduledJob.getSchedulingCommit(), () -> "A job scheduled with null commit may never return deltas, but only scheduling hints: " + String.valueOf(scheduledJob));
        CCSMAssert.isNotNull((Object)outputCommit, () -> "May not spawn jobs from a job with no output commit. Job: " + String.valueOf(scheduledJob.getJob()));
        CCSMAssert.isFalse((boolean)RichCommitDescriptor.isOnlyHints(outputCommit), () -> "Can't insert new deltas from job " + String.valueOf(scheduledJob) + " that only outputs scheduling hints: " + String.valueOf(executionResult));
        CCSMAssert.isFalse((boolean)(outputCommit instanceof RollbackRequestedCommitDescriptor), () -> "Can't insert deltas from job " + String.valueOf(scheduledJob) + " that requests a rollback to: " + String.valueOf(outputCommit));
    }

    private void insertNewDeltaFromJob(ScheduledJob scheduledJob, CommitDescriptor outputCommit, String store, long deltaId, @Nullable Long virtualStoreId) throws TriggerCompilationException, StorageException {
        for (AnalysisTrigger trigger : this.schedulingHelper.getTriggerCache().getTriggersConsumingDelta(store)) {
            LOGGER.debug(() -> "Assigning delta " + deltaId + " to trigger " + String.valueOf(trigger));
            this.assignDeltaToJob(scheduledJob, outputCommit, trigger, store, deltaId, virtualStoreId);
        }
        ITrigger trigger = this.schedulingHelper.getTriggerCache().getTrigger(scheduledJob.getJob());
        if (trigger.isPeriodic() && outputCommit instanceof ParentedCommitDescriptor) {
            CommitDescriptorIndex commitDescriptorIndex = CommitDescriptorIndex.open(this.indexLayer, (IProjectId)this.projectId);
            CommitChildrenIndex commitChildrenIndex = CommitChildrenIndex.open(this.indexLayer, (IProjectId)this.projectId);
            new CommitDescriptorMerger(commitDescriptorIndex, commitChildrenIndex, this.schedulingHelper).storeCommit((ParentedCommitDescriptor)outputCommit, trigger.commitsNeedParentAdjustmentForPreviouslyForkedCommits());
            if (outputCommit instanceof RichCommitDescriptor) {
                this.scheduleJobsFromHints(scheduledJob, (RichCommitDescriptor)outputCommit);
            }
        }
    }

    private void assignDeltaToJob(ScheduledJob scheduledJob, CommitDescriptor outputCommit, AnalysisTrigger trigger, String store, long deltaId, @Nullable Long virtualStoreId) throws StorageException {
        if (this.schedulingHelper.getJobQueue().assignDeltaToExistingJob(trigger, store, deltaId, virtualStoreId, outputCommit, this.schedulingHelper.getIdGenerator())) {
            return;
        }
        JobDescriptor newJob = new JobDescriptor(this.projectId, ETriggerType.BLOCK, trigger.getName(), JobCompletionSupport.createCleanParentedCommitDescriptor(outputCommit), scheduledJob.getJob().isRollbackRelevant(), "Scheduling due to delta from store " + store, trigger.isCancelable());
        this.schedulingHelper.scheduleJobWithInputDelta(newJob, (Pair<String, Long>)Pair.createPair((Object)store, (Object)deltaId), virtualStoreId);
    }

    private static CommitDescriptor createCleanParentedCommitDescriptor(CommitDescriptor commit) {
        UnmodifiableList parents = Collections.emptyList();
        if (commit instanceof ParentedCommitDescriptor) {
            parents = ((ParentedCommitDescriptor)commit).getParentCommits();
        }
        return new ParentedCommitDescriptor(commit, (List)parents);
    }

    private void scheduleJobsFromHints(ScheduledJob scheduledJob, RichCommitDescriptor richOutputCommit) throws StorageException, TriggerCompilationException {
        CCSMAssert.isTrue((boolean)JobQueue.isPreAnnouncingTrigger(this.schedulingHelper.getTriggerCache(), scheduledJob), (String)"Only a pre-announcing triggers may output a rich commit descriptor.");
        JobDescriptor job = scheduledJob.getJob();
        for (CommitDescriptor schedulingHint : richOutputCommit.getSchedulingHints()) {
            if (this.schedulingHelper.existsJob(job.getTriggerName(), schedulingHint, true)) continue;
            this.schedulingHelper.scheduleJob(new JobDescriptor(this.projectId, job.getTriggerType(), job.getTriggerName(), schedulingHint, job.isRollbackRelevant(), "Scheduled due to scheduling hint " + String.valueOf(schedulingHint), job.isCancelable()));
        }
        this.schedulingHelper.getJobQueue().insertPreAnnouncements(scheduledJob.getTriggerName(), richOutputCommit.getSchedulingPreAnnouncements());
    }

    private void completeEmptyDeltaJob(ScheduledJob scheduledJob, CommitDescriptor outputCommit) throws TriggerCompilationException, StorageException {
        ITrigger trigger = this.schedulingHelper.getTriggerCache().getTrigger(scheduledJob);
        if (!trigger.isPeriodic()) {
            return;
        }
        if (outputCommit instanceof RichCommitDescriptor) {
            this.scheduleJobsFromHints(scheduledJob, (RichCommitDescriptor)outputCommit);
        } else if (trigger.isRunToExhaustion()) {
            this.periodicJobSupport.markTriggerAsExhausted(scheduledJob.getTriggerName());
        }
    }

    private boolean executePostExecutionSteps(ScheduledJob scheduledJob, JobExecutionResult executionResult, Consumer<Throwable> errorHandler) throws TriggerCompilationException, StorageException {
        PostRevisionCommitDescriptor postRevisionCommitDescriptor;
        String changeRetrieverToReschedule;
        CommitDescriptor outputCommit = executionResult.getOutputCommit();
        if (RichCommitDescriptor.isScheduleExternalDataTriggers(outputCommit)) {
            this.scheduleExternalDataTriggers();
        }
        if (PostRevisionCommitDescriptor.isReschedulePostRevisionTriggers(outputCommit)) {
            if (PostRevisionCommitDescriptor.isSchedulePostBuildCompletenessTriggers(outputCommit)) {
                this.schedulePostBuildCompletenessTriggers();
            }
            this.reschedulePostRevisionTriggers((PostRevisionCommitDescriptor)outputCommit, scheduledJob, errorHandler);
        }
        if (outputCommit instanceof PostRevisionCommitDescriptor && (changeRetrieverToReschedule = (postRevisionCommitDescriptor = (PostRevisionCommitDescriptor)outputCommit).getChangeRetrieverToReschedule()) != null) {
            this.rescheduleChangeRetriever(scheduledJob, changeRetrieverToReschedule);
        }
        ITrigger trigger = this.schedulingHelper.getTriggerCache().getTrigger(scheduledJob);
        if (!this.periodicJobSupport.isInvalid()) {
            this.schedulingHelper.getProgress().updateProgressForCompletedJob(scheduledJob.getJob(), trigger, this.schedulingHelper.getJobQueue(), this.schedulingHelper.getAssignedJobs());
            if (trigger.isPeriodic() && !JobCompletionSupport.isJobWithEmptyOutputDelta(executionResult)) {
                this.schedulePostRevisionTriggers(outputCommit, scheduledJob, errorHandler);
            }
        }
        return this.executePostTriggerAction(outputCommit, trigger);
    }

    private boolean executePostTriggerAction(CommitDescriptor outputCommit, ITrigger trigger) throws StorageException, TriggerCompilationException, AssertionError {
        switch (trigger.getPostTriggerSchedulerAction()) {
            case NONE: {
                return false;
            }
            case DISCARD_PENDING_FUTURE_JOBS: {
                this.discardScheduledJobs(outputCommit);
                this.periodicJobSupport.schedulePeriodicJobs(0L, true);
                return false;
            }
            case DELETE_PROJECT: {
                this.periodicJobSupport.markInvalid();
                this.discardScheduledJobs(null);
                return true;
            }
            case REANALYZE_PROJECT: {
                this.performReanalysis();
                return true;
            }
        }
        throw new AssertionError((Object)("Unknown action: " + String.valueOf((Object)trigger.getPostTriggerSchedulerAction())));
    }

    private void performRequestedRollback(JobDescriptor job, RollbackRequestedCommitDescriptor outputCommit) throws StorageException {
        LOGGER.warn(() -> new RollbackLogMessage("Performing rollback on request of trigger " + job.getTriggerName() + " to " + String.valueOf((Object)outputCommit) + " in project " + String.valueOf(this.projectId) + ". " + outputCommit.getRollbackReason(), outputCommit.getRollbackId()));
        this.schedulingHelper.scheduleRollback((CommitDescriptor)outputCommit, outputCommit.getRollbackReason(), outputCommit.getRollbackId(), job);
    }

    private void scheduleExternalDataTriggers() throws StorageException {
        for (AnalysisTrigger trigger : this.schedulingHelper.getTriggerCache().getExternalDataTriggers()) {
            if (!trigger.isExternalDataTrigger() || this.schedulingHelper.getJobQueue().existsJobForCommit(trigger.getName(), null)) continue;
            this.schedulingHelper.scheduleJob(new JobDescriptor(this.projectId, ETriggerType.BLOCK, trigger.getName(), null, trigger.isRollbackRelevant(), "Scheduled as external data trigger.", trigger.isCancelable()));
        }
    }

    private void schedulePostBuildCompletenessTriggers() throws StorageException {
        for (AnalysisTrigger analysisTrigger : this.schedulingHelper.getTriggerCache().getPostBuildCompletenessTriggers()) {
            if (!analysisTrigger.isPostBuildCompletenessTrigger() || this.schedulingHelper.getJobQueue().existsJobForCommit(analysisTrigger.getName(), null)) continue;
            this.schedulingHelper.scheduleJob(new JobDescriptor(this.projectId, ETriggerType.BLOCK, analysisTrigger.getName(), null, analysisTrigger.isRollbackRelevant(), "Scheduled as post build completeness trigger.", analysisTrigger.isCancelable()));
        }
    }

    private void reschedulePostRevisionTriggers(PostRevisionCommitDescriptor commitDescriptor, ScheduledJob scheduledJob, Consumer<Throwable> errorHandler) throws StorageException {
        for (CommitDescriptor commit : commitDescriptor.getPostRevisionTriggerHints()) {
            this.schedulePostRevisionTriggers(commit, scheduledJob, errorHandler);
        }
    }

    private void rescheduleChangeRetriever(ScheduledJob scheduledJob, String changeRetrieverToReschedule) throws StorageException {
        if (!this.schedulingHelper.existsJobWithoutSchedulingCommit(changeRetrieverToReschedule)) {
            this.schedulingHelper.scheduleJob(new JobDescriptor(this.projectId, ETriggerType.BLOCK, changeRetrieverToReschedule, null, false, "Analysis step '" + String.valueOf(scheduledJob) + "' requested repository change retriever reschedule.", false));
        }
    }

    private void schedulePostRevisionTriggers(CommitDescriptor commit, ScheduledJob scheduledJob, Consumer<Throwable> errorHandler) throws StorageException {
        if (PreCommitUtils.isPrecommitCommit(commit)) {
            return;
        }
        commit = JobCompletionSupport.createCleanParentedCommitDescriptor(commit);
        BranchAnalysisStateIndex index = this.indexLayer.openNonHistorizedProjectIndex(BranchAnalysisStateIndex.class, (IProjectId)this.projectId);
        AnalysisState analysisState = index.getAnalysisState(commit.getBranchName());
        if (analysisState == null) {
            errorHandler.accept((Throwable)((Object)new AssertionError((Object)("Skipping scheduling of post revision triggers due to missing analysis state for " + String.valueOf(scheduledJob) + ".\nindex.getAnalysisState(" + commit.getBranchName() + ") returned null, based on the commit " + String.valueOf(commit)))));
            return;
        }
        TriggerIndex triggerIndex = this.indexLayer.openNonHistorizedProjectIndex(TriggerIndex.class, (IProjectId)this.projectId);
        for (Class<? extends PostRevisionAnalysisTriggerBase> triggerClass : triggerIndex.getPostRevisionAnalysisTriggers(analysisState.getState())) {
            if (this.schedulingHelper.existsJob(triggerClass.getName(), commit, true)) continue;
            this.schedulingHelper.scheduleJob(new JobDescriptor(this.projectId, triggerClass, commit, "Post revision trigger for commit " + String.valueOf(commit)));
        }
    }

    private void discardScheduledJobs(CommitDescriptor preserveCommit) throws StorageException {
        this.periodicJobSupport.resetExecutionCounts();
        Pair<Set<Long>, Set<Long>> deltaIdsAndVirtualIdsToRemove = this.getDeltaIdsAndVirtualIdsToRemove(preserveCommit);
        if (!((Set)deltaIdsAndVirtualIdsToRemove.getFirst()).isEmpty()) {
            this.deltaIndex.removeDeltas(new ArrayList<Long>((Collection)deltaIdsAndVirtualIdsToRemove.getFirst()));
        }
        if (!((Set)deltaIdsAndVirtualIdsToRemove.getSecond()).isEmpty()) {
            this.virtualStoreIndex.discardVirtualStores((Collection)deltaIdsAndVirtualIdsToRemove.getSecond());
        }
    }

    private Pair<Set<Long>, Set<Long>> getDeltaIdsAndVirtualIdsToRemove(CommitDescriptor preserveCommit) throws StorageException {
        if (this.periodicJobSupport.isInvalid()) {
            Set deltaIds = this.schedulingHelper.getJobQueue().getAllJobs().stream().flatMap(job -> job.getInputDeltaIds().stream()).collect(Collectors.toSet());
            Set virtualStoreIds = this.schedulingHelper.getJobQueue().getAllJobs().stream().flatMap(job -> job.getAllVirtualStoreIds().stream()).collect(Collectors.toSet());
            return Pair.createPair(deltaIds, virtualStoreIds);
        }
        Map<String, Long> timestampForBranch = JobCompletionSupport.buildTimestampForBranchMap(preserveCommit);
        for (Map.Entry<String, Long> entry : timestampForBranch.entrySet()) {
            this.schedulingHelper.getProgress().discardFutureProgress(entry.getKey(), entry.getValue());
        }
        return this.schedulingHelper.getJobQueue().discardScheduledJobs(preserveCommit, timestampForBranch);
    }

    private static Map<String, Long> buildTimestampForBranchMap(CommitDescriptor preserveCommit) {
        if (preserveCommit == null) {
            return Collections.emptyMap();
        }
        CCSMAssert.isTrue((boolean)(preserveCommit instanceof RollbackTrigger.PostRollbackCommitDescriptor), (String)"Rollback output commit must be a PostRollbackCommitDescriptor.");
        return ((RollbackTrigger.PostRollbackCommitDescriptor)preserveCommit).getTimestampForBranch();
    }

    private void performReanalysis() throws StorageException, TriggerCompilationException {
        this.periodicJobSupport.markInvalid();
        this.discardScheduledJobs(null);
        this.recreateProject();
    }

    private void recreateProject() throws StorageException, TriggerCompilationException {
        ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfigurationWithoutEmbeddedProfile(this.indexLayer.openProjectStorageSystem((IProjectId)this.projectId));
        TransactionHandler transactionHandler = new TransactionHandler(this.indexLayer.getStorageCacheProvider(), InMemoryStore::new);
        LocalMessageBroker messageBroker = new LocalMessageBroker();
        StorageCacheProvider cacheProvider = StorageCacheRegistry.createCacheProvider((IMessageBroker)messageBroker);
        IndexLayer transactionalIndexLayer = new IndexLayer(transactionHandler.decorate(this.indexLayer.getRawStorageSystemProvider()), cacheProvider, (IMessageBroker)messageBroker);
        try {
            ProjectIndex projectIndex = transactionalIndexLayer.openProjectIndex();
            projectIndex.removeProject(this.projectId);
            new ProjectCreator(transactionalIndexLayer, ConfigurationInitializationContext.EInitializationReason.PROJECT_REANALYSIS).createProject(projectConfiguration, false, false, false);
            transactionHandler.commit();
        }
        catch (ProjectConfigurationException e) {
            LOGGER.error("Error re-creating project: {}", (Object)projectConfiguration.getName(), (Object)e);
            transactionHandler.rollback();
        }
    }
}

