/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.utils;

import com.teamscale.core.utils.VelocityEngineUtils;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.ByteUnit;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.io.ChunkOutputStream;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.VisibleForTesting;
import org.jsoup.Jsoup;

public final class HttpRequestUtils {
    private static final int MAX_PART_SIZE = 0x7FFFFFF7;
    private static final int BUFFER_SIZE = (int)ByteUnit.BYTES.toBytes(1024L);

    public static byte[] readInputStreamEnsuringSizeLimit(InputStream inputStream, String fileName) throws IOException {
        return HttpRequestUtils.readInputStreamEnsuringSizeLimit(inputStream, fileName, 0x7FFFFFF7);
    }

    @VisibleForTesting
    public static byte[] readInputStreamEnsuringSizeLimit(InputStream inputStream, String fileName, int sizeLimitInBytes) throws IOException, BadRequestException {
        try (ChunkOutputStream outputStream = new ChunkOutputStream();){
            byte[] buffer = new byte[BUFFER_SIZE];
            long bytesReadTotal = 0L;
            boolean streamEnded = false;
            do {
                int bytesRead;
                if ((bytesRead = inputStream.read(buffer)) == -1) {
                    streamEnded = true;
                    continue;
                }
                bytesReadTotal += (long)bytesRead;
                outputStream.write(buffer, 0, bytesRead);
            } while (!streamEnded && bytesReadTotal <= (long)sizeLimitInBytes);
            List chunks = outputStream.getChunks();
            if (chunks.isEmpty()) {
                byte[] byArray = new byte[]{};
                return byArray;
            }
            HttpRequestUtils.truncateLastChunk(chunks, outputStream.getLastChunkSize(), outputStream.getChunkSize());
            if (bytesReadTotal > (long)sizeLimitInBytes) {
                throw new BadRequestException("Size of request part '" + fileName + "' exceeds maximum allowed size of " + ByteUnit.BYTES.toMebiBytes((long)sizeLimitInBytes) + " " + ByteUnit.MEBIBYTES.getAbbreviation());
            }
            byte[] byArray = ByteArrayUtils.concat((Iterable)chunks);
            return byArray;
        }
    }

    private static void truncateLastChunk(List<byte[]> chunks, int lastChunkSize, int chunkSize) {
        if (lastChunkSize < chunkSize) {
            int lastChunkIndex = chunks.size() - 1;
            byte[] truncatedLastChunk = ByteArrayUtils.truncate((byte[])chunks.get(lastChunkIndex), (int)lastChunkSize);
            chunks.set(lastChunkIndex, truncatedLastChunk);
        }
    }

    public static String readContent(ContainerRequestContext request) throws IOException {
        InputStream inputStream = request.getEntityStream();
        Charset charset = Optional.ofNullable(request.getMediaType()).map(mediaType -> (String)mediaType.getParameters().get("charset")).map(Charset::forName).orElse(StandardCharsets.UTF_8);
        return FileSystemUtils.readStream((InputStream)inputStream, (Charset)charset);
    }

    public static @NonNull String createParameterString(ContainerRequestContext requestContext) {
        StringBuilder message = new StringBuilder();
        MultivaluedMap parameterMap = requestContext.getUriInfo().getQueryParameters();
        if (!parameterMap.isEmpty()) {
            ArrayList parameters = new ArrayList(parameterMap.keySet());
            for (int i = 0; i < parameters.size(); ++i) {
                if (i != 0) {
                    message.append(' ');
                }
                message.append((String)parameters.get(i)).append("=[").append(StringUtils.concat((Iterable)((Iterable)parameterMap.get(parameters.get(i))), (String)",")).append("]");
            }
        }
        return message.toString();
    }

    public static String getHttp404ErrorPageHtml(ContainerRequestContext requestContext) {
        String requestUrl = requestContext.getUriInfo().getRequestUri().toString();
        return VelocityEngineUtils.renderTemplate("html_pages/NotFoundPage.vm", Map.of("url", requestUrl));
    }

    public static String getHttpExceptionPage(ContainerRequestContext requestContext, Response.Status code, Throwable e) {
        StringBuilder builder = new StringBuilder();
        if (HttpRequestUtils.shouldHideStacktrace(code)) {
            builder.append("HTTP Status Code: ").append(code.getStatusCode()).append(" ").append(code.getReasonPhrase()).append(StringUtils.LINE_SEPARATOR);
            builder.append("Message: ").append(HttpRequestUtils.extractMessage(e));
            return builder.toString();
        }
        builder.append("Request: ").append(requestContext.getMethod()).append(" ").append(requestContext.getUriInfo().getRequestUri()).append(StringUtils.LINE_SEPARATOR);
        builder.append("Headers:").append(StringUtils.LINE_SEPARATOR);
        for (String headerName : CollectionUtils.sort((Collection)requestContext.getHeaders().keySet())) {
            String headerValue = requestContext.getHeaderString(headerName);
            if (headerName.equals("Authorization")) {
                headerValue = "<REMOVED>";
            }
            builder.append("\t").append(headerName).append(" = ").append(headerValue).append(StringUtils.LINE_SEPARATOR);
        }
        builder.append(StringUtils.LINE_SEPARATOR);
        builder.append("HTTP Status Code: ").append(code.getStatusCode()).append(" ").append(code.getReasonPhrase()).append(StringUtils.LINE_SEPARATOR);
        builder.append("Message: ").append(HttpRequestUtils.extractMessage(e)).append(StringUtils.LINE_SEPARATOR);
        builder.append("Exception:").append(StringUtils.LINE_SEPARATOR).append(StringUtils.LINE_SEPARATOR);
        builder.append(StringUtils.obtainStackTrace((Throwable)e));
        return builder.toString();
    }

    private static boolean shouldHideStacktrace(Response.Status code) {
        if (code == Response.Status.REQUEST_ENTITY_TOO_LARGE) {
            return true;
        }
        return !EFeatureToggle.ENABLE_DEV_MODE.isEnabled();
    }

    private static String extractMessage(Throwable e) {
        if (e instanceof WebApplicationException && e.getMessage().startsWith("HTTP ") && e.getCause() != null) {
            return e.getCause().getMessage();
        }
        return e.getMessage();
    }

    public static boolean isHtmlRequest(ContainerRequestContext requestContext) {
        return requestContext.getAcceptableMediaTypes().stream().anyMatch(m -> m.isCompatible(MediaType.TEXT_HTML_TYPE)) && !requestContext.getUriInfo().getPath().startsWith("p/") && !requestContext.getUriInfo().getPath().startsWith("api/");
    }

    @Contract(value="null -> null; !null -> !null")
    public static String removeHtmlTags(@Nullable String text) {
        if (text == null) {
            return null;
        }
        return Jsoup.parse((String)text).wholeText().trim();
    }

    private HttpRequestUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

