/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class InstanceComparisonSnapshotCreationOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String USERNAME_PROPERTY = "username";
    private static final String PROJECTS_OR_ALIASES_PROPERTY = "projectsOrAliases";
    private static final String PROJECT_INCLUSION_PATTERN_PROPERTY = "projectInclusionPattern";
    private static final String PROJECT_EXCLUSION_PATTERN_PROPERTY = "projectExclusionPattern";
    private static final String END_TIMESTAMP_PROPERTY = "endTimestamp";
    private static final String DETAILED_SNAPSHOT_PROPERTY = "detailed";
    private static final String BRANCH_NAME_PROPERTY = "branchName";
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="projectsOrAliases")
    private final List<PublicProjectId> projectIds;
    @JsonProperty(value="projectInclusionPattern")
    private final @Nullable String projectInclusionPattern;
    @JsonProperty(value="projectExclusionPattern")
    private final @Nullable String projectExclusionPattern;
    @JsonProperty(value="endTimestamp")
    private final long endTimestamp;
    @JsonProperty(value="detailed")
    private final boolean detailedSnapshot;
    @JsonProperty(value="branchName")
    private final @Nullable String branchName;

    @JsonCreator
    public InstanceComparisonSnapshotCreationOptions(@JsonProperty(value="username") String username, @JsonProperty(value="projectsOrAliases") @NonNull List<PublicProjectId> projectIds, @JsonProperty(value="projectInclusionPattern") @Nullable String projectInclusionPattern, @JsonProperty(value="projectExclusionPattern") @Nullable String projectExclusionPattern, @JsonProperty(value="endTimestamp") Long endTimestamp, @JsonProperty(value="detailed") boolean detailedSnapshot, @JsonProperty(value="branchName") @Nullable String branchName) {
        this.username = username;
        this.projectIds = projectIds;
        this.projectInclusionPattern = projectInclusionPattern;
        this.projectExclusionPattern = projectExclusionPattern;
        this.endTimestamp = endTimestamp;
        this.detailedSnapshot = detailedSnapshot;
        this.branchName = branchName;
    }

    public String getUsername() {
        return this.username;
    }

    public @Nullable String getProjectInclusionPattern() {
        return this.projectInclusionPattern;
    }

    public @Nullable String getProjectExclusionPattern() {
        return this.projectExclusionPattern;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    public List<PublicProjectId> getFilteredProjectsIds() {
        IncludeExcludeRegexSupport filteringSupport = new IncludeExcludeRegexSupport();
        if (!StringUtils.isEmpty((String)this.projectInclusionPattern)) {
            filteringSupport.addIncludePattern(this.projectInclusionPattern);
        }
        if (!StringUtils.isEmpty((String)this.projectExclusionPattern)) {
            filteringSupport.addExcludePattern(this.projectExclusionPattern);
        }
        return CollectionUtils.filter(this.projectIds, projectId -> filteringSupport.isIncluded(projectId.toString()));
    }

    public boolean isDetailedSnapshot() {
        return this.detailedSnapshot;
    }

    public @Nullable String getBranchName() {
        return this.branchName;
    }
}

