/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot;

import com.teamscale.index.admin.instance_comparison.EInstanceComparisonStatus;
import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonSnapshotCreationOptions;
import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonSnapshotDto;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public final class InstanceComparisonSnapshotMetaData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String id;
    private EInstanceComparisonStatus status = EInstanceComparisonStatus.IN_PROGRESS;
    private @Nullable String error;
    private final InstanceComparisonSnapshotCreationOptions options;
    private final long createdOn;
    private final String instanceName;

    public InstanceComparisonSnapshotMetaData(String id, InstanceComparisonSnapshotCreationOptions options, long createdOn, String instanceName) {
        this.id = id;
        this.options = options;
        this.createdOn = createdOn;
        this.instanceName = instanceName;
    }

    public InstanceComparisonSnapshotMetaData(InstanceComparisonSnapshotDto dto) {
        this.id = dto.id();
        this.status = dto.status();
        this.error = dto.error();
        this.options = dto.options();
        this.createdOn = dto.createdOn();
        this.instanceName = dto.instanceName();
    }

    public String getId() {
        return this.id;
    }

    public EInstanceComparisonStatus getStatus() {
        return this.status;
    }

    public @Nullable String getError() {
        return this.error;
    }

    public InstanceComparisonSnapshotCreationOptions getOptions() {
        return this.options;
    }

    public long getCreatedOn() {
        return this.createdOn;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setFailed(Throwable error) {
        this.verifyInProgress();
        this.error = error.getMessage();
        this.status = EInstanceComparisonStatus.FAILURE;
    }

    public void setCompleted() {
        this.verifyInProgress();
        this.status = EInstanceComparisonStatus.SUCCESS;
    }

    private void verifyInProgress() {
        if (this.status != EInstanceComparisonStatus.IN_PROGRESS) {
            throw new IllegalStateException("Expected status to be %s but was %s".formatted(new Object[]{EInstanceComparisonStatus.IN_PROGRESS, this.status}));
        }
    }
}

