/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions.project;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.FilePathsComparisonContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.IComparisonContributorContext;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.ProjectComparisonContributorBase;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import java.util.Map;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

public class FilePathsComparisonContributor
extends ProjectComparisonContributorBase {
    public FilePathsComparisonContributor(IComparisonContributorContext.ProjectContext context) {
        super(context);
    }

    @Override
    public FilePathsComparisonContribution createComparisonInput() throws StorageException {
        TokenElementIndex contentIndex = (TokenElementIndex)this.getProjectStorageSystem().openProjectIndex(TokenElementIndex.class, "content", this.getHistoryAccessOption());
        PairList<String, TokenElementInfo> contentEntries = contentIndex.getAllTokenElements();
        return new FilePathsComparisonContribution("File Contents", ((IComparisonContributorContext.ProjectContext)this.context).publicProjectId().toString(), FilePathsComparisonContributor.hashEntries(contentEntries));
    }

    private static Map<String, String> hashEntries(PairList<String, TokenElementInfo> contentEntries) {
        return contentEntries.mapSecond(FilePathsComparisonContributor::hashContent).toMap();
    }

    private static String hashContent(TokenElementInfo tokenInfo) {
        return Hashing.murmur3_128().newHasher().putString((CharSequence)tokenInfo.getText(), Charsets.UTF_8).hash().toString();
    }
}

