/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.architecture.ArchitectureReferenceIndex;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.architecture.scope.ArchitectureDefinitionReader;
import com.teamscale.index.dependencies.ProjectModuleIndex;
import com.teamscale.index.dependencies.TypeDependencyIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class ArchitectureReferenceDependenciesSynchronizer
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="content")
    private TokenElementIndex contentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ArchitectureReferenceIndex architectureReferenceIndex;
    @DeltaSource(value=TypeDependencyIndex.class)
    private KeyDelta typeDependencyDelta;
    @DeltaSource(value=ProjectModuleIndex.class)
    private KeyDelta projectModuleDelta;

    public void execute() throws StorageException {
        List<String> architecturePaths = this.architectureReferenceIndex.getAllArchitectures();
        List<TokenElementInfo> existingArchitectures = this.contentIndex.getTokenElements(architecturePaths);
        PairList values = new PairList();
        for (int i = 0; i < architecturePaths.size(); ++i) {
            IncludeExcludeRegexSupport scopeIncludeSupport;
            ArchitectureDefinition architecture;
            String architecturePath = architecturePaths.get(i);
            if (existingArchitectures.get(i) == null) continue;
            try {
                architecture = ArchitectureDefinitionReader.read(existingArchitectures.get(i).getUniformPath(), existingArchitectures.get(i).getText());
            }
            catch (ConQATException e) {
                LOGGER.error("Failed to parse architecture " + existingArchitectures.get(i).getUniformPath() + ": " + e.getMessage() + ". Skipping this one!", (Throwable)e);
                continue;
            }
            if (this.projectModuleDelta.isEmpty() && architecture.isFileBased() && !this.isDependencyDeltaInArchitectureScope(scopeIncludeSupport = ArchitectureReferenceDependenciesSynchronizer.getArchitectureScopeIncludeExcludeSupport(architecture))) continue;
            values.add((Object)architecturePath, (Object)this.getSchedulingCommit().getTimestamp());
        }
        if (!values.isEmpty()) {
            this.architectureReferenceIndex.setArchitecturesAndChanges((PairList<String, Long>)values);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDependencyDeltaInArchitectureScope(IncludeExcludeRegexSupport scopeIncludeSupport) {
        if (scopeIncludeSupport.getIncludePatterns().isEmpty()) return true;
        if (CollectionUtils.anyMatch((Collection)this.typeDependencyDelta.getAddedOrChangedKeysAsStrings(), arg_0 -> ((IncludeExcludeRegexSupport)scopeIncludeSupport).isIncluded(arg_0))) return true;
        if (!CollectionUtils.anyMatch((Collection)this.typeDependencyDelta.getDeletedKeysAsStrings(), arg_0 -> ((IncludeExcludeRegexSupport)scopeIncludeSupport).isIncluded(arg_0))) return false;
        return true;
    }

    private static IncludeExcludeRegexSupport getArchitectureScopeIncludeExcludeSupport(ArchitectureDefinition architecture) {
        IncludeExcludeRegexSupport includeSupport = new IncludeExcludeRegexSupport();
        if (!StringUtils.isEmpty((String)architecture.getScopeIncludePattern())) {
            includeSupport.addIncludePattern(architecture.getScopeIncludePattern());
            includeSupport.addExcludePattern(architecture.getScopeExcludePattern());
        }
        return includeSupport;
    }
}

