/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class TypeDependencyInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String TO_PROPERTY = "to";
    protected static final String FROM_PROPERTY = "from";
    protected static final String TO_PATH_PROPERTY = "toPath";
    protected static final String FROM_PATH_PROPERTY = "fromPath";
    @JsonProperty(value="from")
    private final String from;
    @JsonProperty(value="to")
    private final String to;
    @JsonProperty(value="fromPath")
    private final String fromPath;
    @JsonProperty(value="toPath")
    private final String toPath;

    @JsonCreator
    public TypeDependencyInfo(@JsonProperty(value="from") String from, @JsonProperty(value="to") String to, @JsonProperty(value="fromPath") String fromPath, @JsonProperty(value="toPath") String toPath) {
        CCSMAssert.isNotNull((Object)from);
        CCSMAssert.isNotNull((Object)to);
        this.from = from;
        this.to = to;
        this.fromPath = Optional.ofNullable(fromPath).orElse(from);
        this.toPath = Optional.ofNullable(toPath).orElse(to);
    }

    public String getTo() {
        return this.to;
    }

    public String getToPath() {
        return this.toPath;
    }

    public String getFrom() {
        return this.from;
    }

    public String getFromPath() {
        return this.fromPath;
    }

    public String toString() {
        return this.from + " -> " + this.to + " (" + this.fromPath + " -> " + this.toPath + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeDependencyInfo that = (TypeDependencyInfo)o;
        return Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to) && Objects.equals(this.fromPath, that.fromPath) && Objects.equals(this.toPath, that.toPath);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to, this.fromPath, this.toPath);
    }
}

